/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable.model;

import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TSURL;
import java.util.StringTokenizer;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PutTapeRecallStatusValidator {
    private static final Logger log = LoggerFactory.getLogger(PutTapeRecallStatusValidator.class);
    private String requestToken = null;
    private StoRI stori = null;
    private String inputString = null;
    private Response validationResponse = null;

    public PutTapeRecallStatusValidator(String inputString) {
        this.inputString = inputString;
    }

    public boolean validate() {
        StringTokenizer tokenizer = new StringTokenizer(this.inputString, "\n");
        if (tokenizer.countTokens() != 2) {
            log.trace("putTaskStatus() - input error");
            this.validationResponse = Response.status((int)400).build();
            return false;
        }
        String requestTokenInput = tokenizer.nextToken();
        String surlInput = tokenizer.nextToken();
        if (!requestTokenInput.startsWith("requestToken=") || !surlInput.startsWith("surl=")) {
            log.trace("putTaskStatus() - input error");
            this.validationResponse = Response.status((int)400).build();
            return false;
        }
        this.requestToken = requestTokenInput.substring(requestTokenInput.indexOf(61) + 1);
        String surlString = surlInput.substring(surlInput.indexOf(61) + 1);
        if (this.requestToken.length() == 0 || surlString.length() == 0) {
            log.trace("putTaskStatus() - input error");
            this.validationResponse = Response.status((int)400).build();
            return false;
        }
        return this.validateSurl(surlString);
    }

    public String getRequestToken() {
        return this.requestToken;
    }

    public StoRI getStoRI() {
        return this.stori;
    }

    public Response getResponse() {
        return this.validationResponse;
    }

    private boolean validateSurl(String surlString) {
        TSURL surl;
        try {
            surl = TSURL.makeFromStringValidate(surlString);
        }
        catch (InvalidTSURLAttributesException e) {
            this.validationResponse = Response.status((int)400).build();
            return false;
        }
        try {
            this.stori = NamespaceDirector.getNamespace().resolveStoRIbySURL(surl);
        }
        catch (UnapprochableSurlException e) {
            log.warn("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
            return false;
        }
        return true;
    }
}

