/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.tape.recalltable;

import it.grid.storm.asynch.Suspendedable;
import it.grid.storm.catalogs.BoLPersistentChunkData;
import it.grid.storm.catalogs.PersistentChunkData;
import it.grid.storm.catalogs.PtGData;
import it.grid.storm.catalogs.RequestData;
import it.grid.storm.persistence.PersistenceDirector;
import it.grid.storm.persistence.dao.TapeRecallDAO;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeRecallCatalog {
    private static final Logger log = LoggerFactory.getLogger(TapeRecallCatalog.class);
    private final TapeRecallDAO tapeRecallDAO = PersistenceDirector.getDAOFactory().getTapeRecallDAO();
    private static ConcurrentHashMap<UUID, Collection<Suspendedable>> recallBuckets = new ConcurrentHashMap();

    public void changeGroupTaskRetryValue(UUID groupTaskId, int newValue) {
        try {
            this.tapeRecallDAO.setGroupTaskRetryValue(groupTaskId, newValue);
        }
        catch (DataAccessException e) {
            log.error("Unable to takeover a task", (Throwable)e);
        }
    }

    public int getNumberTaskInProgress() throws DataAccessException {
        int result = -1;
        try {
            result = this.tapeRecallDAO.getNumberInProgress();
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve the number of tasks currently in progress. DataAccessException: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public int getNumberTaskInProgress(String voName) throws DataAccessException {
        int result = -1;
        try {
            result = this.tapeRecallDAO.getNumberInProgress(voName);
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve the number of tasks currently in progress. DataAccessException: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public int getNumberTaskQueued() throws DataAccessException {
        int result = -1;
        try {
            result = this.tapeRecallDAO.getNumberQueued();
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve the number of tasks queued. DataAccessException: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public int getNumberTaskQueued(String voName) throws DataAccessException {
        int result = -1;
        try {
            result = this.tapeRecallDAO.getNumberQueued(voName);
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve the number of tasks queued. DataAccessException: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public int getReadyForTakeOver() throws DataAccessException {
        int result = -1;
        try {
            result = this.tapeRecallDAO.getReadyForTakeOver();
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve the number of tasks ready for the take-over. DataAccessException: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public int getReadyForTakeOver(String voName) throws DataAccessException {
        int result = -1;
        try {
            result = this.tapeRecallDAO.getReadyForTakeOver(voName);
        }
        catch (DataAccessException e) {
            log.error("Unable to retrieve the number of tasks ready for the take-over. DataAccessException: " + e.getMessage());
            throw e;
        }
        return result;
    }

    public TapeRecallTO getTask(UUID taskId, String requestToken) throws DataAccessException {
        return this.tapeRecallDAO.getTask(taskId, requestToken);
    }

    public boolean existsTask(UUID taskId, String requestToken) throws DataAccessException {
        return this.tapeRecallDAO.existsTask(taskId, requestToken);
    }

    public List<TapeRecallTO> getGroupTasks(UUID groupTaskId) throws DataAccessException {
        return new ArrayList<TapeRecallTO>(this.tapeRecallDAO.getGroupTasks(groupTaskId));
    }

    public boolean existsGroupTask(UUID groupTaskId) throws DataAccessException {
        return this.tapeRecallDAO.existsGroupTask(groupTaskId);
    }

    public void purgeCatalog(int n) {
        try {
            log.debug("purging.. '" + n + "' tasks.");
            this.tapeRecallDAO.purgeCompletedTasks(n);
        }
        catch (DataAccessException e) {
            log.error("Unable to takeover a task", (Throwable)e);
        }
    }

    public ArrayList<TapeRecallTO> takeoverNTasksWithDoubles(int numberOfTaks) {
        ArrayList<TapeRecallTO> taskList = new ArrayList<TapeRecallTO>();
        try {
            taskList.addAll(this.tapeRecallDAO.takeoverTasksWithDoubles(numberOfTaks));
        }
        catch (DataAccessException e) {
            log.error("Unable to takeover " + numberOfTaks + " tasks", (Throwable)e);
        }
        return taskList;
    }

    public TapeRecallTO takeoverTask() {
        TapeRecallTO task = null;
        try {
            task = this.tapeRecallDAO.takeoverTask();
        }
        catch (DataAccessException e) {
            log.error("Unable to takeove a task.", (Throwable)e);
        }
        return task;
    }

    public TapeRecallTO takeoverTask(String voName) {
        TapeRecallTO task = null;
        try {
            task = this.tapeRecallDAO.takeoverTask(voName);
        }
        catch (DataAccessException e) {
            log.error("Unable to takeover a task for vo " + voName, (Throwable)e);
        }
        return task;
    }

    public List<TapeRecallTO> takeoverTasks(int numberOfTaks, String voName) {
        ArrayList<TapeRecallTO> taskList = new ArrayList<TapeRecallTO>();
        try {
            taskList.addAll(this.tapeRecallDAO.takeoverTasksWithDoubles(numberOfTaks, voName));
        }
        catch (DataAccessException e) {
            log.error("Unable to takeover " + numberOfTaks + " tasks for vo " + voName, (Throwable)e);
        }
        return taskList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID insertTask(Suspendedable chunk, String voName, String absoluteFileName) throws DataAccessException {
        UUID groupTaskId;
        TapeRecallTO task = this.getTaskFromChunk(chunk.getRequestData());
        task.setFileName(absoluteFileName);
        task.setVoName(voName);
        TapeRecallCatalog tapeRecallCatalog = this;
        synchronized (tapeRecallCatalog) {
            groupTaskId = this.insertNewTask(task);
            Collection<Suspendedable> chunkBucket = recallBuckets.get(groupTaskId);
            if (chunkBucket != null) {
                chunkBucket.add(chunk);
            } else {
                chunkBucket = new ConcurrentLinkedQueue<Suspendedable>();
                chunkBucket.add(chunk);
                recallBuckets.put(groupTaskId, chunkBucket);
            }
        }
        return groupTaskId;
    }

    public UUID insertNewTask(TapeRecallTO task) throws DataAccessException {
        UUID newGroupTaskId = UUID.randomUUID();
        UUID groupTaskId = this.tapeRecallDAO.insertCloneTask(task, new int[]{TapeRecallStatus.QUEUED.getStatusId(), TapeRecallStatus.IN_PROGRESS.getStatusId()}, newGroupTaskId);
        if (newGroupTaskId != groupTaskId) {
            log.debug("Task with taskId " + task.getTaskId() + " of request with token " + task.getRequestTokenStr() + " has benn added to an existentr group : " + groupTaskId);
        }
        return groupTaskId;
    }

    private TapeRecallTO getTaskFromChunk(RequestData chunkData) throws DataAccessException {
        TapeRecallTO task = new TapeRecallTO();
        Date currentDate = new Date();
        task.setInsertionInstant(currentDate);
        if (chunkData instanceof PtGData) {
            PtGData ptgChunk = (PtGData)chunkData;
            task.setRequestType("ptg");
            task.setPinLifetime((int)ptgChunk.getPinLifeTime().value());
            task.setDeferredRecallInstant(currentDate);
        } else if (chunkData instanceof BoLPersistentChunkData) {
            BoLPersistentChunkData bolChunk = (BoLPersistentChunkData)chunkData;
            task.setRequestType("bol");
            task.setPinLifetime((int)bolChunk.getLifeTime().value());
            Date deferredStartDate = new Date(currentDate.getTime() + (long)(bolChunk.getDeferredStartTime() * 1000));
            task.setDeferredRecallInstant(deferredStartDate);
        } else {
            throw new DataAccessException("Unable to build a TapeRecallTO because unknown chunk type.");
        }
        if (chunkData instanceof PersistentChunkData) {
            task.setRequestToken(((PersistentChunkData)chunkData).getRequestToken());
        } else {
            task.setFakeRequestToken();
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean changeGroupTaskStatus(UUID groupTaskId, TapeRecallStatus recallTaskStatus, Date timestamp) throws DataAccessException {
        boolean updated;
        Collection<Suspendedable> chunkBucket = null;
        TapeRecallCatalog tapeRecallCatalog = this;
        synchronized (tapeRecallCatalog) {
            updated = this.tapeRecallDAO.setGroupTaskStatus(groupTaskId, recallTaskStatus.getStatusId(), timestamp);
            if (updated) {
                if (recallTaskStatus == TapeRecallStatus.IN_PROGRESS || recallTaskStatus == TapeRecallStatus.QUEUED) {
                    log.warn("Setting the status to IN_PROGRESS or QUEUED using setGroupTaskStatus() is not a legal operation, doing it anyway. groupTaskId=" + groupTaskId);
                } else {
                    chunkBucket = recallBuckets.remove(groupTaskId);
                    if (chunkBucket == null) {
                        log.error("Unable to perform the final status update. No bucket found for Recall Group Task ID " + groupTaskId.toString());
                        throw new DataAccessException("Unable to perform the final status update. No bucket found for Recall Group Task ID " + groupTaskId.toString());
                    }
                }
            }
        }
        if (chunkBucket != null) {
            this.updateChuncksStatus(chunkBucket, recallTaskStatus);
        }
        return updated;
    }

    private void updateChuncksStatus(Collection<Suspendedable> chunkBucket, TapeRecallStatus recallTaskStatus) throws IllegalArgumentException {
        if (chunkBucket == null || chunkBucket.isEmpty() || recallTaskStatus == null) {
            log.error("Unable to perform the final status update. Provided invalid arguments");
            throw new IllegalArgumentException("Unable to perform the final status update. Provided invalid arguments");
        }
        for (Suspendedable chunk : chunkBucket) {
            chunk.completeRequest(recallTaskStatus);
        }
    }
}

