/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.surl;

import it.grid.storm.config.Configuration;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.ModifiableReturnStatus;
import it.grid.storm.synchcall.surl.TokenDuplicationException;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurlStatusStore {
    private static final Logger log = LoggerFactory.getLogger(SurlStatusStore.class);
    private HashMap<TSURL, Map<TRequestToken, ModifiableReturnStatus>> surlTokenStatusStore = new HashMap();
    private HashMap<TRequestToken, Map<TSURL, ModifiableReturnStatus>> tokenSurlStatusStore = new HashMap();
    private HashMap<TRequestToken, GridUserInterface> tokenUserStore = new HashMap();
    private ConcurrentSkipListMap<Long, TRequestToken> expirationTokenRegistry = new ConcurrentSkipListMap();
    private static final SurlStatusStore instance = new SurlStatusStore();
    private final ConcurrentHashMap<TSURL, ReentrantReadWriteLock> surlLockMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<TRequestToken, ReentrantReadWriteLock> tokenLockMap = new ConcurrentHashMap();
    private final ReentrantLock expirationTokenRegistryLock = new ReentrantLock();
    private final ReentrantLock tokenUserStoreLock = new ReentrantLock();
    private final Timer clock;
    private final TimerTask clockTask;

    private SurlStatusStore() {
        if (Configuration.getInstance().getExpiredRequestPurging()) {
            this.clock = new Timer();
            this.clockTask = new TimerTask(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            this.clock.scheduleAtFixedRate(this.clockTask, Configuration.getInstance().getRequestPurgerDelay() * 1000, (long)(Configuration.getInstance().getRequestPurgerPeriod() * 1000));
        } else {
            this.clock = null;
            this.clockTask = null;
        }
    }

    public static SurlStatusStore getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(TRequestToken requestToken, HashMap<TSURL, TReturnStatus> surlStatuses) throws IllegalArgumentException, TokenDuplicationException {
        if (requestToken == null || surlStatuses == null || surlStatuses.isEmpty()) {
            throw new IllegalArgumentException("unable to store the request, null arguments: requestToken=" + requestToken + " surlStatuses=" + surlStatuses);
        }
        ReentrantReadWriteLock.WriteLock writeLock = null;
        try {
            writeLock = this.writeLockIfNew(requestToken);
            if (writeLock == null) {
                if (this.verifyMissingToken(requestToken)) {
                    throw new IllegalStateException("Token " + requestToken + " has not a lock but is registerd in the store");
                }
                throw new TokenDuplicationException("Token " + requestToken + " is already stored");
            }
            if (this.tokenSurlStatusStore.containsKey(requestToken)) {
                log.warn("Token '" + requestToken + "' is already stored");
                throw new IllegalArgumentException("Provided token '" + requestToken + "'is already stored");
            }
            log.debug("Storing token " + requestToken);
            HashMap<TSURL, ModifiableReturnStatus> surlStatusMap = new HashMap<TSURL, ModifiableReturnStatus>(surlStatuses.size());
            for (Map.Entry<TSURL, TReturnStatus> entry : surlStatuses.entrySet()) {
                ModifiableReturnStatus status;
                if (entry.getKey() == null || entry.getValue() == null) {
                    this.removeLock(requestToken);
                    throw new IllegalArgumentException("Received invalid surl-status entry surl=" + entry.getKey() + " status=" + entry.getValue());
                }
                try {
                    status = new ModifiableReturnStatus(entry.getValue());
                }
                catch (InvalidTReturnStatusAttributeException e) {
                    this.removeLock(requestToken);
                    throw new IllegalArgumentException("Received invalid status for surl " + entry.getKey() + " InvalidTReturnStatusAttributeException: " + e.getMessage());
                }
                surlStatusMap.put(entry.getKey(), status);
            }
            for (Map.Entry<TSURL, TReturnStatus> entry : surlStatusMap.entrySet()) {
                log.debug("Storing surl " + entry.getKey() + " with status " + entry.getValue() + " for token " + requestToken);
                ReentrantReadWriteLock.WriteLock surlWriteLock = null;
                try {
                    surlWriteLock = this.writeLock(entry.getKey());
                    Map<TRequestToken, ModifiableReturnStatus> map = this.surlTokenStatusStore.get(entry.getKey());
                    if (map == null) {
                        map = new HashMap<TRequestToken, ModifiableReturnStatus>(1);
                        this.surlTokenStatusStore.put(entry.getKey(), map);
                    }
                    map.put(requestToken, (ModifiableReturnStatus)entry.getValue());
                }
                catch (Throwable throwable) {
                    this.unlockSurl(surlWriteLock);
                    throw throwable;
                }
                this.unlockSurl(surlWriteLock);
            }
            this.tokenSurlStatusStore.put(requestToken, surlStatusMap);
        }
        finally {
            if (writeLock != null) {
                this.unlockToken(writeLock);
            }
        }
        if (requestToken.hasExpirationDate()) {
            Long expiration = requestToken.getExpiration().getTimeInMillis();
            try {
                this.lockExpirationMap();
                boolean updated = false;
                while (this.expirationTokenRegistry.containsKey(expiration)) {
                    updated = true;
                    expiration = expiration + 1L;
                }
                if (updated) {
                    requestToken.updateExpiration(new Date(expiration));
                }
                this.expirationTokenRegistry.put(expiration, requestToken);
            }
            finally {
                this.unlockExpirationMap();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(TRequestToken requestToken, GridUserInterface user, HashMap<TSURL, TReturnStatus> surlStatuses) throws IllegalArgumentException, TokenDuplicationException {
        if (user == null) {
            throw new IllegalArgumentException("unable to store the request, null arguments: user=" + user);
        }
        this.store(requestToken, surlStatuses);
        try {
            this.lockTokenUserStore();
            this.tokenUserStore.put(requestToken, user);
        }
        finally {
            this.unlockTokenUserStore();
        }
    }

    public void update(TRequestToken requestToken, TSURL surl, TStatusCode newStatusCode) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        this.update(requestToken, surl, newStatusCode, "");
    }

    public void update(TRequestToken requestToken, TSURL surl, TStatusCode newStatusCode, String explanation) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        if (surl == null) {
            throw new IllegalArgumentException("unable to update the statuse, null arguments: surl=" + surl);
        }
        ArrayList<TSURL> surlList = new ArrayList<TSURL>(1);
        surlList.add(surl);
        this.update(requestToken, surlList, newStatusCode, explanation);
    }

    public void update(TRequestToken requestToken, List<TSURL> surls, TStatusCode newStatusCode) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        this.update(requestToken, surls, newStatusCode, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(TRequestToken requestToken, List<TSURL> surls, TStatusCode newStatusCode, String explanation) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        if (requestToken == null || surls == null || surls.isEmpty() || newStatusCode == null || explanation == null) {
            throw new IllegalArgumentException("unable to check and update the statuses, null arguments: requestToken=" + requestToken + " surls=" + surls + " newStatusCode=" + (Object)((Object)newStatusCode) + " explanation=" + explanation);
        }
        log.debug("Updating token " + requestToken + " for surls " + surls + " with status " + (Object)((Object)newStatusCode) + " " + explanation);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.verifyAndReadLock(requestToken);
            this.checkToken(requestToken);
            Map<TSURL, ModifiableReturnStatus> surlStatusMap = this.tokenSurlStatusStore.get(requestToken);
            for (TSURL surl : surls) {
                if (surl == null) {
                    log.warn("Unexpected null element in input surls list : " + surls);
                    throw new IllegalArgumentException("Received invalid null surl in surls list!");
                }
                ModifiableReturnStatus status = surlStatusMap.get(surl);
                if (status == null) {
                    log.warn("Surl '" + surl + "' is not associated to token '" + requestToken + "'");
                    throw new UnknownSurlException("Surl " + surl + " is not associated to " + requestToken);
                }
                status.setStatusCode(newStatusCode);
                status.setExplanation(explanation);
            }
        }
        finally {
            if (readLock != null) {
                this.unlockToken(readLock);
            }
        }
    }

    public void checkAndUpdate(TRequestToken requestToken, TSURL surl, TStatusCode expectedStatusCode, TStatusCode newStatusCode) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        this.checkAndUpdate(requestToken, surl, expectedStatusCode, newStatusCode, "");
    }

    public void checkAndUpdate(TRequestToken requestToken, TSURL surl, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        if (surl == null) {
            throw new IllegalArgumentException("unable to update the statuse, null arguments: surl=" + surl);
        }
        ArrayList<TSURL> surlList = new ArrayList<TSURL>(1);
        surlList.add(surl);
        this.checkAndUpdate(requestToken, surlList, expectedStatusCode, newStatusCode, explanation);
    }

    public void update(TSURL surl, TStatusCode statusCode, String explanation) throws UnknownSurlException {
        if (surl == null) {
            throw new IllegalArgumentException("unable to update the status, null arguments: surl=" + surl);
        }
        ArrayList<TSURL> surlList = new ArrayList<TSURL>(1);
        surlList.add(surl);
        this.update(surlList, statusCode, explanation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(ArrayList<TSURL> surls, TStatusCode statusCode, String explanation) throws UnknownSurlException {
        if (surls == null || surls.isEmpty() || statusCode == null || explanation == null) {
            throw new IllegalArgumentException("unable to update the statuses, null arguments: surls=" + surls + " statusCode=" + (Object)((Object)statusCode) + " explanation=" + explanation);
        }
        log.debug("Updating surls " + surls + " with status " + (Object)((Object)statusCode) + " " + explanation);
        for (TSURL surl : surls) {
            if (surl == null) {
                log.warn("Unexpected null element in input surls list : " + surls);
                throw new IllegalArgumentException("Received invalid null surl in surls list!");
            }
            ReentrantReadWriteLock.ReadLock readLock = null;
            try {
                readLock = this.readLock(surl);
                Map<TRequestToken, ModifiableReturnStatus> tokenStatusMap = this.surlTokenStatusStore.get(surl);
                if (tokenStatusMap == null) {
                    throw new UnknownSurlException("Surl " + surl + " is not stored");
                }
                for (ModifiableReturnStatus status : tokenStatusMap.values()) {
                    status.setStatusCode(statusCode);
                    status.setExplanation(explanation);
                }
            }
            finally {
                this.unlockSurl(readLock);
            }
        }
    }

    public void checkAndUpdate(TSURL surl, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) throws IllegalArgumentException, UnknownSurlException {
        if (surl == null) {
            throw new IllegalArgumentException("unable to update the status, null arguments: surl=" + surl);
        }
        ArrayList<TSURL> surlList = new ArrayList<TSURL>(1);
        surlList.add(surl);
        this.checkAndUpdate(surlList, expectedStatusCode, newStatusCode, explanation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndUpdate(ArrayList<TSURL> surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) throws UnknownSurlException {
        if (surls == null || surls.isEmpty() || expectedStatusCode == null || newStatusCode == null || explanation == null) {
            throw new IllegalArgumentException("unable to check and update the statuses, null arguments: surls=" + surls + " expectedStatusCode=" + (Object)((Object)expectedStatusCode) + " newStatusCode=" + (Object)((Object)newStatusCode) + " explanation=" + explanation);
        }
        log.debug("Checking and updating surls " + surls + " where status is " + (Object)((Object)expectedStatusCode) + " with status " + (Object)((Object)newStatusCode) + " " + explanation);
        for (TSURL surl : surls) {
            if (surl == null) {
                log.warn("Unexpected null element in input surls list : " + surls);
                throw new IllegalArgumentException("Received invalid null surl in surls list!");
            }
            ReentrantReadWriteLock.ReadLock readLock = null;
            try {
                readLock = this.readLock(surl);
                Map<TRequestToken, ModifiableReturnStatus> tokenStatusMap = this.surlTokenStatusStore.get(surl);
                if (tokenStatusMap == null) {
                    throw new UnknownSurlException("Surl " + surl + " is not stored");
                }
                for (ModifiableReturnStatus status : tokenStatusMap.values()) {
                    status.testAndSetStatusCodeExplanation(expectedStatusCode, newStatusCode, explanation);
                }
            }
            finally {
                this.unlockSurl(readLock);
            }
        }
    }

    public void checkAndUpdate(TRequestToken requestToken, List<TSURL> surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        this.checkAndUpdate(requestToken, surls, expectedStatusCode, newStatusCode, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndUpdate(TRequestToken requestToken, List<TSURL> surls, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) throws IllegalArgumentException, UnknownTokenException, ExpiredTokenException, UnknownSurlException {
        if (requestToken == null || surls == null || surls.isEmpty() || expectedStatusCode == null || newStatusCode == null || explanation == null) {
            throw new IllegalArgumentException("unable to check and update the statuses, null arguments: requestToken=" + requestToken + " surls=" + surls + " expectedStatusCode=" + (Object)((Object)expectedStatusCode) + " newStatusCode=" + (Object)((Object)newStatusCode) + " explanation=" + explanation);
        }
        log.debug("Checking and updating token " + requestToken + " for surls " + surls + " where status is " + (Object)((Object)expectedStatusCode) + " with status " + (Object)((Object)newStatusCode) + " " + explanation);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.verifyAndReadLock(requestToken);
            this.checkToken(requestToken);
            Map<TSURL, ModifiableReturnStatus> surlStatusMap = this.tokenSurlStatusStore.get(requestToken);
            for (TSURL surl : surls) {
                if (surl == null) {
                    log.warn("Unexpected null element in input surls list : " + surls);
                    throw new IllegalArgumentException("Received invalid null surl in surls list!");
                }
                ModifiableReturnStatus status = surlStatusMap.get(surl);
                if (status == null) {
                    log.warn("Surl '" + surl + "' is not associated to token '" + requestToken + "'");
                    throw new UnknownSurlException("Surl " + surl + " is not associated to requestToken " + requestToken);
                }
                if (status.testAndSetStatusCodeExplanation(expectedStatusCode, newStatusCode, explanation)) continue;
                log.debug("Surl status not updated, current status '" + (Object)((Object)status.getStatusCode()) + "' doesn't match expected status '" + (Object)((Object)expectedStatusCode) + "'");
            }
        }
        finally {
            if (readLock != null) {
                this.unlockToken(readLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndUpdate(TRequestToken requestToken, TStatusCode expectedStatusCode, TStatusCode newStatusCode, String explanation) throws UnknownTokenException, ExpiredTokenException {
        if (requestToken == null || expectedStatusCode == null || newStatusCode == null || explanation == null) {
            throw new IllegalArgumentException("unable to check and update the statuses, null arguments: requestToken=" + requestToken + " expectedStatusCode=" + (Object)((Object)expectedStatusCode) + " newStatusCode=" + (Object)((Object)newStatusCode) + " explanation=" + explanation);
        }
        log.debug("Checking and updating token " + requestToken + " for surls where status is " + (Object)((Object)expectedStatusCode) + " with status " + (Object)((Object)newStatusCode) + " " + explanation);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.verifyAndReadLock(requestToken);
            this.checkToken(requestToken);
            Map<TSURL, ModifiableReturnStatus> surlStatusMap = this.tokenSurlStatusStore.get(requestToken);
            for (Map.Entry<TSURL, ModifiableReturnStatus> surlStatus : surlStatusMap.entrySet()) {
                if (surlStatus == null) {
                    log.warn("Unexpected null element surlStatus for token : " + requestToken);
                    continue;
                }
                if (surlStatus.getValue().testAndSetStatusCodeExplanation(expectedStatusCode, newStatusCode, explanation)) continue;
                log.debug("Surl status not updated, current status '" + (Object)((Object)surlStatus.getValue().getStatusCode()) + "' doesn't match expected status '" + (Object)((Object)expectedStatusCode) + "'");
            }
        }
        finally {
            if (readLock != null) {
                this.unlockToken(readLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TSURL, TReturnStatus> getSurlsStatus(TRequestToken requestToken) throws UnknownTokenException, IllegalArgumentException, ExpiredTokenException {
        if (requestToken == null) {
            throw new IllegalArgumentException("unable to get the statuses, null arguments: requestToken=" + requestToken);
        }
        log.debug("Retrieving statuses of surls for token " + requestToken);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.verifyAndReadLock(requestToken);
            this.checkToken(requestToken);
            Map map = (Map)((HashMap)this.tokenSurlStatusStore.get(requestToken)).clone();
            return map;
        }
        finally {
            if (readLock != null) {
                this.unlockToken(readLock);
            }
        }
    }

    public Map<TSURL, TReturnStatus> getSurlsStatus(TRequestToken requestToken, TSURL surl) throws UnknownTokenException, IllegalArgumentException, ExpiredTokenException {
        if (surl == null || surl.isEmpty()) {
            throw new IllegalArgumentException("unable to get the statuses, null arguments: surl=" + surl);
        }
        return this.getSurlsStatus(requestToken, Arrays.asList(surl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TSURL, TReturnStatus> getSurlsStatus(TRequestToken requestToken, Collection<TSURL> surls) throws UnknownTokenException, IllegalArgumentException, ExpiredTokenException {
        if (requestToken == null || surls == null || surls.isEmpty()) {
            throw new IllegalArgumentException("unable to get the statuses, null arguments: requestToken=" + requestToken + " surls=" + surls);
        }
        log.debug("Retrieving statuses of surls " + surls + " for token " + requestToken);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.verifyAndReadLock(requestToken);
            this.checkToken(requestToken);
            HashMap<TSURL, TReturnStatus> builtSurlStatusMap = new HashMap<TSURL, TReturnStatus>(surls.size());
            Map<TSURL, ModifiableReturnStatus> surlStatusMap = this.tokenSurlStatusStore.get(requestToken);
            for (TSURL surl : surls) {
                if (surl == null) {
                    log.warn("Unexpected null element in input surls list");
                    continue;
                }
                TReturnStatus status = surlStatusMap.get(surl);
                if (status == null) {
                    log.warn("Surl '" + surl + "' is not associated to token '" + requestToken + "'");
                    continue;
                }
                builtSurlStatusMap.put(surl, status);
            }
            HashMap<TSURL, TReturnStatus> hashMap = builtSurlStatusMap;
            return hashMap;
        }
        finally {
            if (readLock != null) {
                this.unlockToken(readLock);
            }
        }
    }

    public Collection<TReturnStatus> getSurlStatuses(TSURL surl) throws UnknownSurlException, IllegalArgumentException {
        if (surl == null) {
            throw new IllegalArgumentException("Unable to get the statuses, null arguments: surl=" + surl);
        }
        log.debug("Retrieving statuses of surl " + surl);
        Map<TRequestToken, TReturnStatus> tokensStatusMap = this.getSurlPerTokenStatuses(surl);
        if (tokensStatusMap == null) {
            throw new UnknownSurlException("Surl " + surl + " is not stored");
        }
        return new ArrayList<TReturnStatus>(new HashSet<TReturnStatus>(tokensStatusMap.values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TRequestToken, ? extends TReturnStatus> getSurlPerTokenStatuses(TSURL surl, GridUserInterface user) throws UnknownSurlException {
        if (surl == null || user == null) {
            throw new IllegalArgumentException("Unable to get the statuses, null arguments: surl=" + surl + " user=" + user);
        }
        log.debug("Retrieving status-token for surl " + surl);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.readLock(surl);
            Map<TRequestToken, ModifiableReturnStatus> tokensStatusMap = this.surlTokenStatusStore.get(surl);
            if (tokensStatusMap == null) {
                throw new UnknownSurlException("Surl " + surl + " is not stored");
            }
            if (tokensStatusMap.isEmpty()) {
                throw new UnknownSurlException("Surl " + surl + " is not stored");
            }
            HashMap<TRequestToken, ModifiableReturnStatus> userTokensStatusMap = new HashMap<TRequestToken, ModifiableReturnStatus>();
            try {
                this.lockTokenUserStore();
                for (Map.Entry<TRequestToken, ModifiableReturnStatus> tokenStatus : tokensStatusMap.entrySet()) {
                    if (!this.tokenUserStore.containsKey(tokenStatus.getKey())) {
                        userTokensStatusMap.put(tokenStatus.getKey(), tokenStatus.getValue());
                        continue;
                    }
                    if (this.tokenUserStore.get(tokenStatus.getKey()).equals(user)) {
                        userTokensStatusMap.put(tokenStatus.getKey(), tokenStatus.getValue());
                        continue;
                    }
                    log.debug("Surl " + surl + " has not been stored with a token belonging to user " + user);
                }
                HashMap<TRequestToken, ModifiableReturnStatus> hashMap = userTokensStatusMap;
                this.unlockTokenUserStore();
                return hashMap;
            }
            catch (Throwable throwable) {
                this.unlockTokenUserStore();
                throw throwable;
            }
        }
        finally {
            this.unlockSurl(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<TRequestToken, TReturnStatus> getSurlPerTokenStatuses(TSURL surl) throws IllegalArgumentException, UnknownSurlException {
        if (surl == null) {
            throw new IllegalArgumentException("Unable to get the statuses, null arguments: surl=" + surl);
        }
        log.debug("Retrieving status-token for surl " + surl);
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.readLock(surl);
            Map<TRequestToken, ModifiableReturnStatus> tokensStatusMap = this.surlTokenStatusStore.get(surl);
            if (tokensStatusMap == null) {
                throw new UnknownSurlException("Surl " + surl + " is not stored");
            }
            if (tokensStatusMap.isEmpty()) {
                throw new UnknownSurlException("Surl " + surl + " is not stored");
            }
            Map map = (Map)((HashMap)tokensStatusMap).clone();
            return map;
        }
        finally {
            this.unlockSurl(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TRequestToken> getExpiredTokens() {
        this.lockExpirationMap();
        try {
            ArrayList<TRequestToken> arrayList = new ArrayList<TRequestToken>(this.expirationTokenRegistry.headMap((Object)Calendar.getInstance().getTimeInMillis(), true).values());
            return arrayList;
        }
        finally {
            this.unlockExpirationMap();
        }
    }

    private void checkToken(TRequestToken requestToken) throws UnknownTokenException, ExpiredTokenException {
        if (!this.tokenSurlStatusStore.containsKey(requestToken)) {
            log.warn("Token '" + requestToken + "' is not stored");
            throw new UnknownTokenException("Provided token '" + requestToken + "'is not stored");
        }
        if (requestToken.hasExpirationDate() && requestToken.isExpired()) {
            log.warn("Token '" + requestToken + "' is expired");
            throw new ExpiredTokenException("Provided token '" + requestToken + "'is expired");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanToken(TRequestToken requestToken) throws UnknownTokenException {
        this.verifyToken(requestToken);
        try {
            this.lockExpirationMap();
            this.expirationTokenRegistry.remove(this.getStoredTokenExpiration(requestToken));
        }
        finally {
            this.unlockExpirationMap();
        }
        try {
            this.lockTokenUserStore();
            this.tokenUserStore.remove(requestToken);
        }
        finally {
            this.unlockTokenUserStore();
        }
        ReentrantReadWriteLock.WriteLock writeLockToken = null;
        try {
            writeLockToken = this.verifyAndWriteLock(requestToken);
            Map<TSURL, ModifiableReturnStatus> surlStatuses = this.tokenSurlStatusStore.remove(requestToken);
            for (TSURL surl : surlStatuses.keySet()) {
                ReentrantReadWriteLock.WriteLock writeLockSurl = null;
                try {
                    writeLockSurl = this.writeLock(surl);
                    Map<TRequestToken, ModifiableReturnStatus> tokenStatuses = this.surlTokenStatusStore.get(surl);
                    if (tokenStatuses == null) {
                        throw new IllegalStateException("Inconsistent Surl Status Store. Surl uid " + surl + " not found in surlTokenStatusStore");
                    }
                    tokenStatuses.remove(requestToken);
                    if (!tokenStatuses.isEmpty()) continue;
                    this.surlTokenStatusStore.remove(surl);
                }
                finally {
                    this.unlockSurl(writeLockSurl);
                }
            }
        }
        finally {
            this.removeLock(requestToken);
            if (writeLockToken != null) {
                this.unlockToken(writeLockToken);
            }
        }
    }

    private void verifyToken(TRequestToken requestToken) throws UnknownTokenException {
        if (!this.tokenSurlStatusStore.containsKey(requestToken)) {
            log.debug("Token '" + requestToken + "' is not stored");
            throw new UnknownTokenException("Provided token '" + requestToken + "'is not stored");
        }
        if (!this.tokenLockMap.containsKey(requestToken)) {
            log.warn("Token '" + requestToken + "' is not stored in tokenLockMap");
            throw new IllegalStateException("Provided token '" + requestToken + "'is not stored in tokenLockMap");
        }
        try {
            if (!this.expirationTokenRegistry.containsKey(this.getStoredTokenExpiration(requestToken))) {
                log.warn("Token '" + requestToken + "' is not stored in expirationTokenRegistry");
                throw new IllegalStateException("Provided token '" + requestToken + "'is not stored in expirationTokenRegistry");
            }
        }
        catch (UnknownTokenException e) {
            log.warn("Token '" + requestToken + "' is not retrieved from getStoredTokenExpiration");
            throw new IllegalStateException("Provided token '" + requestToken + "'is not retrieved from getStoredTokenExpiration");
        }
    }

    private boolean verifyMissingToken(TRequestToken requestToken) throws IllegalArgumentException {
        if (requestToken == null) {
            throw new IllegalArgumentException("Unable to verify the token, null arguments: requestToken=" + requestToken);
        }
        return !this.tokenSurlStatusStore.containsKey(requestToken) && !this.tokenLockMap.containsKey(requestToken) && (!requestToken.hasExpirationDate() || !requestToken.equals(this.expirationTokenRegistry.get(requestToken.getExpiration()))) && !this.tokenUserStore.containsKey(requestToken);
    }

    private long getStoredTokenExpiration(TRequestToken requestToken) throws UnknownTokenException {
        ReentrantReadWriteLock.ReadLock readLock = null;
        try {
            readLock = this.verifyAndReadLock(requestToken);
            ArrayList<TRequestToken> tokenList = new ArrayList<TRequestToken>(this.tokenSurlStatusStore.keySet());
            int index = tokenList.indexOf(requestToken);
            if (index >= 0) {
                TRequestToken storedToken = tokenList.get(index);
                if (!storedToken.hasExpirationDate()) {
                    throw new IllegalStateException("Unexpected stored token with no expiration date");
                }
                long l = storedToken.getExpiration().getTimeInMillis();
                return l;
            }
            throw new UnknownTokenException("Token " + requestToken + " not stored in tokenSurlStatusStore");
        }
        finally {
            if (readLock != null) {
                this.unlockToken(readLock);
            }
        }
    }

    public void checkIntegrity() throws Exception {
        for (Map.Entry<TSURL, Map<TRequestToken, ModifiableReturnStatus>> entry : this.surlTokenStatusStore.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                throw new Exception("Integrity violation: empty tokenStatusMap in surlTokenStatusStore for surl " + entry.getKey());
            }
            for (Map.Entry<TRequestToken, ModifiableReturnStatus> tokenSurlStatus : entry.getValue().entrySet()) {
                if (tokenSurlStatus.getValue() == null) {
                    throw new Exception("Integrity violation: Null status in surlTokenStatusStore for surl " + entry.getKey() + " token " + tokenSurlStatus.getKey());
                }
                Map<TSURL, ModifiableReturnStatus> surlStatus = this.tokenSurlStatusStore.get(tokenSurlStatus.getKey());
                if (surlStatus == null) {
                    throw new Exception("Integrity violation: Null surlStatus map in tokenSurlStatusStore for token " + tokenSurlStatus.getKey() + " surl " + entry.getValue());
                }
                if (surlStatus.get(entry.getKey()) == null) {
                    throw new Exception("Integrity violation: Null Status in tokenSurlStatusStore for token " + tokenSurlStatus.getKey() + " surl " + entry.getValue());
                }
                if (!tokenSurlStatus.getValue().equals(surlStatus.get(entry.getKey()))) {
                    throw new Exception("Integrity violation: value mismatch for status in tokenSurlStatusStore " + tokenSurlStatus.getValue() + " and surlTokenStatusStore " + surlStatus.get(entry.getKey()));
                }
                if (tokenSurlStatus.getValue() == surlStatus.get(entry.getKey())) continue;
                throw new Exception("Integrity violation: object mismatch for status in tokenSurlStatusStore " + tokenSurlStatus.getValue() + " and surlTokenStatusStore " + surlStatus.get(entry.getKey()));
            }
            if (this.surlLockMap.containsKey(entry.getKey())) continue;
            throw new Exception("Integrity violation: No lock stored for surl " + entry.getKey());
        }
        for (Map.Entry<Object, Map<Object, ModifiableReturnStatus>> entry : this.tokenSurlStatusStore.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                throw new Exception("Integrity violation: empty surlStatus map in tokenSurlStatusStore for token " + entry.getKey());
            }
            if (((TRequestToken)entry.getKey()).hasExpirationDate()) {
                TRequestToken expirationToken = this.expirationTokenRegistry.get(((TRequestToken)entry.getKey()).getExpiration().getTimeInMillis());
                if (expirationToken == null) {
                    throw new Exception("Integrity violation: empty expirationToken for token " + entry.getKey());
                }
                if (!expirationToken.equals(entry.getKey())) {
                    throw new Exception("Integrity violation: value mismatch for expirationToken " + expirationToken + " and token " + entry.getKey());
                }
            }
            for (Map.Entry<Object, ModifiableReturnStatus> surlTokenStatus : entry.getValue().entrySet()) {
                if (surlTokenStatus.getValue() == null) {
                    throw new Exception("Integrity violation: Null status in tokenSurlStatusStore for token " + entry.getKey() + " surl " + surlTokenStatus.getKey());
                }
                Map<TRequestToken, ModifiableReturnStatus> tokenStatus = this.surlTokenStatusStore.get(surlTokenStatus.getKey());
                if (tokenStatus == null) {
                    throw new Exception("Integrity violation: Null tokenStatus map in surlTokenStatusStore for surl " + surlTokenStatus.getKey() + " token " + entry.getValue());
                }
                if (tokenStatus.get(entry.getKey()) == null) {
                    throw new Exception("Integrity violation: Null Status in surlTokenStatusStore for surl " + surlTokenStatus.getKey() + " surl " + entry.getValue());
                }
                if (!surlTokenStatus.getValue().equals(tokenStatus.get(entry.getKey()))) {
                    throw new Exception("Integrity violation: value mismatch for status in surlTokenStatusStore " + surlTokenStatus.getValue() + " and surlTokenStatusStore " + tokenStatus.get(entry.getKey()));
                }
                if (surlTokenStatus.getValue() == tokenStatus.get(entry.getKey())) continue;
                throw new Exception("Integrity violation: object mismatch for status in surlTokenStatusStore " + surlTokenStatus.getValue() + " and surlTokenStatusStore " + tokenStatus.get(entry.getKey()));
            }
            if (this.tokenLockMap.containsKey(entry.getKey())) continue;
            throw new Exception("Integrity violation: No lock stored for token " + entry.getKey());
        }
        for (Map.Entry<Object, Object> entry : this.expirationTokenRegistry.entrySet()) {
            if (!((TRequestToken)entry.getValue()).hasExpirationDate()) {
                throw new Exception("Integrity violation: stored token " + entry.getValue() + " in expirationTokenRegistry has no expiration ");
            }
            if (((Long)entry.getKey()).longValue() != ((TRequestToken)entry.getValue()).getExpiration().getTimeInMillis()) {
                throw new Exception("Integrity violation: value mismatch between expiration " + entry.getKey() + " and token expiration " + ((TRequestToken)entry.getValue()).getExpiration().getTimeInMillis());
            }
            if (this.tokenSurlStatusStore.get(entry.getValue()) != null) continue;
            throw new Exception("Integrity violation: Null tokenSurlStatus map for expirationToken " + entry.getValue());
        }
        for (TRequestToken tRequestToken : this.tokenUserStore.keySet()) {
            if (this.tokenSurlStatusStore.get(tRequestToken) != null) continue;
            throw new Exception("Integrity violation: Null tokenSurlStatus map for tokenUserStore " + tRequestToken.getValue());
        }
        for (Map.Entry entry : this.tokenLockMap.entrySet()) {
            if (this.tokenSurlStatusStore.get(entry.getKey()) != null) continue;
            throw new Exception("Integrity violation: Null tokenSurlStatus map for tokenLock " + entry.getKey());
        }
        for (Map.Entry entry : this.surlLockMap.entrySet()) {
            if (this.surlTokenStatusStore.get(entry.getKey()) != null) continue;
            log.debug("Lock for Surl " + entry.getKey() + " has to be cleaned");
        }
    }

    private ReentrantReadWriteLock.WriteLock writeLockIfNew(TRequestToken requestToken) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        ReentrantReadWriteLock storedLock = this.tokenLockMap.putIfAbsent(requestToken, lock);
        if (storedLock != null) {
            return null;
        }
        log.trace("SurlStatusStore.writeLockIfNew(TOKEN) locking " + requestToken);
        lock.writeLock().lock();
        log.trace("SurlStatusStore.writeLockIfNew(TOKEN) locked " + requestToken);
        return lock.writeLock();
    }

    private ReentrantReadWriteLock.WriteLock verifyAndWriteLock(TRequestToken requestToken) throws UnknownTokenException {
        ReentrantReadWriteLock lock = this.tokenLockMap.get(requestToken);
        if (lock == null) {
            log.debug("Token '" + requestToken + "' is not stored in tokenLockMap");
            throw new UnknownTokenException("Provided token '" + requestToken + "' has not a lock");
        }
        log.trace("SurlStatusStore.writeLock(TOKEN) locking " + requestToken);
        lock.writeLock().lock();
        log.trace("SurlStatusStore.writeLock(TOKEN) locked " + requestToken);
        return lock.writeLock();
    }

    private void unlockToken(ReentrantReadWriteLock.WriteLock writeLock) throws IllegalArgumentException {
        if (writeLock == null) {
            throw new IllegalArgumentException("The provided argument is null: writeLock=" + writeLock);
        }
        writeLock.unlock();
        log.trace("SurlStatusStore.writeUnlock(TOKEN)");
    }

    private ReentrantReadWriteLock.ReadLock verifyAndReadLock(TRequestToken requestToken) throws UnknownTokenException {
        ReentrantReadWriteLock lock = this.tokenLockMap.get(requestToken);
        if (lock == null) {
            log.debug("Token '" + requestToken + "' is not stored in tokenLockMap");
            throw new UnknownTokenException("Provided token '" + requestToken + "' has not a lock");
        }
        log.trace("SurlStatusStore.readLock(TOKEN) locking " + requestToken);
        lock.readLock().lock();
        log.trace("SurlStatusStore.readLock(TOKEN) locked " + requestToken);
        return lock.readLock();
    }

    private void unlockToken(ReentrantReadWriteLock.ReadLock readLock) throws IllegalArgumentException {
        if (readLock == null) {
            throw new IllegalArgumentException("The provided argument is null: readLock=" + readLock);
        }
        readLock.unlock();
        log.trace("SurlStatusStore.readUnlock(TOKEN)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.WriteLock writeLock(TSURL surl) {
        ReentrantReadWriteLock storedLock;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        ConcurrentHashMap<TSURL, ReentrantReadWriteLock> concurrentHashMap = this.surlLockMap;
        synchronized (concurrentHashMap) {
            storedLock = this.surlLockMap.putIfAbsent(surl, lock);
        }
        if (storedLock != null) {
            lock = storedLock;
        }
        log.trace("SurlStatusStore.writeLock(SURL) locking " + surl);
        lock.writeLock().lock();
        log.trace("SurlStatusStore.writeLock(SURL) locked " + surl);
        return lock.writeLock();
    }

    private void unlockSurl(ReentrantReadWriteLock.WriteLock writeLock) throws IllegalArgumentException {
        if (writeLock == null) {
            throw new IllegalArgumentException("The provided argument is null: writeLock=" + writeLock);
        }
        writeLock.unlock();
        log.trace("SurlStatusStore.writeUnlock(SURL)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReentrantReadWriteLock.ReadLock readLock(TSURL surl) {
        ReentrantReadWriteLock storedLock;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
        ConcurrentHashMap<TSURL, ReentrantReadWriteLock> concurrentHashMap = this.surlLockMap;
        synchronized (concurrentHashMap) {
            storedLock = this.surlLockMap.putIfAbsent(surl, lock);
        }
        if (storedLock != null) {
            lock = storedLock;
        }
        log.trace("SurlStatusStore.readLock(SURL) locking " + surl);
        lock.readLock().lock();
        log.trace("SurlStatusStore.readLock(SURL) locked " + surl);
        return lock.readLock();
    }

    private void unlockSurl(ReentrantReadWriteLock.ReadLock readLock) throws IllegalArgumentException {
        if (readLock == null) {
            throw new IllegalArgumentException("The provided argument is null: readLock=" + readLock);
        }
        readLock.unlock();
        log.trace("SurlStatusStore.unlockUnlock(SURL)");
    }

    private void removeLock(TRequestToken requestToken) throws IllegalArgumentException {
        if (this.tokenLockMap.remove(requestToken) == null) {
            throw new IllegalArgumentException("Unable to remove the provided token lock, it doesn't exists");
        }
    }

    private void unlockTokenUserStore() {
        this.tokenUserStoreLock.unlock();
        log.trace("SurlStatusStore.unlockTokenUserStore()");
    }

    private void lockTokenUserStore() {
        this.tokenUserStoreLock.lock();
        log.trace("SurlStatusStore.lockTokenUserStore()");
    }

    private void unlockExpirationMap() {
        this.expirationTokenRegistryLock.unlock();
        log.trace("SurlStatusStore.unlockExpirationMap()");
    }

    private void lockExpirationMap() {
        this.expirationTokenRegistryLock.lock();
        log.trace("SurlStatusStore.lockExpirationMap()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSurlLocks() {
        ConcurrentHashMap<TSURL, ReentrantReadWriteLock> concurrentHashMap = this.surlLockMap;
        synchronized (concurrentHashMap) {
            Iterator iterator = this.surlLockMap.keySet().iterator();
            while (iterator.hasNext()) {
                TSURL surl = (TSURL)iterator.next();
                if (this.surlTokenStatusStore.get(surl) != null) continue;
                iterator.remove();
            }
        }
    }

    static /* synthetic */ void access$000(SurlStatusStore x0) {
        x0.lockExpirationMap();
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ void access$200(SurlStatusStore x0, TRequestToken x1) throws UnknownTokenException {
        x0.cleanToken(x1);
    }

    static /* synthetic */ void access$300(SurlStatusStore x0) {
        x0.unlockExpirationMap();
    }

    static /* synthetic */ void access$400(SurlStatusStore x0) {
        x0.expireSurlLocks();
    }
}

