/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.data.space;

import it.grid.storm.srm.types.ArrayOfTExtraInfo;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TRetentionPolicyInfo;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.synchcall.data.AbstractInputData;
import it.grid.storm.synchcall.data.space.ReserveSpaceInputData;

public class AnonymousReserveSpaceInputData
extends AbstractInputData
implements ReserveSpaceInputData {
    private final String spaceTokenAlias;
    private final TRetentionPolicyInfo retentionPolicyInfo;
    private final TSizeInBytes desiredSize;
    private final TSizeInBytes guaranteedSize;
    private TLifeTimeInSeconds spaceLifetime;
    private final ArrayOfTExtraInfo storageSystemInfo;

    public AnonymousReserveSpaceInputData(String spaceTokenAlias, TRetentionPolicyInfo retentionPolicyInfo, TSizeInBytes spaceDesired, TSizeInBytes spaceGuaranteed, ArrayOfTExtraInfo storageSystemInfo) throws IllegalArgumentException {
        if (spaceTokenAlias == null) {
            throw new IllegalArgumentException("Unable to create the object, invalid arguments: spaceTokenAlias=" + spaceTokenAlias);
        }
        this.spaceTokenAlias = spaceTokenAlias;
        this.desiredSize = spaceDesired == null ? TSizeInBytes.makeEmpty() : spaceDesired;
        this.guaranteedSize = spaceGuaranteed == null ? TSizeInBytes.makeEmpty() : spaceGuaranteed;
        this.spaceLifetime = TLifeTimeInSeconds.makeEmpty();
        this.storageSystemInfo = storageSystemInfo;
        this.retentionPolicyInfo = retentionPolicyInfo;
    }

    @Override
    public String getSpaceTokenAlias() {
        return this.spaceTokenAlias;
    }

    @Override
    public TRetentionPolicyInfo getRetentionPolicyInfo() {
        return this.retentionPolicyInfo;
    }

    @Override
    public TSizeInBytes getDesiredSize() {
        return this.desiredSize;
    }

    @Override
    public TSizeInBytes getGuaranteedSize() {
        return this.guaranteedSize;
    }

    @Override
    public TLifeTimeInSeconds getSpaceLifetime() {
        return this.spaceLifetime;
    }

    @Override
    public void setSpaceLifetime(TLifeTimeInSeconds spaceLifetime) {
        this.spaceLifetime = spaceLifetime;
    }

    @Override
    public ArrayOfTExtraInfo getStorageSystemInfo() {
        return this.storageSystemInfo;
    }
}

