/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.data.datatransfer;

import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.synchcall.data.OutputData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageFileTransferOutputData
implements OutputData {
    private static final Logger log = LoggerFactory.getLogger(ManageFileTransferOutputData.class);
    private final TReturnStatus returnStatus;
    private final ArrayOfTSURLReturnStatus arrayOfFileStatus;

    public ManageFileTransferOutputData(TReturnStatus retStatus) throws IllegalArgumentException {
        if (retStatus == null) {
            log.error("Unable to create the object, invalid arguments: retStatus=" + retStatus);
            throw new IllegalArgumentException("Unable to create the object, invalid arguments");
        }
        this.returnStatus = retStatus;
        this.arrayOfFileStatus = new ArrayOfTSURLReturnStatus();
    }

    public ManageFileTransferOutputData(TReturnStatus retStatus, ArrayOfTSURLReturnStatus arrayOfFileStatus) throws IllegalArgumentException {
        if (retStatus == null || arrayOfFileStatus == null || arrayOfFileStatus.getArray().isEmpty()) {
            log.error("Unable to create the object, invalid arguments: retStatus=" + retStatus + " arrayOfFileStatus=" + arrayOfFileStatus);
            throw new IllegalArgumentException("Unable to create the object, invalid arguments");
        }
        this.returnStatus = retStatus;
        this.arrayOfFileStatus = arrayOfFileStatus;
    }

    public TReturnStatus getReturnStatus() {
        return this.returnStatus;
    }

    public ArrayOfTSURLReturnStatus getArrayOfFileStatuses() {
        return this.arrayOfFileStatus;
    }

    public void addFileStatus(TSURLReturnStatus surlStatus) {
        this.arrayOfFileStatus.addTSurlReturnStatus(surlStatus);
    }

    @Override
    public boolean isSuccess() {
        return this.returnStatus.isSRM_SUCCESS();
    }
}

