/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.data.datatransfer;

import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TTURL;
import it.grid.storm.synchcall.data.OutputData;

public class FileTransferOutputData
implements OutputData {
    private final TSURL surl;
    private final TTURL turl;
    private final TReturnStatus status;
    private final TRequestToken requestToken;

    public FileTransferOutputData(TSURL surl, TTURL turl, TReturnStatus status, TRequestToken requestToken) throws IllegalArgumentException {
        if (surl == null || turl == null || status == null || requestToken == null) {
            throw new IllegalArgumentException("Unable to create FileTransferOutputData. Received null arguments: surl = " + surl + " , turl = " + turl + " , status = " + status);
        }
        this.surl = surl;
        this.turl = turl;
        this.status = status;
        this.requestToken = requestToken;
    }

    @Override
    public boolean isSuccess() {
        return this.status.isSRM_SUCCESS();
    }

    public TSURL getSurl() {
        return this.surl;
    }

    public TTURL getTurl() {
        return this.turl;
    }

    public TReturnStatus getStatus() {
        return this.status;
    }

    public TRequestToken getRequestToken() {
        return this.requestToken;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FileTransferOutputData [surl=");
        builder.append(this.surl);
        builder.append(", turl=");
        builder.append(this.turl);
        builder.append(", status=");
        builder.append(this.status);
        builder.append(", requestToken=");
        builder.append(this.requestToken);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.requestToken == null ? 0 : this.requestToken.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.surl == null ? 0 : this.surl.hashCode());
        result = 31 * result + (this.turl == null ? 0 : this.turl.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileTransferOutputData other = (FileTransferOutputData)obj;
        if (this.requestToken == null ? other.requestToken != null : !this.requestToken.equals(other.requestToken)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals(other.status)) {
            return false;
        }
        if (this.surl == null ? other.surl != null : !this.surl.equals(other.surl)) {
            return false;
        }
        return !(this.turl == null ? other.turl != null : !this.turl.equals(other.turl));
    }
}

