/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.data.datatransfer;

import it.grid.storm.catalogs.OverwriteModeConverter;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TOverwriteMode;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.synchcall.data.datatransfer.AnonymousFileTransferInputData;
import it.grid.storm.synchcall.data.datatransfer.PrepareToPutInputData;

public class AnonymousPrepareToPutInputData
extends AnonymousFileTransferInputData
implements PrepareToPutInputData {
    private TOverwriteMode overwriteMode = OverwriteModeConverter.getInstance().toSTORM(Configuration.getInstance().getDefaultOverwriteMode());
    private TSizeInBytes fileSize = TSizeInBytes.makeEmpty();
    private TLifeTimeInSeconds desiredFileLifetime = TLifeTimeInSeconds.make(Configuration.getInstance().getFileLifetimeDefault(), TimeUnit.SECONDS);

    public AnonymousPrepareToPutInputData(TSURL surl, TURLPrefix transferProtocols) throws IllegalArgumentException, IllegalStateException {
        super(surl, transferProtocols);
    }

    public AnonymousPrepareToPutInputData(TSURL surl, TURLPrefix transferProtocols, TLifeTimeInSeconds desiredFileLifetime) throws IllegalArgumentException, IllegalStateException {
        this(surl, transferProtocols);
        this.desiredFileLifetime = desiredFileLifetime;
    }

    @Override
    public TOverwriteMode getOverwriteMode() {
        return this.overwriteMode;
    }

    @Override
    public void setOverwriteMode(TOverwriteMode overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    @Override
    public TSizeInBytes getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(TSizeInBytes fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public TLifeTimeInSeconds getDesiredFileLifetime() {
        return this.desiredFileLifetime;
    }

    @Override
    public void setDesiredFileLifetime(TLifeTimeInSeconds desiredFileLifetime) {
        this.desiredFileLifetime = desiredFileLifetime;
    }
}

