/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.directory;

import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DirectoryCommand;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.RmdirInputData;
import it.grid.storm.synchcall.data.directory.RmdirOutputData;
import java.util.Arrays;

public class RmdirCommand
extends DirectoryCommand
implements Command {
    private static final String SRM_COMMAND = "srmRmdir";
    private final NamespaceInterface namespace = NamespaceDirector.getNamespace();

    @Override
    public OutputData execute(InputData data) {
        this.log.debug("srmRmdir: Start execution.");
        TReturnStatus returnStatus = null;
        RmdirInputData inputData = (RmdirInputData)data;
        RmdirOutputData outData = null;
        if (inputData == null || inputData != null && inputData.getSurl() == null) {
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Invalid parameter specified.");
            this.printRequestOutcome(returnStatus, inputData);
            outData = new RmdirOutputData(returnStatus);
            return outData;
        }
        TSURL surl = inputData.getSurl();
        StoRI stori = null;
        if (!surl.isEmpty()) {
            try {
                if (inputData instanceof IdentityInputData) {
                    try {
                        stori = this.namespace.resolveStoRIbySURL(surl, ((IdentityInputData)((Object)inputData)).getUser());
                    }
                    catch (UnapprochableSurlException e) {
                        this.log.info("Unable to build a stori for surl " + surl + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                        returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                        this.printRequestOutcome(returnStatus, inputData);
                        return new RmdirOutputData(returnStatus);
                    }
                }
                try {
                    stori = this.namespace.resolveStoRIbySURL(surl);
                }
                catch (UnapprochableSurlException e) {
                    this.log.info("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                    returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified");
                    this.printRequestOutcome(returnStatus, inputData);
                    return new RmdirOutputData(returnStatus);
                }
            }
            catch (IllegalArgumentException e) {
                this.log.error("srmRmdir: Unable to build StoRI by surl and user. IllegalArgumentException: " + e.getMessage());
                returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Unable to get StoRI for surl");
                this.printRequestOutcome(returnStatus, inputData);
                outData = new RmdirOutputData(returnStatus);
                return outData;
            }
        } else {
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL specified");
            this.printRequestOutcome(returnStatus, inputData);
            outData = new RmdirOutputData(returnStatus);
            return outData;
        }
        Boolean recursive = inputData.getRecursive();
        if (recursive == null) {
            recursive = new Boolean(false);
        }
        TSpaceToken token = new SpaceHelper().getTokenFromStoRI(this.log, stori);
        SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
        boolean isSpaceAuthorized = inputData instanceof IdentityInputData ? spaceAuth.authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMSpaceRequest.RMD) : spaceAuth.authorizeAnonymous(SRMSpaceRequest.RMD);
        if (!isSpaceAuthorized) {
            this.log.debug("srmRmdir: User not authorized to perform srmRmdir request on the storage area: " + token);
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User not authorized to perform srmRmdir request on the storage area");
            this.printRequestOutcome(returnStatus, inputData);
            outData = new RmdirOutputData(returnStatus);
            return outData;
        }
        AuthzDecision decision = inputData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMFileRequest.RMD, stori) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.RMD, stori.getStFN());
        if (decision.equals((Object)AuthzDecision.PERMIT)) {
            this.log.debug("RMDIR is authorized for " + DataHelper.getRequestor(inputData) + " and the directory = " + stori.getPFN() + " with recursove opt = " + recursive);
            returnStatus = this.manageAuthorizedRMDIR(stori.getLocalFile(), recursive);
        } else {
            returnStatus = CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User is not authorized to delete the directory");
        }
        this.printRequestOutcome(returnStatus, inputData);
        outData = new RmdirOutputData(returnStatus);
        return outData;
    }

    private TReturnStatus manageAuthorizedRMDIR(LocalFile directory, boolean recursive) {
        TReturnStatus returnStatus;
        if (directory.exists() && directory.isDirectory()) {
            if (recursive) {
                this.log.debug("srmRmdir: Recursive deletion. Removing dir with all files included! ");
                if (!this.deleteDirectoryContent(directory)) {
                    return CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Unable to delete some files within directory.");
                }
            }
            returnStatus = !this.removeFile(directory) ? CommandHelper.buildStatus(TStatusCode.SRM_NON_EMPTY_DIRECTORY, "Directory is not empty") : CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "Directory removed with success!");
        } else {
            this.log.debug("RMDIR : request with invalid directory specified!");
            returnStatus = !directory.exists() ? CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Directory does not exists") : CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Not a directory");
        }
        return returnStatus;
    }

    private boolean deleteDirectoryContent(LocalFile directory) {
        boolean result = true;
        if (directory.exists()) {
            if (directory.isDirectory()) {
                LocalFile[] list = directory.listFiles();
                if (list.length > 0) {
                    for (LocalFile element : list) {
                        boolean bl = result = result && this.deleteDirectoryContent(element);
                        if (!element.exists()) continue;
                        result = result && this.removeFile(element);
                    }
                }
            } else {
                result = this.removeFile(directory);
            }
        }
        return result;
    }

    private boolean removeFile(LocalFile file) {
        boolean result = false;
        if (file.exists()) {
            if (file.isDirectory()) {
                LocalFile[] list = file.listFiles();
                if (list.length > 0) {
                    result = false;
                    this.log.info("srmRmdir: Unable to delete the target file '" + file + "' . It is a not-empty directory.");
                } else {
                    result = file.delete();
                }
            } else {
                result = file.delete();
            }
        } else {
            result = false;
            this.log.debug("RMDIR : the target file '" + file + "' does not exists! ");
        }
        return result;
    }

    private void printRequestOutcome(TReturnStatus status, RmdirInputData inputData) {
        if (inputData != null) {
            if (inputData.getSurl() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, (InputData)inputData, Arrays.asList(inputData.getSurl().toString()));
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }
}

