/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.directory;

import it.grid.storm.acl.AclManagerFSAndHTTPS;
import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.SpaceAuthzInterface;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.authz.sa.model.SRMSpaceRequest;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.LocalUser;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DirectoryCommand;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.MvInputData;
import it.grid.storm.synchcall.data.directory.MvOutputData;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import java.util.Arrays;

public class MvCommand
extends DirectoryCommand
implements Command {
    private static final String SRM_COMMAND = "SrmMv";
    private final NamespaceInterface namespace = NamespaceDirector.getNamespace();

    @Override
    public OutputData execute(InputData data) {
        TReturnStatus returnStatus;
        StoRI toStori;
        StoRI fromStori;
        this.log.debug("srmMv: Start execution.");
        MvOutputData outputData = new MvOutputData();
        MvInputData inputData = (MvInputData)data;
        if (inputData == null || inputData.getFromSURL() == null || inputData.getToSURL() == null) {
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Invalid parameter specified."));
            this.log.warn("srmMv: Request failed with [status: " + outputData.getStatus() + "]");
            return outputData;
        }
        TSURL fromSURL = inputData.getFromSURL();
        if (!fromSURL.isEmpty()) {
            try {
                if (inputData instanceof IdentityInputData) {
                    try {
                        fromStori = this.namespace.resolveStoRIbySURL(fromSURL, ((IdentityInputData)((Object)inputData)).getUser());
                    }
                    catch (UnapprochableSurlException e) {
                        this.log.info("srmMv: Unable to build a stori for surl " + fromSURL + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                        outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                        this.printRequestOutcome(outputData.getStatus(), inputData);
                        return outputData;
                    }
                }
                try {
                    fromStori = this.namespace.resolveStoRIbySURL(fromSURL);
                }
                catch (UnapprochableSurlException e) {
                    this.log.info("srmMv: Unable to build a stori for surl " + fromSURL + " UnapprochableSurlException: " + e.getMessage());
                    outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                    this.printRequestOutcome(outputData.getStatus(), inputData);
                    return outputData;
                }
            }
            catch (IllegalArgumentException e) {
                this.log.warn("srmMv: Unable to build StoRI by SURL:[" + fromSURL + "]. IllegalArgumentException: " + e.getMessage());
                outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Unable to build StoRI by SURL"));
                this.printRequestOutcome(outputData.getStatus(), inputData);
                return outputData;
            }
        } else {
            this.log.warn("srmMv: unable to perform the operation, empty fromSurl");
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid fromSURL specified!"));
            this.printRequestOutcome(outputData.getStatus(), inputData);
            return outputData;
        }
        TSURL toSURL = inputData.getToSURL();
        if (!toSURL.isEmpty()) {
            try {
                if (inputData instanceof IdentityInputData) {
                    try {
                        toStori = this.namespace.resolveStoRIbySURL(toSURL, ((IdentityInputData)((Object)inputData)).getUser());
                    }
                    catch (UnapprochableSurlException e) {
                        this.log.info("srmMv: Unable to build a stori for surl " + toSURL + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                        outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                        this.printRequestOutcome(outputData.getStatus(), inputData);
                        return outputData;
                    }
                }
                try {
                    toStori = this.namespace.resolveStoRIbySURL(toSURL);
                }
                catch (UnapprochableSurlException e) {
                    this.log.info("srmMv: Unable to build a stori for surl " + toSURL + " UnapprochableSurlException: " + e.getMessage());
                    outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                    this.printRequestOutcome(outputData.getStatus(), inputData);
                    return outputData;
                }
            }
            catch (IllegalArgumentException e) {
                this.log.error("srmMv: Unable to build StoRI by SURL:[" + toSURL + "]. IllegalArgumentException: " + e.getMessage());
                outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Unable to build StoRI by destination SURL"));
                this.printRequestOutcome(outputData.getStatus(), inputData);
                return outputData;
            }
        } else {
            this.log.error("srmMv: unable to perform the operation, empty toSurl");
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid toSURL specified!"));
            this.printRequestOutcome(outputData.getStatus(), inputData);
            return outputData;
        }
        TSpaceToken token = new SpaceHelper().getTokenFromStoRI(this.log, fromStori);
        SpaceAuthzInterface spaceAuth = AuthzDirector.getSpaceAuthz(token);
        boolean isSpaceAuthorized = inputData instanceof IdentityInputData ? spaceAuth.authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMSpaceRequest.MV) : spaceAuth.authorizeAnonymous(SRMSpaceRequest.MV);
        if (!isSpaceAuthorized) {
            this.log.debug("srmMv: User not authorized to perform srmMv request on the storage area: " + token);
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, ": User not authorized to perform srmMv request on the storage area: " + token));
            this.printRequestOutcome(outputData.getStatus(), inputData);
            return outputData;
        }
        if (fromStori.getLocalFile().getPath().compareTo(toStori.getLocalFile().getPath()) == 0) {
            outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "Source SURL and target SURL are the same file."));
            this.printRequestOutcome(outputData.getStatus(), inputData);
            return outputData;
        }
        if (toStori.getLocalFile().exists() && toStori.getLocalFile().isDirectory()) {
            try {
                toStori = this.buildDestinationStoryForFolder(toSURL, fromStori, data);
            }
            catch (IllegalArgumentException e) {
                this.log.debug("srmMv : Unable to build StoRI by SURL '" + toSURL + "'. IllegalArgumentException: " + e.getMessage());
                outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INTERNAL_ERROR, "Unable to build StoRI by SURL"));
                this.printRequestOutcome(outputData.getStatus(), inputData);
                return outputData;
            }
            catch (UnapprochableSurlException e) {
                this.log.info("srmMv: Unable to build a stori for surl " + toSURL + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid SURL path specified"));
                this.printRequestOutcome(outputData.getStatus(), inputData);
                return outputData;
            }
            catch (InvalidTSURLAttributesException e) {
                this.log.error("Unable to create toSURL. InvalidTSURLAttributesException: " + e.getMessage());
                outputData.setStatus(CommandHelper.buildStatus(TStatusCode.SRM_INVALID_PATH, "Invalid toSURL specified!"));
                this.printRequestOutcome(outputData.getStatus(), inputData);
                return outputData;
            }
        }
        AuthzDecision sourceDecision = inputData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMFileRequest.MV_source, fromStori, toStori) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.MV_source, fromStori, toStori);
        AuthzDecision destinationDecision = inputData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMFileRequest.MV_dest, fromStori, toStori) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.MV_dest, fromStori, toStori);
        if (sourceDecision.equals((Object)AuthzDecision.PERMIT) && destinationDecision.equals((Object)AuthzDecision.PERMIT)) {
            this.log.debug("SrmMv: Mv authorized for " + DataHelper.getRequestor(inputData) + " for Source file = " + fromStori.getPFN() + " to Target file =" + toStori.getPFN());
            returnStatus = this.manageAuthorizedMV(fromStori, toStori.getLocalFile());
            if (returnStatus.isSRM_SUCCESS()) {
                LocalUser user = null;
                if (inputData instanceof IdentityInputData) {
                    try {
                        user = ((IdentityInputData)((Object)inputData)).getUser().getLocalUser();
                    }
                    catch (CannotMapUserException e) {
                        this.log.warn("srmMv: failed to get the requesting local user,unable to set user acls on the created file");
                        returnStatus.extendExplaination("unable to set user acls on the destination file");
                    }
                }
                if (user != null) {
                    this.setAcl(fromStori, toStori, user);
                } else {
                    this.setAcl(fromStori, toStori);
                }
            } else {
                this.log.warn("srmMv: <" + DataHelper.getRequestor(inputData) + "> Request for [fromSURL=" + fromSURL + "; toSURL=" + toSURL + "] failed with [status: " + returnStatus.toString() + "]");
            }
        } else {
            returnStatus = sourceDecision.equals((Object)AuthzDecision.PERMIT) ? CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User is not authorized to create and/or write the destination file") : (destinationDecision.equals((Object)AuthzDecision.PERMIT) ? CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User is not authorized to read and/or delete the source file") : CommandHelper.buildStatus(TStatusCode.SRM_AUTHORIZATION_FAILURE, "User is neither authorized to read and/or delete the source file nor to create and/or write the destination file"));
        }
        outputData.setStatus(returnStatus);
        this.printRequestOutcome(outputData.getStatus(), inputData);
        return outputData;
    }

    private StoRI buildDestinationStoryForFolder(TSURL toSURL, StoRI fromStori, InputData inputData) throws IllegalArgumentException, InvalidTSURLAttributesException, UnapprochableSurlException {
        String toSURLString = toSURL.getSURLString();
        if (!toSURLString.endsWith("/")) {
            toSURLString = toSURLString + "/";
        }
        toSURLString = toSURLString + fromStori.getFilename();
        this.log.debug("srmMv: New toSURL: " + toSURLString);
        StoRI toStori = inputData instanceof IdentityInputData ? this.namespace.resolveStoRIbySURL(TSURL.makeFromStringValidate(toSURLString), ((IdentityInputData)inputData).getUser()) : this.namespace.resolveStoRIbySURL(TSURL.makeFromStringValidate(toSURLString));
        return toStori;
    }

    private void setAcl(StoRI oldFileStoRI, StoRI newFileStoRI) {
        try {
            AclManagerFSAndHTTPS.getInstance().moveHttpsPermissions(oldFileStoRI.getLocalFile(), newFileStoRI.getLocalFile());
        }
        catch (IllegalArgumentException e) {
            this.log.error("Unable to move permissions from the old to the new file. IllegalArgumentException: " + e.getMessage());
        }
    }

    private void setAcl(StoRI oldFileStoRI, StoRI newFileStoRI, LocalUser localUser) {
        this.setAcl(oldFileStoRI, newFileStoRI);
        if (newFileStoRI.hasJustInTimeACLs()) {
            try {
                AclManagerFSAndHTTPS.getInstance().grantHttpsUserPermission(newFileStoRI.getLocalFile(), localUser, FilesystemPermission.ReadWrite);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Unable to grant user read and write permission on the new file. IllegalArgumentException: " + e.getMessage());
            }
        } else {
            try {
                AclManagerFSAndHTTPS.getInstance().grantHttpsGroupPermission(newFileStoRI.getLocalFile(), localUser, FilesystemPermission.ReadWrite);
            }
            catch (IllegalArgumentException e) {
                this.log.error("Unable to grant group read and write permission on the new file. IllegalArgumentException: " + e.getMessage());
            }
        }
    }

    private TReturnStatus manageAuthorizedMV(StoRI fromStori, LocalFile toFile) {
        String explanation = "";
        TStatusCode statusCode = TStatusCode.EMPTY;
        LocalFile fromFile = fromStori.getLocalFile();
        LocalFile toParent = toFile.getParentFile();
        boolean sourceExists = false;
        boolean targetDirExists = false;
        boolean targetFileExists = false;
        if (fromFile != null) {
            sourceExists = fromFile.exists();
        }
        if (toParent != null) {
            boolean bl = targetDirExists = toParent.exists() && toParent.isDirectory();
        }
        if (toFile != null) {
            targetFileExists = toFile.exists();
        }
        if (sourceExists && targetDirExists && !targetFileExists) {
            this.log.debug("srmMv : All Check passed.");
            TReturnStatus surlStatus = null;
            try {
                surlStatus = SurlStatusManager.getSurlStatus(fromStori.getSURL());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unexpected IllegalArgumentException in SurlStatusManager.getSurlsStatus: " + e);
            }
            catch (UnknownSurlException e) {
                this.log.debug("Surl " + fromStori.getSURL() + " not stored, surl is not busy. UnknownSurlException: " + e.getMessage());
            }
            if (TStatusCode.SRM_SPACE_AVAILABLE.equals(surlStatus)) {
                this.log.debug("srmMv requests fails because there is a PrepareToPut on the from SURL.");
                explanation = "There is an active SrmPrepareToPut on from SURL.";
                statusCode = TStatusCode.SRM_FILE_BUSY;
                return CommandHelper.buildStatus(statusCode, explanation);
            }
            this.log.debug("srmMv: No PrepareToPut running on from SURL.");
            if (TStatusCode.SRM_FILE_BUSY.equals(surlStatus)) {
                this.log.debug("SrmMv: requests fails because the source SURL is being used from other requests.");
                explanation = "There is an active SrmPrepareToGet on from SURL";
                statusCode = TStatusCode.SRM_FILE_BUSY;
                return CommandHelper.buildStatus(statusCode, explanation);
            }
            boolean creationDone = fromFile.renameTo(toFile.getPath());
            if (creationDone) {
                this.log.debug("SrmMv: Request success!");
                explanation = "SURL moved with success";
                statusCode = TStatusCode.SRM_SUCCESS;
            } else {
                this.log.debug("SrmMv: Requests fails because the path is invalid.");
                explanation = "Invalid path";
                statusCode = TStatusCode.SRM_INVALID_PATH;
            }
        } else if (!sourceExists) {
            this.log.debug("SrmMv: request fails because the source SURL does not exists!");
            explanation = "Source SURL does not exists!";
            statusCode = TStatusCode.SRM_INVALID_PATH;
        } else if (!targetDirExists) {
            this.log.debug("SrmMv: request fails because the target directory does not exitts.");
            explanation = "Target directory does not exits!";
            statusCode = TStatusCode.SRM_INVALID_PATH;
        } else if (targetFileExists) {
            this.log.debug("SrmMv: request fails because the target SURL exists.");
            explanation = "Target SURL exists!";
            statusCode = TStatusCode.SRM_DUPLICATION_ERROR;
        } else {
            this.log.debug("SrmMv request failure! That is a BUG!");
            explanation = "That is a bug!";
            statusCode = TStatusCode.SRM_INTERNAL_ERROR;
        }
        return CommandHelper.buildStatus(statusCode, explanation);
    }

    private void printRequestOutcome(TReturnStatus status, MvInputData inputData) {
        if (inputData != null) {
            if (inputData.getFromSURL() != null && inputData.getToSURL() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, (InputData)inputData, Arrays.asList(inputData.getFromSURL().toString(), inputData.getFromSURL().toString()));
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }
}

