/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.directory;

import it.grid.storm.authz.AuthzDecision;
import it.grid.storm.authz.AuthzDirector;
import it.grid.storm.authz.path.model.SRMFileRequest;
import it.grid.storm.catalogs.VolatileAndJiTCatalog;
import it.grid.storm.checksum.ChecksumAlgorithm;
import it.grid.storm.checksum.ChecksumManager;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.filesystem.FSException;
import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.griduser.CannotMapUserException;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.InvalidDescendantsAuthRequestException;
import it.grid.storm.namespace.InvalidDescendantsEmptyRequestException;
import it.grid.storm.namespace.InvalidDescendantsFileRequestException;
import it.grid.storm.namespace.InvalidDescendantsPathRequestException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.UnapprochableSurlException;
import it.grid.storm.srm.types.ArrayOfSURLs;
import it.grid.storm.srm.types.ArrayOfTMetaDataPathDetail;
import it.grid.storm.srm.types.InvalidTDirOptionAttributesException;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.InvalidTUserIDAttributeException;
import it.grid.storm.srm.types.TCheckSumType;
import it.grid.storm.srm.types.TCheckSumValue;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TFileLocality;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TFileType;
import it.grid.storm.srm.types.TGroupID;
import it.grid.storm.srm.types.TGroupPermission;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TMetaDataPathDetail;
import it.grid.storm.srm.types.TPermissionMode;
import it.grid.storm.srm.types.TRetentionPolicyInfo;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.srm.types.TUserID;
import it.grid.storm.srm.types.TUserPermission;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.DirectoryCommand;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.IdentityInputData;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.directory.LSInputData;
import it.grid.storm.synchcall.data.directory.LSOutputData;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownSurlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableInt;

public class LsCommand
extends DirectoryCommand
implements Command {
    private static final String SRM_COMMAND = "srmLs";
    private final NamespaceInterface namespace = NamespaceDirector.getNamespace();
    private boolean atLeastOneInputSURLIsDir;

    @Override
    public OutputData execute(InputData data) {
        int offset;
        int count;
        int numOfLevels;
        LSOutputData outputData = new LSOutputData();
        LSInputData inputData = (LSInputData)data;
        TReturnStatus globalStatus = TReturnStatus.getInitialValue();
        Object requestToken = null;
        outputData.setRequestToken(null);
        outputData.setDetails(null);
        if (inputData == null || inputData.getSurlArray() == null || inputData.getSurlArray().size() == 0) {
            this.log.debug("srmLs: Input parameters for srmLs request NOT found!");
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid input parameters specified");
            this.printRequestOutcome(globalStatus, inputData);
            outputData.setStatus(globalStatus);
            return outputData;
        }
        ArrayOfSURLs surlArray = inputData.getSurlArray();
        if (inputData.getStorageTypeSpecified()) {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_NOT_SUPPORTED, "Filtering result by fileStorageType not supported.");
            this.printRequestOutcome(globalStatus, inputData);
            outputData.setStatus(globalStatus);
            outputData.setRequestToken(null);
            outputData.setDetails(null);
            return outputData;
        }
        boolean fullDetailedList = inputData.getFullDetailedList() == null ? false : inputData.getFullDetailedList();
        boolean allLevelRecursive = inputData.getAllLevelRecursive() == null ? DirectoryCommand.config.getLSallLevelRecursive() : inputData.getAllLevelRecursive().booleanValue();
        if (inputData.getNumOfLevels() == null) {
            numOfLevels = DirectoryCommand.config.getLSnumOfLevels();
        } else {
            numOfLevels = inputData.getNumOfLevels();
            if (numOfLevels < 0) {
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Parameter 'numOfLevels' is negative");
                this.printRequestOutcome(globalStatus, inputData);
                outputData.setStatus(globalStatus);
                return outputData;
            }
        }
        boolean coutOrOffsetAreSpecified = false;
        if (inputData.getCount() == null) {
            count = DirectoryCommand.config.getLSMaxNumberOfEntry() + 1;
        } else {
            count = inputData.getCount();
            if (count < 0) {
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Parameter 'count' is less or equal zero");
                this.printRequestOutcome(globalStatus, inputData);
                outputData.setStatus(globalStatus);
                return outputData;
            }
            if (count == 0) {
                count = DirectoryCommand.config.getLSMaxNumberOfEntry() + 1;
            }
            coutOrOffsetAreSpecified = true;
        }
        if (inputData.getOffset() == null) {
            offset = DirectoryCommand.config.getLSoffset();
        } else {
            offset = inputData.getOffset();
            if (offset < 0) {
                globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "Parameter 'offset' is negative");
                this.printRequestOutcome(globalStatus, inputData);
                outputData.setStatus(globalStatus);
                return outputData;
            }
            coutOrOffsetAreSpecified = true;
        }
        ArrayOfTMetaDataPathDetail details = new ArrayOfTMetaDataPathDetail();
        TStatusCode fileLevelStatusCode = TStatusCode.EMPTY;
        String fileLevelExplanation = "";
        int errorCount = 0;
        int maxEntries = DirectoryCommand.config.getLSMaxNumberOfEntry();
        if (count < maxEntries) {
            maxEntries = count;
        }
        MutableInt numberOfReturnedEntries = new MutableInt(0);
        MutableInt numberOfIterations = new MutableInt(-1);
        this.atLeastOneInputSURLIsDir = false;
        for (int j = 0; j < surlArray.size(); ++j) {
            TSURL surl;
            boolean failure;
            StoRI stori;
            block35: {
                stori = null;
                failure = false;
                this.log.debug("srmLs: surlArray.size=" + surlArray.size());
                surl = surlArray.getTSURL(j);
                if (!surl.isEmpty()) {
                    try {
                        if (inputData instanceof IdentityInputData) {
                            try {
                                stori = this.namespace.resolveStoRIbySURL(surl, ((IdentityInputData)((Object)inputData)).getUser());
                            }
                            catch (UnapprochableSurlException e) {
                                failure = true;
                                this.log.info("Unable to build a stori for surl " + surl + " for user " + DataHelper.getRequestor(inputData) + " UnapprochableSurlException: " + e.getMessage());
                                fileLevelStatusCode = TStatusCode.SRM_INVALID_PATH;
                                fileLevelExplanation = "Invalid SURL path specified";
                                this.printRequestOutcome(CommandHelper.buildStatus(fileLevelStatusCode, fileLevelExplanation), inputData);
                            }
                            break block35;
                        }
                        try {
                            stori = this.namespace.resolveStoRIbySURL(surl);
                        }
                        catch (UnapprochableSurlException e) {
                            failure = true;
                            this.log.info("Unable to build a stori for surl " + surl + " UnapprochableSurlException: " + e.getMessage());
                            fileLevelStatusCode = TStatusCode.SRM_INVALID_PATH;
                            fileLevelExplanation = "Invalid SURL path specified";
                            this.printRequestOutcome(CommandHelper.buildStatus(fileLevelStatusCode, fileLevelExplanation), inputData);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error("srmLs: Unable to build StoRI by SURL: " + e);
                        failure = true;
                        fileLevelStatusCode = TStatusCode.SRM_INTERNAL_ERROR;
                        fileLevelExplanation = "Unable to build StoRI, Illegal Argument Exception";
                        this.printRequestOutcome(CommandHelper.buildStatus(fileLevelStatusCode, fileLevelExplanation), inputData);
                    }
                } else {
                    this.log.debug("srmLs: SURL not specified as input parameter!");
                    failure = true;
                    fileLevelStatusCode = TStatusCode.SRM_INVALID_PATH;
                    fileLevelExplanation = "Invalid path";
                    this.printRequestOutcome(CommandHelper.buildStatus(fileLevelStatusCode, fileLevelExplanation), inputData);
                }
            }
            if (!failure) {
                AuthzDecision lsAuthz = inputData instanceof IdentityInputData ? AuthzDirector.getPathAuthz().authorize(((IdentityInputData)((Object)inputData)).getUser(), SRMFileRequest.LS, stori) : AuthzDirector.getPathAuthz().authorizeAnonymous(SRMFileRequest.LS, stori.getStFN());
                if (lsAuthz.equals((Object)AuthzDecision.PERMIT)) {
                    this.log.debug("srmLs: Ls authorized for user [" + DataHelper.getRequestor(inputData) + "] and PFN = [" + stori.getPFN() + "]");
                    errorCount += this.manageAuthorizedLS(inputData, stori, details, allLevelRecursive, numOfLevels, fullDetailedList, errorCount, maxEntries, offset, numberOfReturnedEntries, 0, numberOfIterations);
                } else {
                    fileLevelStatusCode = TStatusCode.SRM_AUTHORIZATION_FAILURE;
                    fileLevelExplanation = "User does not have valid permissions";
                    this.printRequestOutcome(CommandHelper.buildStatus(fileLevelStatusCode, fileLevelExplanation), inputData);
                    failure = true;
                }
            }
            if (!failure) continue;
            ++errorCount;
            TReturnStatus status = CommandHelper.buildStatus(fileLevelStatusCode, fileLevelExplanation);
            this.printRequestOutcome(status, inputData);
            TMetaDataPathDetail elementDetail = new TMetaDataPathDetail();
            elementDetail.setStatus(status);
            elementDetail.setSurl(surl);
            if (stori != null) {
                elementDetail.setStFN(stori.getStFN());
            } else {
                elementDetail.setStFN(surl.sfn().stfn());
            }
            details.addTMetaDataPathDetail(elementDetail);
        }
        if (details.size() == 0) {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_INVALID_REQUEST, "The offset is grater than the number of results");
            this.printRequestOutcome(globalStatus, inputData);
            outputData.setStatus(globalStatus);
            return outputData;
        }
        if (numberOfReturnedEntries.intValue() >= maxEntries && maxEntries < count) {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_TOO_MANY_RESULTS, "Max returned entries is: " + DirectoryCommand.config.getLSMaxNumberOfEntry());
            this.printRequestOutcome(globalStatus, inputData);
            outputData.setStatus(globalStatus);
            return outputData;
        }
        this.log.debug("srmLs: Number of details specified in srmLs request:" + details.size());
        this.log.debug("srmLs: Creation of srmLs outputdata");
        String warningMessage = "";
        if (numOfLevels > 0 && this.atLeastOneInputSURLIsDir && coutOrOffsetAreSpecified) {
            warningMessage = "WARNING: specifying \"offset\" and/or \"count\" with \"numOfLevels\" greater than zero may result in inconsistent results among different srmLs requests. ";
        }
        if (errorCount == 0) {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, warningMessage + "All requests successfully completed");
            this.printRequestOutcome(globalStatus, inputData);
        } else if (errorCount < surlArray.size()) {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_PARTIAL_SUCCESS, warningMessage + "Check file statuses for details");
            this.printRequestOutcome(globalStatus, inputData);
        } else {
            globalStatus = CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "All requests failed");
            this.printRequestOutcome(globalStatus, inputData);
        }
        outputData.setStatus(globalStatus);
        outputData.setDetails(details);
        return outputData;
    }

    private void printRequestOutcome(TReturnStatus status, LSInputData inputData) {
        if (inputData != null) {
            if (inputData.getSurlArray() != null) {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, (InputData)inputData, inputData.getSurlArray().asStringList());
            } else {
                CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status, inputData);
            }
        } else {
            CommandHelper.printRequestOutcome(SRM_COMMAND, this.log, status);
        }
    }

    private int manageAuthorizedLS(LSInputData inputData, StoRI stori, ArrayOfTMetaDataPathDetail rootArray, boolean allLevelRecursive, int numOfLevels, boolean fullDetailedList, int errorCount, int count_maxEntries, int offset, MutableInt numberOfResults, int currentLevel, MutableInt numberOfIterations) {
        if (numberOfResults.intValue() >= count_maxEntries) {
            return errorCount;
        }
        numberOfIterations.increment();
        TMetaDataPathDetail currentElementDetail = new TMetaDataPathDetail();
        LocalFile localElement = stori.getLocalFile();
        if (localElement.exists()) {
            if (localElement.isDirectory()) {
                this.atLeastOneInputSURLIsDir = true;
                boolean directoryHasBeenAdedded = false;
                if (numberOfIterations.intValue() >= offset) {
                    this.populateDetailFromFS(stori, currentElementDetail);
                    if (fullDetailedList) {
                        try {
                            this.fullDetail(inputData, stori, currentElementDetail);
                        }
                        catch (FSException e) {
                            this.log.error("srmLs: unable to get full details on stori " + stori.getAbsolutePath() + " . FSException : " + e.getMessage());
                            ++errorCount;
                            try {
                                currentElementDetail.setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, "Unable to get full details"));
                            }
                            catch (InvalidTReturnStatusAttributeException ex1) {
                                this.log.error("srmLs: Error creating returnStatus " + ex1 + " NOTE: this is impossible!");
                            }
                        }
                    }
                    currentElementDetail.setStFN(stori.getStFN());
                    numberOfResults.increment();
                    rootArray.addTMetaDataPathDetail(currentElementDetail);
                    directoryHasBeenAdedded = true;
                }
                if (this.checkAnotherLevel(allLevelRecursive, numOfLevels, currentLevel)) {
                    ArrayOfTMetaDataPathDetail currentMetaDataArray;
                    if (directoryHasBeenAdedded) {
                        currentMetaDataArray = new ArrayOfTMetaDataPathDetail();
                        currentElementDetail.setArrayOfSubPaths(currentMetaDataArray);
                    } else {
                        currentMetaDataArray = rootArray;
                    }
                    List<StoRI> childrenArray = this.getFirstLevel(stori);
                    for (StoRI item : childrenArray) {
                        if (numberOfResults.intValue() < count_maxEntries) {
                            this.manageAuthorizedLS(inputData, item, currentMetaDataArray, allLevelRecursive, numOfLevels, fullDetailedList, errorCount, count_maxEntries, offset, numberOfResults, currentLevel + 1, numberOfIterations);
                            continue;
                        }
                        break;
                    }
                }
            } else if (numberOfIterations.intValue() >= offset && !this.namespace.isSpaceFile(stori.getFilename())) {
                this.populateDetailFromFS(stori, currentElementDetail);
                if (fullDetailedList) {
                    try {
                        this.fullDetail(inputData, stori, currentElementDetail);
                    }
                    catch (FSException e) {
                        this.log.error("srmLs: unable to get full details on stori " + stori.getAbsolutePath() + " . FSException : " + e.getMessage());
                        ++errorCount;
                        try {
                            currentElementDetail.setStatus(new TReturnStatus(TStatusCode.SRM_FAILURE, "Unable to get full details"));
                        }
                        catch (InvalidTReturnStatusAttributeException ex1) {
                            this.log.error("srmLs: Error creating returnStatus " + ex1 + " NOTE: this is impossible");
                        }
                    }
                }
                currentElementDetail.setStFN(stori.getStFN());
                numberOfResults.increment();
                rootArray.addTMetaDataPathDetail(currentElementDetail);
            }
        } else {
            this.log.debug("srmLs: The file does not exists in underlying file system.");
            if (numberOfIterations.intValue() >= offset) {
                ++errorCount;
                currentElementDetail.setStFN(stori.getStFN());
                this.populateDetailFromFS(stori, currentElementDetail);
                numberOfResults.increment();
                rootArray.addTMetaDataPathDetail(currentElementDetail);
            }
        }
        return errorCount;
    }

    private List<StoRI> getFirstLevel(StoRI element) {
        ArrayList<StoRI> result = null;
        TDirOption dirOption = null;
        try {
            dirOption = new TDirOption(true, false, 1);
        }
        catch (InvalidTDirOptionAttributesException ex) {
            this.log.debug("srmLs: Unable to create DIR OPTION. WOW!");
        }
        try {
            result = element.getChildren(dirOption);
        }
        catch (InvalidDescendantsFileRequestException ex1) {
            this.log.error("srmLs: Unable to retrieve StoRI children !" + ex1);
        }
        catch (InvalidDescendantsPathRequestException ex1) {
            this.log.error("srmLs: Unable to retrieve StoRI children !" + ex1);
        }
        catch (InvalidDescendantsAuthRequestException ex1) {
            this.log.error("srmLs: Unable to retrieve StoRI children !" + ex1);
        }
        catch (InvalidDescendantsEmptyRequestException ex1) {
            this.log.debug("srmLs: directory " + element.getAbsolutePath() + " is empty");
        }
        if (result == null) {
            result = new ArrayList(0);
        }
        return result;
    }

    private void populateDetailFromFS(StoRI element, TMetaDataPathDetail elementDetail) {
        TStatusCode statusCode;
        String explanation;
        boolean failure = false;
        TReturnStatus returnStatus = null;
        LocalFile localElement = element.getLocalFile();
        if (localElement.exists()) {
            TSizeInBytes size = TSizeInBytes.makeEmpty();
            try {
                if (!localElement.isDirectory()) {
                    size = TSizeInBytes.make(localElement.getExactSize(), SizeUnit.BYTES);
                    this.log.debug("srmLs: Extracting size: " + localElement.getPath() + " SIZE: " + size);
                } else {
                    size = TSizeInBytes.make(0L, SizeUnit.BYTES);
                }
            }
            catch (InvalidTSizeAttributesException ex) {
                this.log.error("srmLs: Unable to create the size of file.", (Throwable)ex);
                failure = true;
            }
            elementDetail.setSize(size);
            if (!failure) {
                explanation = "Successful request completion";
                statusCode = this.isStoRISURLBusy(element) ? TStatusCode.SRM_FILE_BUSY : TStatusCode.SRM_SUCCESS;
            } else {
                explanation = "Request failed";
                statusCode = TStatusCode.SRM_FAILURE;
            }
        } else {
            explanation = "No such file or directory";
            statusCode = TStatusCode.SRM_INVALID_PATH;
        }
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            this.log.error("srmLs: Error creating returnStatus " + ex1);
        }
        elementDetail.setStatus(returnStatus);
    }

    private boolean isStoRISURLBusy(StoRI element) {
        try {
            return TStatusCode.SRM_SPACE_AVAILABLE.equals(SurlStatusManager.getSurlStatus(element.getSURL()));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("unexpected IllegalArgumentException in SurlStatusManager.getSurlsStatus: " + e);
        }
        catch (UnknownSurlException e) {
            this.log.debug("Surl " + element.getSURL() + " not stored, surl is not busy");
            return false;
        }
    }

    private void fullDetail(LSInputData inputData, StoRI stori, TMetaDataPathDetail currentElementDetail) throws FSException {
        if (inputData instanceof IdentityInputData) {
            this.fullDetail(stori, ((IdentityInputData)((Object)inputData)).getUser(), currentElementDetail);
        } else {
            this.fullDetail(stori, currentElementDetail);
        }
    }

    private void fullDetail(StoRI element, GridUserInterface guser, TMetaDataPathDetail elementDetail) throws FSException {
        this.fullDetail(element, elementDetail);
        TUserPermission userPermission = null;
        TGroupPermission groupPermission = null;
        TPermissionMode otherPermission = null;
        try {
            FilesystemPermission permission = null;
            permission = element.hasJustInTimeACLs() ? element.getLocalFile().getUserPermission(guser.getLocalUser()) : element.getLocalFile().getGroupPermission(guser.getLocalUser());
            if (permission != null) {
                userPermission = new TUserPermission(new TUserID(guser.getLocalUser().getLocalUserName()), TPermissionMode.getTPermissionMode(permission));
                groupPermission = new TGroupPermission(new TGroupID(guser.getLocalUser().getLocalUserName()), TPermissionMode.getTPermissionMode(permission));
                otherPermission = TPermissionMode.getTPermissionMode(permission);
            }
        }
        catch (CannotMapUserException e) {
            this.log.error("Cannot map user. CannotMapUserException: " + e.getMessage());
            return;
        }
        catch (InvalidTUserIDAttributeException e) {
            this.log.error("Error creating TUserID. InvalidTUserIDAttributeException: " + e.getMessage());
            return;
        }
        if (element.getLocalFile().isDirectory()) {
            elementDetail.setOwnerPermission(userPermission);
            elementDetail.setGroupPermission(groupPermission);
            elementDetail.setOtherPermission(otherPermission);
        } else {
            if (userPermission == null) {
                userPermission = TUserPermission.makeFileDefault();
            }
            elementDetail.setOwnerPermission(userPermission);
            if (groupPermission == null) {
                groupPermission = TGroupPermission.makeFileDefault();
            }
            elementDetail.setGroupPermission(groupPermission);
            if (otherPermission == null) {
                otherPermission = TPermissionMode.NONE;
            }
            elementDetail.setOtherPermission(otherPermission);
        }
    }

    private void fullDetail(StoRI element, TMetaDataPathDetail elementDetail) throws FSException {
        LocalFile localElement = element.getLocalFile();
        elementDetail.setModificationTime(new Date(localElement.getLastModifiedTime()));
        if (localElement.isDirectory()) {
            elementDetail.setFileType(TFileType.getTFileType("Directory"));
        } else {
            elementDetail.setFileType(TFileType.getTFileType("File"));
            boolean isTapeEnabled = element.getVirtualFileSystem().getStorageClassType().isTapeEnabled();
            TRetentionPolicyInfo retentionPolicyInfo = isTapeEnabled ? TRetentionPolicyInfo.TAPE1_DISK1_RETENTION_POLICY : TRetentionPolicyInfo.TAPE0_DISK1_RETENTION_POLICY;
            elementDetail.setTRetentionPolicyInfo(retentionPolicyInfo);
            boolean isFileOnDisk = false;
            if (isTapeEnabled) {
                isFileOnDisk = localElement.isOnDisk();
                if (isFileOnDisk && localElement.isOnTape()) {
                    elementDetail.setTFileLocality(TFileLocality.ONLINE_AND_NEARLINE);
                } else if (isFileOnDisk) {
                    elementDetail.setTFileLocality(TFileLocality.ONLINE);
                } else {
                    elementDetail.setTFileLocality(TFileLocality.NEARLINE);
                }
            } else {
                elementDetail.setTFileLocality(TFileLocality.ONLINE);
            }
            elementDetail.setLifeTimeAssigned(element.getFileLifeTime());
            if (element.getFileStartTime() != null) {
                elementDetail.setLifetimeLeft(element.getFileLifeTime().timeLeft(element.getFileStartTime()));
            } else {
                elementDetail.setLifetimeLeft(TLifeTimeInSeconds.makeInfinite());
            }
            Map<String, String> checksums = this.retrieveChecksum(localElement, isTapeEnabled, isFileOnDisk);
            if (!checksums.isEmpty()) {
                String cksmAlg = checksums.keySet().iterator().next();
                String cksmValue = checksums.get(cksmAlg);
                TCheckSumValue checkSumValue = new TCheckSumValue(cksmValue);
                try {
                    ChecksumAlgorithm chkType = ChecksumAlgorithm.getChecksumAlgorithm(cksmAlg);
                    TCheckSumType checkSumType = new TCheckSumType(chkType.toString());
                    elementDetail.setCheckSumType(checkSumType);
                    elementDetail.setCheckSumValue(checkSumValue);
                }
                catch (IllegalArgumentException iae) {
                    this.log.error("Checksum algorithm '" + cksmAlg + "' is unknown!");
                }
                catch (NullPointerException npe) {
                    this.log.error("Checksum algorithm is empty or null!");
                }
            }
            this.populateFileDetailsFromPersistence(element, elementDetail);
        }
    }

    private Map<String, String> retrieveChecksum(LocalFile localFile, boolean tapeEnabled, boolean fileOnDisk) {
        HashMap<String, String> checksums = new HashMap<String, String>();
        if (localFile.hasChecksum()) {
            String checksum = localFile.getDefaultChecksum();
            if (checksum != null) {
                checksums.put(ChecksumManager.getInstance().getDefaultAlgorithm(), checksum);
            }
        } else {
            Map<String, String> cksms = localFile.getChecksums();
            if (cksms.isEmpty()) {
                this.log.warn("Checksum value is not available for file :'" + localFile.getAbsolutePath() + "'");
            } else {
                String cksmAlg = cksms.keySet().iterator().next();
                String cksmValue = cksms.values().iterator().next();
                checksums.put(cksmAlg, cksmValue);
            }
        }
        return checksums;
    }

    private void populateFileDetailsFromPersistence(StoRI element, TMetaDataPathDetail elementDetail) {
        boolean isVolatile = VolatileAndJiTCatalog.getInstance().exists(element.getPFN());
        if (isVolatile) {
            elementDetail.setTFileStorageType(TFileStorageType.VOLATILE);
        } else {
            elementDetail.setTFileStorageType(TFileStorageType.PERMANENT);
        }
    }

    private boolean checkAnotherLevel(boolean allLevelRecursive, int numOfLevels, int currentLevel) {
        boolean result = false;
        if (allLevelRecursive) {
            result = true;
        } else if (currentLevel < numOfLevels) {
            result = true;
        }
        return result;
    }
}

