/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.srm.types.ArrayOfTSURLReturnStatus;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TSURLReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.CommandHelper;
import it.grid.storm.synchcall.command.datatransfer.FileTransferRequestStatusCommand;

public class PrepareToPutRequestStatusCommand
extends FileTransferRequestStatusCommand
implements Command {
    private static final String SRM_COMMAND = "srmStatusOfPutRequest";

    @Override
    protected String getSrmCommand() {
        return SRM_COMMAND;
    }

    @Override
    protected TRequestType getRequestType() {
        return TRequestType.PREPARE_TO_PUT;
    }

    @Override
    protected TReturnStatus computeRequestStatus(ArrayOfTSURLReturnStatus arrayOfFileStatuses) {
        boolean atLeastOneSuccessOrSpaceAvailable = false;
        boolean atLeastOneQueued = false;
        boolean atLeastOneInProgress = false;
        boolean atLeastOneAborted = false;
        boolean atLeastOneFailed = false;
        block8: for (TSURLReturnStatus surlStatus : arrayOfFileStatuses.getArray()) {
            switch (surlStatus.getStatus().getStatusCode()) {
                case SRM_SUCCESS: {
                    atLeastOneSuccessOrSpaceAvailable = true;
                    continue block8;
                }
                case SRM_SPACE_AVAILABLE: {
                    atLeastOneSuccessOrSpaceAvailable = true;
                    continue block8;
                }
                case SRM_REQUEST_QUEUED: {
                    atLeastOneQueued = true;
                    continue block8;
                }
                case SRM_REQUEST_INPROGRESS: {
                    atLeastOneInProgress = true;
                }
                case SRM_RELEASED: {
                    continue block8;
                }
                case SRM_ABORTED: {
                    atLeastOneAborted = true;
                    continue block8;
                }
            }
            atLeastOneFailed = true;
        }
        if (!(!atLeastOneSuccessOrSpaceAvailable || atLeastOneQueued || atLeastOneInProgress || atLeastOneAborted || atLeastOneFailed)) {
            return CommandHelper.buildStatus(TStatusCode.SRM_SUCCESS, "Request executed successfully");
        }
        if ((atLeastOneSuccessOrSpaceAvailable || atLeastOneAborted || atLeastOneFailed) && atLeastOneQueued || atLeastOneInProgress) {
            return CommandHelper.buildStatus(TStatusCode.SRM_REQUEST_INPROGRESS, "Request in progress");
        }
        if (atLeastOneSuccessOrSpaceAvailable && atLeastOneFailed && !atLeastOneQueued && !atLeastOneInProgress) {
            return CommandHelper.buildStatus(TStatusCode.SRM_PARTIAL_SUCCESS, "Partial success, some surls are failed");
        }
        if (!(!atLeastOneAborted || atLeastOneQueued || atLeastOneInProgress || atLeastOneSuccessOrSpaceAvailable || atLeastOneFailed)) {
            return CommandHelper.buildStatus(TStatusCode.SRM_ABORTED, "Request aborted");
        }
        return CommandHelper.buildStatus(TStatusCode.SRM_FAILURE, "Request failed");
    }
}

