/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.synchcall.command.datatransfer;

import it.grid.storm.asynch.AdvancedPicker;
import it.grid.storm.catalogs.RequestSummaryCatalog;
import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;
import it.grid.storm.srm.types.TReturnStatus;
import it.grid.storm.srm.types.TStatusCode;
import it.grid.storm.synchcall.command.Command;
import it.grid.storm.synchcall.command.DataTransferCommand;
import it.grid.storm.synchcall.command.datatransfer.AbortExecutorInterface;
import it.grid.storm.synchcall.command.datatransfer.CopyAbortExecutor;
import it.grid.storm.synchcall.command.datatransfer.PtGAbortExecutor;
import it.grid.storm.synchcall.command.datatransfer.PtPAbortExecutor;
import it.grid.storm.synchcall.data.DataHelper;
import it.grid.storm.synchcall.data.InputData;
import it.grid.storm.synchcall.data.OutputData;
import it.grid.storm.synchcall.data.datatransfer.AbortInputData;
import it.grid.storm.synchcall.data.datatransfer.AbortRequestOutputData;
import it.grid.storm.synchcall.surl.ExpiredTokenException;
import it.grid.storm.synchcall.surl.SurlStatusManager;
import it.grid.storm.synchcall.surl.UnknownTokenException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbortRequestCommand
extends DataTransferCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(AbortRequestCommand.class);
    private AdvancedPicker advancedPicker = null;
    private AbortExecutorInterface executor = null;

    @Override
    public OutputData execute(InputData data) {
        TRequestType rtype;
        this.advancedPicker = new AdvancedPicker();
        AbortRequestOutputData outputData = new AbortRequestOutputData();
        AbortInputData inputData = (AbortInputData)data;
        boolean res = false;
        TReturnStatus globalStatus = null;
        log.debug("Started AbortRequest function.");
        if (inputData == null || inputData.getRequestToken() == null || inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("SrmAbortRequest: Invalid input parameter specified");
            globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Missing mandatory parameters");
            outputData.setReturnStatus(globalStatus);
            outputData.setArrayOfFileStatuses(null);
            log.error("srmAbortRequest: <> Request for [token:] [SURL:] failed with [status: " + globalStatus + "]");
            return outputData;
        }
        TRequestToken requestToken = inputData.getRequestToken();
        log.debug("srmAbortRequest: requestToken=" + requestToken.toString());
        if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST)) {
            log.debug("Phase (1.A) AbortRequest: SurlArray Not specified.");
            try {
                SurlStatusManager.checkAndUpdateStatus(inputData.getRequestToken(), TStatusCode.SRM_REQUEST_QUEUED, TStatusCode.SRM_ABORTED, "User aborted request!");
            }
            catch (UnknownTokenException e) {
                log.info("Unable to update surls status on token " + requestToken + " .UnknownTokenException: " + e.getMessage());
                globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token");
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            catch (ExpiredTokenException e) {
                log.info("Unable to update surls status on token " + requestToken + " .ExpiredTokenException: " + e.getMessage());
                globalStatus = this.manageStatus(TStatusCode.SRM_REQUEST_TIMED_OUT, "Request expired");
                outputData.setArrayOfFileStatuses(null);
                log.info("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
                return outputData;
            }
            RequestSummaryCatalog.getInstance().updateFromPreviousGlobalStatus(inputData.getRequestToken(), TStatusCode.SRM_REQUEST_QUEUED, TStatusCode.SRM_ABORTED, "User aborted request!");
            res = false;
        } else if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("Phase (1.A) AbortRequest: SurlArray Specified.");
            res = false;
        }
        if (!res) {
            log.debug("Phase (1.A) AbortRequest: Token not found.");
        }
        if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_REQUEST)) {
            log.debug("Phase (1.B) AbortRequest: SurlArray Not specified.");
            this.advancedPicker.abortRequest(inputData.getRequestToken());
            res = false;
        } else if (inputData.getType().equals((Object)AbortInputData.AbortType.ABORT_FILES)) {
            log.debug("Phase (1.B) AbortRequest: SurlArray Specified.");
            res = false;
        }
        if (!res) {
            log.debug("Phase (1.B) AbortRequest: Token not found.");
        }
        if ((rtype = SurlStatusManager.isPersisted(requestToken)) == TRequestType.PREPARE_TO_GET) {
            this.executor = new PtGAbortExecutor();
            return this.executor.doIt(inputData);
        }
        if (rtype == TRequestType.PREPARE_TO_PUT) {
            this.executor = new PtPAbortExecutor();
            return this.executor.doIt(inputData);
        }
        if (rtype == TRequestType.COPY) {
            this.executor = new CopyAbortExecutor();
            return this.executor.doIt(inputData);
        }
        log.debug("This case is really possibile?");
        log.debug("SrmAbortRequest : Invalid input parameter specified");
        globalStatus = this.manageStatus(TStatusCode.SRM_INVALID_REQUEST, "Invalid request token. Abort only works for PtG, PtP and Copy.");
        log.error("srmAbortRequest: <" + DataHelper.getRequestor(inputData) + "> Request for [token:" + inputData.getRequestToken() + "] failed with [status: " + globalStatus + "]");
        outputData.setReturnStatus(globalStatus);
        outputData.setArrayOfFileStatuses(null);
        return outputData;
    }

    private TReturnStatus manageStatus(TStatusCode statusCode, String explanation) {
        TReturnStatus returnStatus = null;
        try {
            returnStatus = new TReturnStatus(statusCode, explanation);
        }
        catch (InvalidTReturnStatusAttributeException ex1) {
            log.debug("AbortExecutor : Error creating returnStatus " + ex1);
        }
        return returnStatus;
    }
}

