/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.InvalidTFNAttributesException;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.TFN;
import it.grid.storm.common.types.TransferProtocol;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.srm.types.InvalidTTURLAttributesException;
import java.util.Map;
import org.slf4j.Logger;

public class TTURL {
    private static Logger log = NamespaceDirector.getLogger();
    private TransferProtocol tp;
    private TFN tfn;
    private boolean empty = true;
    public static final String PNAME_TURL = "turl";

    private TTURL(TransferProtocol tp, TFN tfn, boolean empty) {
        this.tp = tp;
        this.tfn = tfn;
        this.empty = empty;
    }

    public static TTURL makeEmpty() {
        return new TTURL(TransferProtocol.EMPTY, TFN.makeEmpty(), true);
    }

    public static TTURL make(TransferProtocol tp, TFN tfn) throws InvalidTTURLAttributesException {
        if (tp == null || tfn == null || tp == TransferProtocol.EMPTY || tfn.isEmpty()) {
            throw new InvalidTTURLAttributesException(tp, tfn);
        }
        return new TTURL(tp, tfn, false);
    }

    public static TTURL makeFromString(String s) throws InvalidTTURLAttributesException {
        if (s == null) {
            throw new InvalidTTURLAttributesException(null, null);
        }
        int separator = s.indexOf("://");
        if (separator == -1 || separator == 0) {
            throw new InvalidTTURLAttributesException(null, null);
        }
        String tpString = s.substring(0, separator);
        TransferProtocol tp = null;
        try {
            tp = TransferProtocol.getTransferProtocol(tpString);
        }
        catch (IllegalArgumentException e) {
            log.warn("TTURL: Transfer protocol by '" + tpString + "' is empty, but that's fine.");
        }
        if (separator + 3 > s.length()) {
            throw new InvalidTTURLAttributesException(tp, null);
        }
        String tfnString = s.substring(separator + 3, s.length());
        TFN tfn = null;
        if (tfnString.startsWith("/")) {
            try {
                tfn = TFN.makeByPFN(PFN.make(tfnString));
            }
            catch (InvalidTFNAttributesException e) {
                log.warn("TFN by '" + tfnString + "' is empty, but that's fine.");
            }
            catch (InvalidPFNAttributeException ex) {
                log.error("PFN by '" + tfnString + "' cause an error : " + ex);
            }
        } else {
            try {
                tfn = TFN.makeFromString(tfnString);
            }
            catch (InvalidTFNAttributesException e) {
                log.warn("TFN by '" + tfnString + "' is empty, but that's fine.");
            }
        }
        return TTURL.make(tp, tfn);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public TransferProtocol protocol() {
        if (this.empty) {
            return TransferProtocol.EMPTY;
        }
        return this.tp;
    }

    public TFN tfn() {
        if (this.empty) {
            return TFN.makeEmpty();
        }
        return this.tfn;
    }

    public void encode(Map<String, Object> param, String name) {
        param.put(name, this.toString());
    }

    public String toString() {
        if (this.empty) {
            return "Empty TTURL";
        }
        return this.tp + "://" + this.tfn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TTURL)) {
            return false;
        }
        TTURL turlo = (TTURL)o;
        if (this.empty && turlo.empty) {
            return true;
        }
        return !this.empty && !turlo.empty && this.tp.equals(turlo.tp) && this.tfn.equals(turlo.tfn);
    }

    public int hashCode() {
        if (this.empty) {
            return 0;
        }
        int hash = 17;
        hash = 37 * hash + this.tp.hashCode();
        hash = 37 * hash + this.tfn.hashCode();
        return hash;
    }
}

