/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.common.types.EndPoint;
import it.grid.storm.common.types.InvalidEndPointAttributeException;
import it.grid.storm.common.types.InvalidMachineAttributeException;
import it.grid.storm.common.types.InvalidPortAttributeException;
import it.grid.storm.common.types.InvalidSFNAttributesException;
import it.grid.storm.common.types.InvalidStFNAttributeException;
import it.grid.storm.common.types.Machine;
import it.grid.storm.common.types.Port;
import it.grid.storm.common.types.SFN;
import it.grid.storm.common.types.SiteProtocol;
import it.grid.storm.common.types.StFN;
import it.grid.storm.config.Configuration;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.naming.SURL;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class TSURL {
    private static Logger log = NamespaceDirector.getLogger();
    private final String rawSurl;
    private final SiteProtocol sp;
    private final SFN sfn;
    private String normalizedStFN = null;
    private int uniqueID = 0;
    private boolean empty = true;
    public static final String PNAME_SURL = "surl";
    public static final String PNAME_FROMSURL = "fromSURL";
    public static final String PNAME_TOSURL = "toSURL";
    private static ArrayList<TSURL> tsurlManaged = new ArrayList();
    private static LinkedList<Port> defaultPorts = new LinkedList();

    private TSURL(SiteProtocol sp, SFN sfn, String rawSurl, boolean empty) {
        this.sp = sp;
        this.sfn = sfn;
        this.rawSurl = rawSurl;
        this.empty = empty;
    }

    public static TSURL decode(Map<String, Object> inputParam, String name) throws InvalidTSURLAttributesException {
        String surlstring = (String)inputParam.get(name);
        return TSURL.makeFromStringWellFormed(surlstring);
    }

    public static TSURL getWellFormed(SURL surl, String rawSurl) throws InvalidTSURLAttributesException {
        SFN sfn;
        Machine machine = null;
        try {
            machine = Machine.make(surl.getServiceHostname());
            log.debug("Machine built : '" + machine + "'");
        }
        catch (InvalidMachineAttributeException ex1) {
            log.error("MACHINE '" + surl.getServiceHostname() + "' is invalid! ");
            throw new InvalidTSURLAttributesException(null, null);
        }
        String stfn = surl.getStFN();
        StFN stfnClass = null;
        try {
            stfnClass = StFN.make(stfn);
            log.debug("StFN Class built : '" + stfnClass + "'");
        }
        catch (InvalidStFNAttributeException ex2) {
            log.error("StFN '" + stfn + "' is invalid! ");
            throw new InvalidTSURLAttributesException(null, null);
        }
        int portInt = surl.getServiceHostPort();
        EndPoint serviceEndpoint = null;
        if (surl.isQueriedFormSURL()) {
            String serviceEndPointString = surl.getServiceEndPoint();
            try {
                serviceEndpoint = EndPoint.make(serviceEndPointString);
                log.debug("EndPoint built : '" + serviceEndpoint + "'");
            }
            catch (InvalidEndPointAttributeException e) {
                log.error("EndPoint '" + serviceEndpoint + "' is invalid! " + e);
                throw new InvalidTSURLAttributesException(null, null);
            }
        }
        if (portInt > -1) {
            Port port = null;
            try {
                port = Port.make(portInt);
                log.debug("PORT built : '" + port + "'");
            }
            catch (InvalidPortAttributeException ex3) {
                log.error("PORT '" + portInt + "' is invalid! ");
                throw new InvalidTSURLAttributesException(null, null);
            }
            try {
                sfn = serviceEndpoint == null ? SFN.makeInSimpleForm(machine, port, stfnClass) : SFN.makeInQueryForm(machine, port, serviceEndpoint, stfnClass);
                log.debug("SFN built : '" + sfn + "'");
            }
            catch (InvalidSFNAttributesException ex4) {
                log.error("SFN building problem");
                throw new InvalidTSURLAttributesException(null, null);
            }
        }
        try {
            sfn = serviceEndpoint == null ? SFN.makeInSimpleForm(machine, stfnClass) : SFN.makeInQueryForm(machine, serviceEndpoint, stfnClass);
            log.debug("SFN built : '" + sfn + "'");
        }
        catch (InvalidSFNAttributesException ex5) {
            log.error("SFN building problem");
            throw new InvalidTSURLAttributesException(null, null);
        }
        TSURL result = TSURL.make(SiteProtocol.SRM, sfn, rawSurl);
        return result;
    }

    private static TSURL make(SiteProtocol sp, SFN sfn, String userSurl) throws InvalidTSURLAttributesException {
        if (sp == null || sfn == null || sp == SiteProtocol.EMPTY || sfn.isEmpty()) {
            throw new InvalidTSURLAttributesException(sp, sfn);
        }
        return new TSURL(sp, sfn, userSurl, false);
    }

    public static TSURL makeEmpty() {
        return new TSURL(SiteProtocol.EMPTY, SFN.makeEmpty(), "", true);
    }

    public static TSURL makeFromStringWellFormed(String surlString) throws InvalidTSURLAttributesException {
        SURL surl;
        TSURL result = null;
        if (surlString == null) {
            throw new InvalidTSURLAttributesException(null, null);
        }
        int separator = surlString.indexOf("://");
        if (separator == -1 || separator == 0) {
            throw new InvalidTSURLAttributesException(null, null);
        }
        String spString = surlString.substring(0, separator);
        SiteProtocol sp = null;
        try {
            sp = SiteProtocol.fromString(spString);
        }
        catch (IllegalArgumentException e) {
            log.warn("TSURL: Site protocol by '" + spString + "' is empty, but that's fine.");
        }
        if (separator + 3 > surlString.length()) {
            throw new InvalidTSURLAttributesException(sp, null);
        }
        log.debug("MAKE SURL : '" + surlString + "'");
        try {
            surl = SURL.makeSURLfromString(surlString);
        }
        catch (NamespaceException ex) {
            log.error("SURL '" + surlString + "' is invalid! ");
            throw new InvalidTSURLAttributesException(null, null);
        }
        result = TSURL.getWellFormed(surl, surlString);
        return result;
    }

    public static TSURL makeFromStringValidate(String surlString) throws InvalidTSURLAttributesException {
        log.debug("MAKE SURL in Validating mode: '" + surlString + "'");
        TSURL tsurl = TSURL.makeFromStringWellFormed(surlString);
        if (!TSURL.isValid(tsurl)) {
            log.warn("The SURL '" + tsurl + "' is not managed by this instance of StoRM");
            throw new InvalidTSURLAttributesException(tsurl.sp, tsurl.sfn());
        }
        return tsurl;
    }

    public static boolean isValid(TSURL surl) {
        return TSURL.isManaged(surl, tsurlManaged);
    }

    public static boolean isManaged(TSURL surl, List<TSURL> managedSurls) {
        boolean result = false;
        for (TSURL tsurlReference : managedSurls) {
            if (!TSURL.isSURLManaged(surl, tsurlReference)) continue;
            result = true;
            break;
        }
        return result;
    }

    private static boolean isSURLManaged(TSURL comingSURL, TSURL managedSURL) {
        boolean result = false;
        String serviceHost = comingSURL.sfn().machine().toString();
        String expectedServiceHost = managedSURL.sfn().machine().toString();
        log.debug("SURL VALID [ coming-service-host = '" + serviceHost + "' expected : '" + expectedServiceHost + "'");
        if (comingSURL.sfn().port().isEmpty()) {
            if (serviceHost.equalsIgnoreCase(expectedServiceHost)) {
                result = true;
            }
        } else if (!managedSURL.sfn().port().isEmpty()) {
            int expectedServicePort = managedSURL.sfn().port().toInt();
            int port = comingSURL.sfn().port().toInt();
            log.debug("SURL VALID [ coming-service-port = '" + port + "' expected : '" + expectedServicePort + "'");
            if (serviceHost.equalsIgnoreCase(expectedServiceHost) && expectedServicePort == port) {
                result = true;
            }
        } else {
            int port = comingSURL.sfn().port().toInt();
            try {
                Port comingPort = Port.make(port);
                if (serviceHost.equalsIgnoreCase(expectedServiceHost) && defaultPorts.contains(comingPort)) {
                    result = true;
                }
            }
            catch (InvalidPortAttributeException e) {
                log.warn("The SURL '" + comingSURL + "' has ha not valid port. Unable to create the Port : " + e);
            }
        }
        return result;
    }

    public void encode(Map<String, Object> param, String name) {
        param.put(name, this.toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.empty ? 1231 : 1237);
        result = 31 * result + (this.normalizedStFN() == null ? 0 : this.normalizedStFN().hashCode());
        result = 31 * result + (this.rawSurl == null ? 0 : this.rawSurl.hashCode());
        result = 31 * result + (this.sfn() == null ? 0 : this.sfn().hashCode());
        result = 31 * result + (this.protocol() == null ? 0 : this.protocol().hashCode());
        result = 31 * result + this.uniqueId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TSURL other = (TSURL)obj;
        if (this.empty != other.empty) {
            return false;
        }
        if (this.normalizedStFN() == null ? other.normalizedStFN() != null : !this.normalizedStFN().equals(other.normalizedStFN())) {
            return false;
        }
        if (this.rawSurl == null ? other.rawSurl != null : !this.rawSurl.equals(other.rawSurl)) {
            return false;
        }
        if (this.sfn() == null ? other.sfn() != null : !this.sfn().equals(other.sfn())) {
            return false;
        }
        if (this.protocol() == null ? other.protocol() != null : !this.protocol().equals(other.protocol())) {
            return false;
        }
        return this.uniqueId() == other.uniqueId();
    }

    public String getSURLString() {
        if (this.empty) {
            return "";
        }
        return this.sp + "://" + this.sfn;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public SiteProtocol protocol() {
        if (this.empty) {
            return SiteProtocol.EMPTY;
        }
        return this.sp;
    }

    public String rawSurl() {
        return this.rawSurl;
    }

    public SFN sfn() {
        if (this.empty) {
            return SFN.makeEmpty();
        }
        return this.sfn;
    }

    public String normalizedStFN() {
        if (this.normalizedStFN == null) {
            this.normalizedStFN = this.sfn.stfn().toString();
        }
        return this.normalizedStFN;
    }

    public void setNormalizedStFN(String normalizedStFN) {
        this.normalizedStFN = normalizedStFN;
    }

    public void setUniqueID(int uniqueID) {
        this.uniqueID = uniqueID;
    }

    public int uniqueId() {
        if (this.uniqueID == 0) {
            this.uniqueID = this.sfn.stfn().hashCode();
        }
        return this.uniqueID;
    }

    public String toString() {
        if (this.empty) {
            return "Empty TSURL";
        }
        return this.sp + "://" + this.sfn;
    }

    static {
        if (tsurlManaged.isEmpty()) {
            String[] surlValid;
            for (String checkSurl : surlValid = Configuration.getInstance().getManagedSURLs()) {
                try {
                    TSURL checkTSURL = TSURL.makeFromStringWellFormed(checkSurl);
                    tsurlManaged.add(checkTSURL);
                    log.debug("### SURL Managed : " + checkTSURL);
                }
                catch (InvalidTSURLAttributesException e) {
                    log.error("Unable to build a TSURL : '" + checkSurl + "'");
                }
            }
        }
        if (defaultPorts.isEmpty()) {
            Integer[] ports;
            for (Integer portInteger : ports = Configuration.getInstance().getManagedSurlDefaultPorts()) {
                try {
                    defaultPorts.add(Port.make(portInteger));
                    log.debug("### Default SURL port : " + defaultPorts.getLast());
                }
                catch (InvalidPortAttributeException e) {
                    log.error("Unable to build a Port : '" + portInteger + "'" + e);
                }
            }
        }
    }
}

