/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.srm.types.InvalidTReturnStatusAttributeException;
import it.grid.storm.srm.types.TStatusCode;
import java.io.Serializable;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

public class TReturnStatus
implements Serializable {
    private static final long serialVersionUID = -4550845540710062810L;
    protected TStatusCode statusCode = null;
    protected String explanation = null;
    private Long lastUpdateTIme = null;
    private static final String UNDEFINED_EXPLANATION = "undefined";
    public static final String PNAME_RETURNSTATUS = "returnStatus";
    public static final String PNAME_STATUS = "status";

    public TReturnStatus() throws InvalidTReturnStatusAttributeException {
        this(TStatusCode.SRM_CUSTOM_STATUS);
    }

    public TReturnStatus(TReturnStatus original) throws InvalidTReturnStatusAttributeException {
        if (original == null || original.statusCode == null) {
            throw new InvalidTReturnStatusAttributeException(this.statusCode);
        }
        this.statusCode = original.statusCode;
        this.explanation = original.explanation;
        this.updated();
    }

    public TReturnStatus(TStatusCode statusCode) throws InvalidTReturnStatusAttributeException {
        this(statusCode, UNDEFINED_EXPLANATION);
    }

    public TReturnStatus(TStatusCode statusCode, String explanation) throws InvalidTReturnStatusAttributeException {
        if (statusCode == null) {
            throw new InvalidTReturnStatusAttributeException(statusCode);
        }
        this.statusCode = statusCode;
        this.explanation = explanation;
        this.updated();
    }

    public TReturnStatus clone() {
        try {
            return new TReturnStatus(this);
        }
        catch (InvalidTReturnStatusAttributeException e) {
            throw new IllegalStateException("unexpected InvalidTReturnStatusAttributeException in TReturnStatus: " + e.getMessage());
        }
    }

    public static TReturnStatus getInitialValue() {
        TReturnStatus result = null;
        try {
            result = new TReturnStatus(TStatusCode.SRM_CUSTOM_STATUS, "Initial status..");
        }
        catch (InvalidTReturnStatusAttributeException invalidTReturnStatusAttributeException) {
            // empty catch block
        }
        return result;
    }

    public TStatusCode getStatusCode() {
        return this.statusCode;
    }

    protected void setStatusCode(TStatusCode statusCode) {
        if (statusCode == null) {
            throw new IllegalArgumentException("Cannot set the status code, received null argument: statusCode=" + (Object)((Object)statusCode));
        }
        this.statusCode = statusCode;
        this.updated();
    }

    protected void setExplanation(String explanationString) {
        this.explanation = explanationString == null ? "" : explanationString;
        this.updated();
    }

    public String getExplanation() {
        return this.explanation;
    }

    public Long getLastUpdateTIme() {
        return this.lastUpdateTIme;
    }

    private void updated() {
        this.lastUpdateTIme = Calendar.getInstance().getTimeInMillis();
    }

    public void encode(Map outputParam, String name) {
        HashMap<String, String> globalStatus = new HashMap<String, String>();
        globalStatus.put("statusCode", this.getStatusCode().getValue());
        globalStatus.put("explanation", this.getExplanation());
        outputParam.put(name, globalStatus);
    }

    public String toString() {
        return (Object)((Object)this.statusCode) + ": " + this.explanation;
    }

    public boolean isSRM_SUCCESS() {
        return this.statusCode.equals((Object)TStatusCode.SRM_SUCCESS);
    }

    public void extendExplaination(String string) {
        this.explanation = this.explanation + " [ " + string + " ]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.explanation == null ? 0 : this.explanation.hashCode());
        result = 31 * result + (this.lastUpdateTIme == null ? 0 : this.lastUpdateTIme.hashCode());
        result = 31 * result + (this.statusCode == null ? 0 : this.statusCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TReturnStatus other = (TReturnStatus)obj;
        if (this.explanation == null ? other.explanation != null : !this.explanation.equals(other.explanation)) {
            return false;
        }
        if (this.lastUpdateTIme == null ? other.lastUpdateTIme != null : !this.lastUpdateTIme.equals(other.lastUpdateTIme)) {
            return false;
        }
        return this.statusCode == other.statusCode;
    }
}

