/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.config.Configuration;
import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class TRequestToken
implements Serializable {
    private static final long serialVersionUID = -6926632390881024529L;
    public static final String PNAME_REQUESTOKEN = "requestToken";
    private final String token;
    private final Calendar expiration;
    private static final long REQUEST_LIFETIME = Configuration.getInstance().getExpiredRequestTime() * 1000L;

    public TRequestToken(String requestToken, Date timestamp) throws InvalidTRequestTokenAttributesException {
        if (requestToken == null || requestToken.trim().isEmpty()) {
            throw new InvalidTRequestTokenAttributesException(requestToken);
        }
        this.token = requestToken;
        Calendar expiration = null;
        if (timestamp != null) {
            expiration = Calendar.getInstance();
            expiration.setTimeInMillis(timestamp.getTime() + REQUEST_LIFETIME);
        }
        this.expiration = expiration;
    }

    public static TRequestToken getRandom() {
        UUID token = UUID.randomUUID();
        try {
            return new TRequestToken(token.toString(), Calendar.getInstance().getTime());
        }
        catch (InvalidTRequestTokenAttributesException e) {
            throw new IllegalStateException("Unexpected InvalidTRequestTokenAttributesException", e);
        }
    }

    public boolean hasExpirationDate() {
        return this.expiration != null;
    }

    public boolean isExpired() throws IllegalStateException {
        if (!this.hasExpirationDate()) {
            throw new IllegalStateException("Unable to check expiration, the token han not an expiration date");
        }
        return this.expiration.before(Calendar.getInstance());
    }

    public Calendar getExpiration() {
        return this.expiration;
    }

    public void updateExpiration(Date expiration) {
        this.expiration.setTime(expiration);
    }

    public String getValue() {
        return this.token;
    }

    public String toString() {
        return this.token;
    }

    public static TRequestToken decode(Map<String, Object> inputParam, String fieldName) throws InvalidTRequestTokenAttributesException {
        return new TRequestToken((String)inputParam.get(fieldName), null);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.token == null ? 0 : this.token.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TRequestToken other = (TRequestToken)obj;
        return !(this.token == null ? other.token != null : !this.token.equals(other.token));
    }
}

