/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.filesystem.FilesystemPermission;
import java.util.Map;

public class TPermissionMode {
    public static String PNAME_OTHERPERMISSION = "otherPermission";
    public static String PNAME_MODE = "mode";
    private String mode = null;
    public static final TPermissionMode NONE = new TPermissionMode("None");
    public static final TPermissionMode X = new TPermissionMode("X");
    public static final TPermissionMode W = new TPermissionMode("W");
    public static final TPermissionMode WX = new TPermissionMode("WX");
    public static final TPermissionMode R = new TPermissionMode("R");
    public static final TPermissionMode RX = new TPermissionMode("RX");
    public static final TPermissionMode RW = new TPermissionMode("RW");
    public static final TPermissionMode RWX = new TPermissionMode("RWX");

    private TPermissionMode(String mode) {
        this.mode = mode;
    }

    public String toString() {
        return this.mode;
    }

    public String getValue() {
        return this.mode;
    }

    public static TPermissionMode getTPermissionMode(String type) {
        if (type.equals(NONE.getValue())) {
            return NONE;
        }
        if (type.equals(X.getValue())) {
            return X;
        }
        if (type.equals(W.getValue())) {
            return W;
        }
        if (type.equals(WX.getValue())) {
            return WX;
        }
        if (type.equals(R.getValue())) {
            return R;
        }
        if (type.equals(RX.getValue())) {
            return RX;
        }
        if (type.equals(RW.getValue())) {
            return RW;
        }
        if (type.equals(RWX.getValue())) {
            return RWX;
        }
        return null;
    }

    public static TPermissionMode getTPermissionMode(int type) {
        switch (type) {
            case 0: {
                return NONE;
            }
            case 1: {
                return X;
            }
            case 2: {
                return W;
            }
            case 3: {
                return WX;
            }
            case 4: {
                return R;
            }
            case 5: {
                return RX;
            }
            case 6: {
                return RW;
            }
            case 7: {
                return RWX;
            }
        }
        return NONE;
    }

    public static TPermissionMode getTPermissionMode(FilesystemPermission type) {
        String perm = "";
        if (type.canReadFile() || type.canListDirectory()) {
            perm = perm + "R";
        }
        if (type.canWriteFile()) {
            perm = perm + "W";
        }
        if (type.canTraverseDirectory()) {
            perm = perm + "X";
        }
        if (perm.length() == 0) {
            perm = "None";
        }
        return TPermissionMode.getTPermissionMode(perm);
    }

    public void encode(Map param, String name) {
        Integer permissionInt = null;
        if (this.equals(NONE)) {
            permissionInt = new Integer(0);
        }
        if (this.equals(X)) {
            permissionInt = new Integer(1);
        }
        if (this.equals(W)) {
            permissionInt = new Integer(2);
        }
        if (this.equals(WX)) {
            permissionInt = new Integer(3);
        }
        if (this.equals(R)) {
            permissionInt = new Integer(4);
        }
        if (this.equals(RX)) {
            permissionInt = new Integer(5);
        }
        if (this.equals(RW)) {
            permissionInt = new Integer(6);
        }
        if (this.equals(RWX)) {
            permissionInt = new Integer(7);
        }
        param.put(name, permissionInt);
    }
}

