/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.common.types.TimeUnit;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class TLifeTimeInSeconds
implements Serializable {
    private long time = -1L;
    private TimeUnit u = TimeUnit.EMPTY;
    private boolean empty = true;
    private static TLifeTimeInSeconds emptyTime = null;
    private boolean infinite = false;
    private static TLifeTimeInSeconds infiniteTime = null;
    public static String PNAME_LIFETIMEASSIGNED = "lifetimeAssigned";
    public static String PNAME_LIFETIMELEFT = "lifetimeLeft";
    public static String PNAME_DESIREDLIFETIMEOFRESERVEDSPACE = "desiredLifetimeOfReservedSpace";
    public static String PNAME_LIFETIMEOFRESERVEDSPACE = "lifetimeOfReservedSpace";
    public static String PNAME_FILELIFETIME = "fileLifetime";
    public static String PNAME_PINLIFETIME = "pinLifetime";

    private TLifeTimeInSeconds(long time, TimeUnit u, boolean empty, boolean infinite) {
        this.time = time;
        this.u = u;
        this.empty = empty;
        this.infinite = infinite;
    }

    public static TLifeTimeInSeconds make(long time, TimeUnit unit) throws IllegalArgumentException {
        if (unit == null) {
            throw new IllegalArgumentException("Unable to create the object, illegal arguments: time=" + time + " unit=" + unit);
        }
        if (time < 0L) {
            return TLifeTimeInSeconds.makeInfinite();
        }
        return new TLifeTimeInSeconds(time, unit, false, false);
    }

    public static TLifeTimeInSeconds makeEmpty() {
        if (emptyTime == null) {
            emptyTime = new TLifeTimeInSeconds(0L, TimeUnit.EMPTY, true, false);
        }
        return emptyTime;
    }

    public static TLifeTimeInSeconds makeInfinite() {
        if (infiniteTime == null) {
            infiniteTime = new TLifeTimeInSeconds(-1L, TimeUnit.EMPTY, false, true);
        }
        return infiniteTime;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isInfinite() {
        return this.infinite;
    }

    public long value() {
        return this.time;
    }

    public TimeUnit unit() {
        return this.u;
    }

    public double getTimeIn(TimeUnit u) {
        if (!this.empty && !this.infinite && u != null) {
            Long l_time = new Long(this.time);
            double result = l_time.doubleValue() * (this.u.conversionFactor() / u.conversionFactor());
            return result;
        }
        return -1.0;
    }

    public TLifeTimeInSeconds timeLeft(long startTimeInSeconds) {
        if (this.empty) {
            return emptyTime;
        }
        long secondsLeft = this.time + startTimeInSeconds;
        Date currentDate = new Date();
        long currentTime = currentDate.getTime();
        if ((secondsLeft -= (currentTime /= 1000L)) < 0L) {
            secondsLeft = 0L;
        }
        TLifeTimeInSeconds timeLeft = null;
        try {
            timeLeft = TLifeTimeInSeconds.make(secondsLeft, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            timeLeft = TLifeTimeInSeconds.makeEmpty();
        }
        return timeLeft;
    }

    public TLifeTimeInSeconds timeLeft(Date startingDate) {
        if (this.empty || startingDate == null) {
            return emptyTime;
        }
        long startTimeInSeconds = startingDate.getTime() / 1000L;
        return this.timeLeft(startTimeInSeconds);
    }

    public static TLifeTimeInSeconds decode(Map inputParam, String fieldName) {
        String lifetime = (String)inputParam.get(fieldName);
        if (lifetime == null) {
            return TLifeTimeInSeconds.makeEmpty();
        }
        long lifetimeLong = Long.parseLong(lifetime);
        try {
            return TLifeTimeInSeconds.make(lifetimeLong, TimeUnit.SECONDS);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            return TLifeTimeInSeconds.makeEmpty();
        }
    }

    public void encode(Map param, String name) {
        if (this.empty) {
            return;
        }
        String lifetimeString = String.valueOf(this.time);
        param.put(name, lifetimeString);
    }

    public String toString() {
        if (this.empty) {
            return "Empty TLifeTimeInSeconds!";
        }
        if (this.infinite) {
            return "Infinite TLifeTimeInSeconds";
        }
        return "" + this.time + " " + this.u;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TLifeTimeInSeconds)) {
            return false;
        }
        TLifeTimeInSeconds et = (TLifeTimeInSeconds)o;
        if (this.empty && et.empty) {
            return true;
        }
        if (this.infinite && et.infinite) {
            return true;
        }
        return this.time == et.time && this.u == et.u && this.empty == et.empty;
    }

    public int hashCode() {
        if (this.empty) {
            return -1;
        }
        if (this.infinite) {
            return -2;
        }
        int hash = 17;
        hash = 37 * hash + new Long(this.time).hashCode();
        hash = 37 * hash + this.u.hashCode();
        return hash;
    }
}

