/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import java.util.Map;

public class TFileStorageType {
    private String fileType = null;
    public static final String PNAME_FILESTORAGETYPE = "fileStorageType";
    public static final TFileStorageType VOLATILE = new TFileStorageType("Volatile");
    public static final TFileStorageType DURABLE = new TFileStorageType("Durable");
    public static final TFileStorageType PERMANENT = new TFileStorageType("Permanent");
    public static final TFileStorageType EMPTY = new TFileStorageType("Empty");

    private TFileStorageType(String fileType) {
        this.fileType = fileType;
    }

    public String toString() {
        return this.fileType;
    }

    public String getValue() {
        return this.fileType;
    }

    public static TFileStorageType getTFileStorageType(String type) {
        if (type.toLowerCase().trim().equals(VOLATILE.getValue().toLowerCase())) {
            return VOLATILE;
        }
        if (type.toLowerCase().trim().equals(PERMANENT.getValue().toLowerCase())) {
            return PERMANENT;
        }
        if (type.toLowerCase().trim().equals(DURABLE.getValue().toLowerCase())) {
            return DURABLE;
        }
        return EMPTY;
    }

    public static TFileStorageType getTFileStorageType(int type) {
        switch (type) {
            case 0: {
                return VOLATILE;
            }
            case 1: {
                return DURABLE;
            }
            case 2: {
                return PERMANENT;
            }
        }
        return EMPTY;
    }

    public static TFileStorageType decode(Map inputParam, String name) {
        Integer fileType = (Integer)inputParam.get(name);
        if (fileType != null) {
            return TFileStorageType.getTFileStorageType(fileType);
        }
        return EMPTY;
    }

    public void encode(Map param, String name) {
        Integer value = null;
        if (this.equals(VOLATILE)) {
            value = new Integer(0);
        }
        if (this.equals(DURABLE)) {
            value = new Integer(1);
        }
        if (this.equals(PERMANENT)) {
            value = new Integer(2);
        }
        param.put(name, value);
    }
}

