/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.srm.types;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArrayOfTSizeInBytes
implements Serializable {
    private static final long serialVersionUID = -1987674620390240434L;
    public static final String PNAME_arrayOfExpectedFileSizes = "arrayOfExpectedFileSizes";
    private ArrayList sizeInBytesList = new ArrayList();

    public static ArrayOfTSizeInBytes decode(Map inputParam, String fieldName) {
        List<Object> inputList = null;
        try {
            inputList = Arrays.asList((Object[])inputParam.get(fieldName));
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (inputList == null) {
            return null;
        }
        ArrayOfTSizeInBytes list = new ArrayOfTSizeInBytes();
        for (int i = 0; i < inputList.size(); ++i) {
            TSizeInBytes size = null;
            String strLong = (String)inputList.get(i);
            try {
                size = TSizeInBytes.make(Long.parseLong(strLong), SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException e) {
                return null;
            }
            list.addTSizeInBytes(size);
        }
        return list;
    }

    public Object[] getArray() {
        return this.sizeInBytesList.toArray();
    }

    public TSizeInBytes getTSizeInBytes(int i) {
        return (TSizeInBytes)this.sizeInBytesList.get(i);
    }

    public void setTSizeInBytes(int index, TSizeInBytes size) {
        this.sizeInBytesList.set(index, size);
    }

    public void addTSizeInBytes(TSizeInBytes size) {
        this.sizeInBytesList.add(size);
    }

    public int size() {
        return this.sizeInBytesList.size();
    }
}

