/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.sensor;

import java.io.File;

public class TrivialDU {
    private static String path;
    private static long nrFiles;
    private static long nrNodes;
    private static long size;
    private static int maxDepth;
    private static int maxBreadth;
    private static long leaves;

    public static void visitAllFiles(File dir, int depth) {
        if (depth > maxDepth) {
            maxDepth = depth;
        }
        if (dir.isDirectory()) {
            ++nrNodes;
            String[] children = dir.list();
            if (children != null) {
                int breadth = children.length;
                if (breadth > maxBreadth) {
                    maxBreadth = breadth;
                }
                for (int i = 0; i < children.length; ++i) {
                    TrivialDU.visitAllFiles(new File(dir, children[i]), depth + 1);
                }
            } else {
                ++leaves;
            }
        } else {
            TrivialDU.process(dir);
        }
    }

    private static void process(File dir) {
        size += dir.length();
        ++nrFiles;
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            path = System.getProperty("user.dir");
            System.out.println("path  : " + path);
        } else {
            path = args[0];
        }
        TrivialDU.visitAllFiles(new File(path), 0);
        System.out.println("path     : " + path);
        System.out.println(" - nrFiles    : " + nrFiles);
        System.out.println(" - nrNodes    : " + nrNodes);
        System.out.println(" - size       : " + size);
        System.out.println(" - maxDepth   : " + maxDepth);
        System.out.println(" - maxBreadth : " + maxDepth);
        System.out.println(" - leaves     : " + leaves);
    }

    static {
        nrFiles = 0L;
        nrNodes = 0L;
        size = 0L;
        maxDepth = -1;
        maxBreadth = -1;
        leaves = 0L;
    }
}

