/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.sensor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecCommand {
    private static final Logger log = LoggerFactory.getLogger(ExecCommand.class);
    private Semaphore outputSem;
    private String output;
    private Semaphore errorSem;
    private String error;
    private Process p;

    public ExecCommand(String command, String input) {
        try {
            this.p = Runtime.getRuntime().exec(this.makeArray(command));
            new InputWriter(input).start();
            new OutputReader().start();
            new ErrorReader().start();
            this.p.waitFor();
        }
        catch (IOException e) {
            log.warn("IO Exception occours during the execution of a native command " + command + ". " + e.getMessage());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted Exception occours during the execution of a native command " + command + ". " + e.getMessage());
        }
    }

    public ExecCommand(String command) {
        try {
            this.p = Runtime.getRuntime().exec(this.makeArray(command));
            new OutputReader().start();
            new ErrorReader().start();
            this.p.waitFor();
        }
        catch (IOException e) {
            log.warn("IO Exception occours during the execution of a native command " + command + ". " + e.getMessage());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted Exception occours during the execution of a native command " + command + ". " + e.getMessage());
        }
    }

    public String getOutput() {
        try {
            this.outputSem.acquire();
        }
        catch (InterruptedException e) {
            log.warn("Interrupt occours when acquiring Semaphore the execution on a native command. " + e.getMessage());
        }
        String value = this.output;
        this.outputSem.release();
        return value;
    }

    public String getError() {
        try {
            this.errorSem.acquire();
        }
        catch (InterruptedException e) {
            log.warn("Interrupt occours when acquiring Semaphore the execution on a native command. " + e.getMessage());
        }
        String value = this.error;
        this.errorSem.release();
        return value;
    }

    private String[] makeArray(String command) {
        ArrayList<String> commandArray = new ArrayList<String>();
        String buff = "";
        boolean lookForEnd = false;
        for (int i = 0; i < command.length(); ++i) {
            if (lookForEnd) {
                if (command.charAt(i) == '\"') {
                    if (buff.length() > 0) {
                        commandArray.add(buff);
                    }
                    buff = "";
                    lookForEnd = false;
                    continue;
                }
                buff = buff + command.charAt(i);
                continue;
            }
            if (command.charAt(i) == '\"') {
                lookForEnd = true;
                continue;
            }
            if (command.charAt(i) == ' ') {
                if (buff.length() > 0) {
                    commandArray.add(buff);
                }
                buff = "";
                continue;
            }
            buff = buff + command.charAt(i);
        }
        if (buff.length() > 0) {
            commandArray.add(buff);
        }
        String[] array = new String[commandArray.size()];
        for (int i = 0; i < commandArray.size(); ++i) {
            array[i] = (String)commandArray.get(i);
        }
        return array;
    }

    private class ErrorReader
    extends Thread {
        public ErrorReader() {
            try {
                ExecCommand.this.errorSem = new Semaphore(1);
                ExecCommand.this.errorSem.acquire();
            }
            catch (InterruptedException e) {
                log.warn("Interrupt occours when retrieve ERROR output form the execution on a native command. " + e.getMessage());
            }
        }

        @Override
        public void run() {
            try {
                StringBuffer readBuffer = new StringBuffer();
                BufferedReader isr = new BufferedReader(new InputStreamReader(ExecCommand.this.p.getErrorStream()));
                String buff = new String();
                while ((buff = isr.readLine()) != null) {
                    readBuffer.append(buff);
                }
                ExecCommand.this.error = readBuffer.toString();
                ExecCommand.this.errorSem.release();
            }
            catch (IOException e) {
                log.warn("IO Exception occours when retrieve ERROR output form the execution on a native command. " + e.getMessage());
            }
            if (ExecCommand.this.error.length() > 0) {
                log.warn("Error returned by native command: " + ExecCommand.this.error);
            }
        }
    }

    private class OutputReader
    extends Thread {
        public OutputReader() {
            try {
                ExecCommand.this.outputSem = new Semaphore(1);
                ExecCommand.this.outputSem.acquire();
            }
            catch (InterruptedException e) {
                log.warn("Interrupt occours when retrieve output form the execution on a native command. " + e.getMessage());
            }
        }

        @Override
        public void run() {
            try {
                StringBuffer readBuffer = new StringBuffer();
                BufferedReader isr = new BufferedReader(new InputStreamReader(ExecCommand.this.p.getInputStream()));
                String buff = new String();
                while ((buff = isr.readLine()) != null) {
                    readBuffer.append(buff);
                    System.out.println(buff);
                }
                ExecCommand.this.output = readBuffer.toString();
                ExecCommand.this.outputSem.release();
            }
            catch (IOException e) {
                log.warn("IO Exception occours when retrieve output form the execution on a native command. " + e.getMessage());
            }
        }
    }

    private class InputWriter
    extends Thread {
        private String input;

        public InputWriter(String input) {
            this.input = input;
        }

        @Override
        public void run() {
            PrintWriter pw = new PrintWriter(ExecCommand.this.p.getOutputStream());
            pw.println(this.input);
            pw.flush();
        }
    }
}

