/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.quota;

import it.grid.storm.catalogs.ReservedSpaceCatalog;
import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.info.SpaceInfoManager;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.space.StorageSpaceData;
import it.grid.storm.space.quota.BackgroundGPFSQuota;
import it.grid.storm.space.quota.GPFSLsQuotaCommand;
import it.grid.storm.space.quota.GPFSQuotaCommandResult;
import it.grid.storm.space.quota.GPFSQuotaInfo;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaManager {
    private static final Logger log = LoggerFactory.getLogger(QuotaManager.class);
    private static QuotaManager instance = new QuotaManager();
    private int howmanyQuotas;

    private QuotaManager() {
    }

    public static QuotaManager getInstance() {
        return instance;
    }

    public int updateSAwithQuotaResult(GPFSQuotaCommandResult quotaResult) {
        int nrFailures = 0;
        if (quotaResult != null) {
            List<String> quotaNames = SpaceInfoManager.getInstance().retrieveQuotaNamesToUse();
            log.debug("QuotaNames: {} ", quotaNames);
            List<VirtualFSInterface> vfsQuotas = SpaceInfoManager.getInstance().retrieveSAtoInitializeWithQuota();
            log.debug("vfs Quotas (size) : " + (vfsQuotas != null ? vfsQuotas.size() : 0));
            ArrayList<VirtualFSInterface> vfsQuotaEnabled = new ArrayList<VirtualFSInterface>();
            for (GPFSQuotaInfo gpfsQuotaInfoEntry : quotaResult.getQuotaResults()) {
                if (gpfsQuotaInfoEntry.isFailure()) {
                    ++nrFailures;
                    continue;
                }
                String qName = gpfsQuotaInfoEntry.getQuotaEntryName();
                log.debug(".. evaluating QuotaEntryName : '" + qName + "'");
                if (quotaNames.contains(qName)) {
                    StorageSpaceData ssd;
                    VirtualFSInterface vfsItem = this.retrieveCorrespondingVFS(vfsQuotas, qName);
                    if (vfsItem != null) {
                        vfsQuotaEnabled.add(vfsItem);
                    }
                    if ((ssd = SpaceInfoManager.getInstance().getSSDfromQuotaName(qName)) != null) {
                        this.process(gpfsQuotaInfoEntry, ssd);
                        continue;
                    }
                    log.error("Retrieved null StorageSpaceData. Unable to update the database");
                    ++nrFailures;
                    continue;
                }
                log.error("Found '" + qName + "' quota Name not corresponding to a Storage Area.");
                ++nrFailures;
            }
            log.debug("vfs Enabled Quotas : " + (vfsQuotaEnabled != null ? vfsQuotaEnabled.size() : 0));
            this.setHowmanyQuotas(vfsQuotaEnabled.size());
        }
        return nrFailures;
    }

    public void updateSAwithQuotaAsynch(boolean test) {
        boolean accepted = BackgroundGPFSQuota.getInstance().submitGPFSQuota();
        if (accepted) {
            log.debug("Asynchronous GPFS Quota execution is started");
        } else {
            log.debug("Asynchronous GPFS Quota execution is NOT started because too early..");
        }
    }

    public int updateSAwithQuotaSynch(boolean test) {
        GPFSLsQuotaCommand quotaCmd = new GPFSLsQuotaCommand();
        GPFSQuotaCommandResult quotaResult = quotaCmd.executeGetQuotaInfo(test);
        int nrFailures = this.updateSAwithQuotaResult(quotaResult);
        return nrFailures;
    }

    private VirtualFSInterface retrieveCorrespondingVFS(List<VirtualFSInterface> vfsQuotas, String dName) {
        VirtualFSInterface result = null;
        for (VirtualFSInterface vfsItem : vfsQuotas) {
            if (!vfsItem.getCapabilities().getQuota().getQuotaElementName().equals(dName)) continue;
            result = vfsItem;
        }
        return result;
    }

    private void process(GPFSQuotaInfo gpfsQuotaInfoEntry, StorageSpaceData ssd) {
        long usedSize = gpfsQuotaInfoEntry.getCurrentBlocksUsage();
        log.debug("Used size for '" + gpfsQuotaInfoEntry.getQuotaEntryName() + "' is " + usedSize + " KB.");
        try {
            TSizeInBytes us = TSizeInBytes.make(usedSize *= 1024L, SizeUnit.BYTES);
            ssd.setUsedSpaceSize(us);
        }
        catch (InvalidTSizeAttributesException e) {
            log.error("Negative size?");
        }
        log.debug("Saving updated Used Size into DB ... ");
        ReservedSpaceCatalog spaceCatalog = new ReservedSpaceCatalog();
        spaceCatalog.updateStorageSpace(ssd);
        log.debug("... saved. ");
    }

    public void setHowmanyQuotas(int howmanyQuotas) {
        this.howmanyQuotas = howmanyQuotas;
    }

    public int getHowmanyQuotas() {
        return this.howmanyQuotas;
    }
}

