/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.quota;

import it.grid.storm.info.SpaceInfoManager;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.Quota;
import it.grid.storm.namespace.model.QuotaType;
import it.grid.storm.space.ExecCommand;
import it.grid.storm.space.ExitCode;
import it.grid.storm.space.quota.GPFSQuotaCommand;
import it.grid.storm.space.quota.GPFSQuotaCommandResult;
import it.grid.storm.space.quota.GPFSQuotaInfo;
import it.grid.storm.space.quota.MockGPFSQuotaResult;
import it.grid.storm.space.quota.QuotaException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPFSLsQuotaCommand
extends GPFSQuotaCommand {
    private static final Logger log = LoggerFactory.getLogger(GPFSLsQuotaCommand.class);
    private static String pathSep = File.separator;
    private static String gpfsCommandPath = pathSep + "usr" + pathSep + "lpp" + pathSep + "mmfs" + pathSep + "bin";
    private static String gpfsCommand = gpfsCommandPath + pathSep + "mmlsquota";
    static final long DEFAULT_TIMEOUT = 10L;

    public GPFSLsQuotaCommand(long timeout) {
        super(timeout);
    }

    public GPFSLsQuotaCommand() {
        super(10L);
    }

    @Override
    public String getQuotaCommandString() {
        return gpfsCommand;
    }

    @Override
    public GPFSQuotaCommandResult executeGetQuotaInfo(Quota quotaElement, boolean test) throws QuotaException {
        ExitCode cmdExitCode;
        GPFSQuotaCommandResult cmdResult = new GPFSQuotaCommandResult();
        GPFSQuotaInfo result = new GPFSQuotaInfo();
        String command = this.getQuotaCommandString();
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(command);
        commandList.addAll(this.retrieveOptions(quotaElement));
        ExecCommand ec = new ExecCommand(commandList, this.timeout);
        String output = null;
        if (test) {
            cmdExitCode = ExitCode.SUCCESS;
            log.debug("[TEST-MODE] Command result: " + (Object)((Object)cmdExitCode));
            output = MockGPFSQuotaResult.getMockOutputLs();
            log.debug("[TEST-MODE] Output: '" + output + "'");
        } else {
            cmdExitCode = ExitCode.getExitCode(ec.runCommand());
            log.debug("Command result: " + (Object)((Object)cmdExitCode));
            output = ec.getOutput();
            log.debug(" Output: '" + output + "'");
        }
        if (cmdExitCode.equals((Object)ExitCode.SUCCESS)) {
            result = this.manageSuccess(output, quotaElement);
            if (!result.isInitializated()) {
                cmdExitCode = ExitCode.EMPTY_OUTPUT;
                log.info("Command result: " + (Object)((Object)cmdExitCode));
                result.setFailure(true);
            }
        } else {
            log.warn("Failed to use MMLSQUOTA! on device: '" + quotaElement.getDevice() + "' and element: '" + quotaElement.getQuotaElementName() + "'");
            result.setFailure(true);
        }
        if (result.isFailure()) {
            log.warn("Quota execution returned nothing usefull. (" + quotaElement.getDevice() + ":" + quotaElement.getQuotaElementName() + ")  Check QUOTA on GPFS! ");
        }
        ec.stopExecution();
        cmdResult.addQuotaResult(result);
        cmdResult.setCmdResult(cmdExitCode);
        cmdResult.endOfExecution();
        return cmdResult;
    }

    @Override
    public GPFSQuotaCommandResult executeGetQuotaInfo(boolean test) {
        GPFSQuotaCommandResult returnValue = new GPFSQuotaCommandResult();
        ArrayList<GPFSQuotaInfo> result = new ArrayList<GPFSQuotaInfo>();
        List<VirtualFSInterface> vfsS = SpaceInfoManager.getInstance().retrieveSAtoInitializeWithQuota();
        for (VirtualFSInterface vfs : vfsS) {
            CapabilityInterface cap = vfs.getCapabilities();
            if (cap != null) {
                GPFSQuotaCommandResult quotaResult;
                Quota quotaElement = cap.getQuota();
                try {
                    quotaResult = this.executeGetQuotaInfo(quotaElement, test);
                }
                catch (QuotaException qe) {
                    log.warn("Something was wrong in mmlsquota execution: " + qe);
                    quotaResult = new GPFSQuotaCommandResult();
                    quotaResult.setCmdResult(ExitCode.UNDEFINED);
                }
                GPFSQuotaInfo qInfo = new GPFSQuotaInfo();
                qInfo = quotaResult.getQuotaResults().get(0);
                result.add(qInfo);
                continue;
            }
            log.warn("Capability of VFS: " + vfs.getAliasName() + " is null?!");
        }
        returnValue.setQuotaInfos(result);
        returnValue.endOfExecution();
        return returnValue;
    }

    private ArrayList<String> retrieveOptions(Quota quotaElement) {
        ArrayList<String> options = new ArrayList<String>();
        String quotaNameParam = null;
        int quotaT = quotaElement.getQuotaType().getOrdinalNumber();
        switch (quotaT) {
            case 0: {
                quotaNameParam = "-j " + quotaElement.getQuotaElementName();
                break;
            }
            case 1: {
                quotaNameParam = "-u " + quotaElement.getQuotaElementName();
                break;
            }
            case 2: {
                quotaNameParam = "-g " + quotaElement.getQuotaElementName();
                break;
            }
            default: {
                throw new QuotaException("Unable to execute a quota command because Quota Type '" + QuotaType.string(quotaT) + "' is not supported");
            }
        }
        options.add(quotaNameParam);
        String device = quotaElement.getDevice();
        options.add(device);
        return options;
    }

    private GPFSQuotaInfo manageSuccess(String output, Quota quotaElement) {
        GPFSQuotaInfo qInfo = new GPFSQuotaInfo();
        if (output != null) {
            String eol = System.getProperty("line.separator");
            String[] outputArray = output.split(eol);
            log.debug(" Output lines: " + outputArray.length);
            for (int i = 0; i < outputArray.length; ++i) {
                log.trace("outputArray[" + i + "]=" + outputArray[i]);
            }
            if (outputArray.length <= 1) {
                int remarkIndex = output.indexOf("Remarks");
                log.debug("Splittin 1 line into more lines.. Remark-index:" + remarkIndex);
                if (remarkIndex > 0 && output.length() > 7) {
                    output = output.substring(remarkIndex + 7);
                }
                outputArray = output.split(eol);
                log.debug("new output: " + output);
            }
            List<String> outputList = this.parseOutputLines(outputArray);
            boolean meaningfullFound = false;
            for (String line : outputList) {
                if (GPFSQuotaInfo.meaningfullLineForLS(line)) {
                    log.debug("MMLSQUOTA - line: '" + line + "' is meaningfull!");
                    qInfo.buildLs(line, quotaElement);
                    meaningfullFound = true;
                    continue;
                }
                log.trace("MMLSQUOTA - line: '" + line + "' doesn't contain any usefull info.");
            }
            if (!meaningfullFound) {
                qInfo.setFailure(true);
            }
        }
        return qInfo;
    }

    private List<String> parseOutputLines(String[] outputArray) {
        ArrayList<String> result = new ArrayList<String>();
        if (outputArray != null) {
            for (int i = 0; i < outputArray.length; ++i) {
                String line = outputArray[i];
                result.add(line);
            }
        }
        return result;
    }

    public String toString() {
        return this.getQuotaCommandString();
    }
}

