/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space.quota;

import it.grid.storm.concurrency.NamedThreadFactory;
import it.grid.storm.concurrency.TimingThreadPool;
import it.grid.storm.config.Configuration;
import it.grid.storm.space.quota.CallableGPFSQuota;
import it.grid.storm.space.quota.GPFSQuotaCommandResult;
import it.grid.storm.space.quota.QuotaManager;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackgroundGPFSQuota {
    private static final Logger LOG = LoggerFactory.getLogger(BackgroundGPFSQuota.class);
    private static BackgroundGPFSQuota instance = new BackgroundGPFSQuota();
    private long lastExecutionTime = -1L;
    private long creationTime = -1L;
    private static final long RELAX_PERIOD = 15000L;
    private static final long WAIT_TIMEOUT_DURATION = 10000L;
    private int poolSize = 2;
    private int maxPoolSize = 2;
    private long keepAliveTime = 10L;
    private final BlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
    private final ExecutorService exec = new TimingThreadPool(this.poolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, this.workQueue, new NamedThreadFactory("GPFSQuotaExecutors"));
    private final CompletionService<GPFSQuotaCommandResult> completionService = new ExecutorCompletionService<GPFSQuotaCommandResult>(this.exec);
    private ExecutorService singleExec = Executors.newFixedThreadPool(1, new NamedThreadFactory("CompletionTask"));

    private BackgroundGPFSQuota() {
        int waitRefreshPeriod = Configuration.getInstance().getGPFSQuotaRefreshPeriod();
        RefreshQuota refreshQuota = new RefreshQuota(waitRefreshPeriod);
        refreshQuota.start();
    }

    public static BackgroundGPFSQuota getInstance() {
        return instance;
    }

    public boolean submitGPFSQuota() {
        boolean result = false;
        long currTime = System.currentTimeMillis();
        if (this.lastExecutionTime > 0L && currTime - this.lastExecutionTime < 15000L) {
            long remainngRelaxTime = 15000L - (currTime - this.lastExecutionTime);
            LOG.debug("GPFS Quota Background submission. Refused because relax period is not ended (" + remainngRelaxTime + " ms yet.)");
        } else {
            this.lastExecutionTime = currTime;
            LOG.debug("GPFS Quota Background submission.");
            this.execute();
            result = true;
        }
        return result;
    }

    private void execute() {
        CallableGPFSQuota bgGPFSQuota = new CallableGPFSQuota();
        this.creationTime = bgGPFSQuota.getCreationTime();
        this.completionService.submit(bgGPFSQuota);
        this.singleExec.submit(new CompletionTask());
    }

    private boolean processCompletedTask(GPFSQuotaCommandResult quotaResult) {
        boolean result = false;
        int nrFailires = QuotaManager.getInstance().updateSAwithQuotaResult(quotaResult);
        Date startDate = new Date(quotaResult.getStartTime());
        Date endDate = new Date(quotaResult.getStartTime() + quotaResult.getDurationTime());
        Date creationDate = new Date(this.creationTime);
        LOG.debug("GPFS Quota execution: Submitted [" + creationDate + "], Start [" + startDate + "], End[" + endDate + "], wait.duration = " + (quotaResult.getStartTime() - this.creationTime) + ",exec.duration = " + quotaResult.getDurationTime());
        boolean bl = result = nrFailires == 0;
        if (!result) {
            LOG.debug("GPFS Quota execution is failed.");
        }
        return result;
    }

    public class RefreshQuota {
        int delay = 20000;
        int periodInSeconds;
        Timer timer = new Timer();

        public RefreshQuota(int period) {
            this.periodInSeconds = period;
        }

        public void start() {
            this.timer.scheduleAtFixedRate((TimerTask)new RefreshTask(), this.delay, (long)(this.periodInSeconds * 1000));
        }

        class RefreshTask
        extends TimerTask {
            RefreshTask() {
            }

            @Override
            public void run() {
                LOG.debug("Refresh Quota Timer task is executed");
                BackgroundGPFSQuota.getInstance().submitGPFSQuota();
            }
        }
    }

    private class CompletionTask
    implements Runnable {
        private CompletionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean completeTask() throws InterruptedException {
            LOG.debug("Checking for complete a task..");
            boolean failure = false;
            GPFSQuotaCommandResult quotaResult = null;
            Future completedTask = BackgroundGPFSQuota.this.completionService.take();
            try {
                quotaResult = (GPFSQuotaCommandResult)completedTask.get(10000L, TimeUnit.MILLISECONDS);
                LOG.debug("Completed Task : " + quotaResult.toString());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof InterruptedException)) {
                    LOG.error("Completion Task failed with unhandled exception", cause);
                }
            }
            catch (TimeoutException e) {
                LOG.info("Completion Task terminated due to a TimeOut. Cause: " + e.getCause().getMessage());
            }
            catch (CancellationException e) {
                LOG.info("Completion Task was cancelled. Cause: " + e.getCause().getMessage());
            }
            finally {
                completedTask.cancel(true);
            }
            if (quotaResult != null) {
                BackgroundGPFSQuota.this.processCompletedTask(quotaResult);
            } else {
                LOG.warn("DU completed but unable to manage the result (something wrong was happen).");
                failure = true;
            }
            return failure;
        }

        @Override
        public void run() {
            try {
                while (!Thread.currentThread().isInterrupted()) {
                    this.completeTask();
                }
            }
            catch (InterruptedException ie) {
                LOG.info("CompletionTask has been terminated by an interruption. ");
                Thread.currentThread().interrupt();
            }
        }
    }
}

