/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space;

import it.grid.storm.concurrency.NamedThreadFactory;
import it.grid.storm.concurrency.TimingThreadPool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecCommand {
    private static final Logger LOG = LoggerFactory.getLogger(ExecCommand.class);
    private static final long DEFAULT_TIMEOUT = 10L;
    private long timeout = 0L;
    private final List<String> command;
    private Future<String> outputFuture;
    private Future<String> errorFuture;
    ExecutorService executorService = null;

    public ExecCommand(List<String> commandInformation, long timeout) {
        if (commandInformation == null) {
            throw new NullPointerException("The commandInformation is required.");
        }
        this.command = commandInformation;
        this.timeout = timeout;
    }

    public ExecCommand(List<String> commandInformation) {
        if (commandInformation == null) {
            throw new NullPointerException("The commandInformation is required.");
        }
        this.command = commandInformation;
        this.timeout = -1L;
    }

    public String getCommand() {
        String result = "";
        for (String cmdElement : this.command) {
            result = result + cmdElement + " ";
        }
        return result;
    }

    public int runCommand() {
        int result = 0;
        try {
            ProcessBuilder pb = new ProcessBuilder(this.command);
            Process process = pb.start();
            LOG.debug("Running command: '" + this.command + "'");
            int corePoolSize = 3;
            int maxPoolSize = 3;
            int keepAliveTime = 10;
            LinkedBlockingQueue<Runnable> workQueue = new LinkedBlockingQueue<Runnable>();
            this.executorService = new TimingThreadPool(corePoolSize, maxPoolSize, (long)keepAliveTime, TimeUnit.SECONDS, workQueue, new NamedThreadFactory("ExecCommand"));
            this.outputFuture = this.executorService.submit(new StreamReader(process.getInputStream()));
            this.errorFuture = this.executorService.submit(new StreamReader(process.getErrorStream()));
            final Process finalProcess = process;
            Callable<Integer> call = new Callable<Integer>(){

                @Override
                public Integer call() throws Exception {
                    finalProcess.waitFor();
                    return finalProcess.exitValue();
                }
            };
            Future<Integer> ft = this.executorService.submit(call);
            LOG.debug("START WaitFor the result of Native Command.");
            result = this.timeout > 0L ? ft.get(this.timeout, TimeUnit.SECONDS).intValue() : ft.get(10L, TimeUnit.SECONDS).intValue();
            LOG.debug("END WaitFor the result of Native Command.");
        }
        catch (IOException e) {
            LOG.warn("IO Exception occours during the execution of a native command " + this.command + ". " + e.getMessage());
            result = 1;
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted Exception occours during the execution of a native command " + this.command + ". " + e.getMessage());
            result = 2;
        }
        catch (TimeoutException e) {
            LOG.warn("Native command " + this.command + " was in TimeOut.");
            result = 3;
        }
        catch (NullPointerException npe) {
            LOG.error("The command to execute is NULL! " + npe);
            result = 4;
        }
        catch (SecurityException se) {
            LOG.error("The program have Security limitation to execute the command '" + this.command + "'." + se);
            result = 5;
        }
        catch (IllegalArgumentException iae) {
            LOG.error("The command to execute is EMPTY or ILLEGAL ('" + this.command + "')! " + iae);
            result = 6;
        }
        catch (ExecutionException e) {
            LOG.error("Execution Exception during the execution of '" + this.command + "'! " + e);
            result = 7;
        }
        return result;
    }

    public String getOutput() {
        String outputResult = "";
        try {
            LOG.debug("Get Output message ... ");
            if (this.outputFuture != null) {
                outputResult = this.timeout > 0L ? this.outputFuture.get(this.timeout, TimeUnit.SECONDS) : this.outputFuture.get(10L, TimeUnit.SECONDS);
                LOG.debug(" .. :" + outputResult);
            } else {
                LOG.warn("Unable to get outputResult value. outputResult is NULL");
            }
        }
        catch (ExecutionException e) {
            LOG.warn("ExecutionException occours when retrieving OUTPUT stream returned by native command." + e.getMessage());
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout occours when retrieving OUTPUT stream returned by native command." + e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupt occours when retrieving OUTPUT stream returned by native command." + e.getMessage());
        }
        return outputResult;
    }

    public String getError() {
        String errorResult = "";
        try {
            LOG.debug("Get Error Message .. ");
            errorResult = this.timeout > 0L ? this.errorFuture.get(this.timeout, TimeUnit.SECONDS) : this.outputFuture.get(10L, TimeUnit.SECONDS);
            LOG.debug(" .. :" + errorResult);
        }
        catch (ExecutionException e) {
            LOG.warn("ExecutionException occours when retrieving error stream returned by native command." + e.getMessage());
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout occours when retrieving error stream returned by native command." + e.getMessage());
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupt occours when retrieving error stream returned by native command." + e.getMessage());
        }
        return errorResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExecution() {
        long millisecToWait = 1000L;
        if (this.executorService != null) {
            try {
                LOG.debug("Shutting down..");
                this.executorService.awaitTermination(millisecToWait, TimeUnit.MILLISECONDS);
                LOG.debug("Shutted down!");
            }
            catch (InterruptedException ie) {
                LOG.debug("Interrupted excep. " + ie);
            }
            finally {
                LOG.debug("Tasks killed: " + this.executorService.shutdownNow().size());
            }
        }
    }

    private class StreamReader
    implements Callable<String> {
        private InputStream is;

        public StreamReader(InputStream inputStream) {
            this.is = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String call() {
            String output = "";
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            try {
                String buff;
                StringBuffer readBuffer = new StringBuffer();
                String eol = System.getProperty("line.separator");
                while ((buff = br.readLine()) != null) {
                    readBuffer.append(buff).append(eol);
                    LOG.debug(" - output-reader: " + buff);
                }
                output = readBuffer.toString();
                IOUtils.closeQuietly((Reader)br);
                IOUtils.closeQuietly((Reader)isr);
            }
            catch (IOException e) {
                LOG.warn("IO Exception occours when retrieve output form the execution on a native command. " + e.getMessage());
            }
            finally {
                IOUtils.closeQuietly((Reader)br);
                IOUtils.closeQuietly((Reader)isr);
            }
            return output;
        }
    }
}

