/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.space;

import it.grid.storm.space.DUResult;
import it.grid.storm.space.ExecCommand;
import it.grid.storm.space.ExitCode;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallableDU
implements Callable<DUResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CallableDU.class);
    private String rootPath;
    private long timeout;
    private Date creationTime;
    private Date startTime;
    private Date endTime;
    private ExitCode cmdResult;
    private static final String POISON_PILL = "poison-pill";

    public CallableDU(String rootPath, long timeOutInSeconds) {
        this.rootPath = rootPath;
        this.timeout = timeOutInSeconds * 1000L;
        this.creationTime = new Date(System.currentTimeMillis());
    }

    public static CallableDU getPoisonPill() {
        return new CallableDU(POISON_PILL, 1000L);
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    private String getDULocalCommand() {
        File cf;
        String result = "du";
        if (this.isWindows() && !(cf = new File(result = "C:\\cygwin\\bin\\du.exe")).exists()) {
            LOG.error("Unable to find DU command.");
            result = null;
        }
        return result;
    }

    public final String getRootPath() {
        return this.rootPath;
    }

    public final Date getCreationTime() {
        return this.creationTime;
    }

    public final Date getStartTime() {
        return this.startTime;
    }

    public final Date getEndTime() {
        return this.endTime;
    }

    public final ExitCode getCmdResult() {
        return this.cmdResult;
    }

    @Override
    public DUResult call() throws Exception {
        long size = -1L;
        long startT = System.currentTimeMillis();
        this.startTime = new Date(startT);
        String command = this.getDULocalCommand();
        if (this.getRootPath().equals(POISON_PILL)) {
            DUResult result = new DUResult(0L, POISON_PILL, this.startTime, 0L, ExitCode.POISON_PILL);
            return result;
        }
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(command);
        commandList.add("-s");
        commandList.add("-b");
        commandList.add(this.rootPath);
        ExecCommand ec = new ExecCommand(commandList, this.timeout);
        this.cmdResult = ExitCode.getExitCode(ec.runCommand());
        LOG.debug("Command result: " + (Object)((Object)this.cmdResult));
        String output = ec.getOutput();
        LOG.debug(" Output: '" + output + "'");
        if (output != null) {
            String[] outputArray = output.split("\\s");
            for (int i = 0; i < outputArray.length; ++i) {
                LOG.trace("outputArray[" + i + "]=" + outputArray[i]);
            }
            try {
                size = Long.valueOf(outputArray[0]);
            }
            catch (NumberFormatException nfe) {
                LOG.error("Unable to retrieve the disk usage of '" + this.rootPath + "'. " + nfe.getMessage());
            }
        }
        if (this.cmdResult.equals((Object)ExitCode.IO_ERROR) && size > 0L) {
            this.cmdResult = ExitCode.PARTIAL_SUCCESS;
            LOG.info("IO Error occurred 'du: cannot access '" + this.rootPath + "': No such file or ..' but SUCCESSFully managed.");
        }
        if (this.cmdResult.equals((Object)ExitCode.SUCCESS) && size < 0L) {
            this.cmdResult = ExitCode.IO_ERROR;
            LOG.warn("DU of " + this.rootPath + " successfully ended, but an IO_ERROR occurred retrieving command output.");
        }
        long endT = System.currentTimeMillis();
        long durationT = endT - startT;
        this.endTime = new Date(endT);
        DUResult result = new DUResult(size, this.rootPath, this.startTime, durationT, this.cmdResult);
        ec.stopExecution();
        return result;
    }
}

