/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.scheduler;

import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.scheduler.Task;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerPool {
    private ThreadPoolExecutor workers = null;
    private int workerCorePoolSize = 10;
    private int workerMaxPoolSize = 100;
    private BlockingQueue taskQueue = new ArrayBlockingQueue(100);
    private int queueSize = 100;
    private static final Logger log = LoggerFactory.getLogger(WorkerPool.class);
    private long keepAliveTime = 10000L;
    private TimeUnit unit = TimeUnit.MILLISECONDS;

    public WorkerPool() {
        this.workers = new ThreadPoolExecutor(this.workerCorePoolSize, this.workerMaxPoolSize, this.keepAliveTime, this.unit, this.taskQueue);
    }

    public WorkerPool(int corePoolSize, int maxPoolSize, int queueSize) {
        this.workerCorePoolSize = corePoolSize;
        this.workerMaxPoolSize = maxPoolSize;
        this.queueSize = queueSize;
        this.taskQueue = new ArrayBlockingQueue(queueSize);
        this.workers = new ThreadPoolExecutor(this.workerCorePoolSize, this.workerMaxPoolSize, this.keepAliveTime, this.unit, this.taskQueue);
    }

    public void submit(Task task) throws SchedulerException {
        log.debug("Taskqueue Size:" + this.queueSize);
        log.debug("Taskqueue RemCap:" + this.workers.getQueue().remainingCapacity());
        task.enqueueEvent();
        try {
            log.debug("Submitting task with name = " + task.getName());
            this.workers.execute(task);
        }
        catch (RejectedExecutionException ret) {
            log.error("Task " + task.getName() + "was rejected!", (Throwable)ret);
            throw new SchedulerException(task.getName(), ret);
        }
    }

    public void remove(Task task) throws SchedulerException {
        log.debug("Abort request");
        task.abortEvent();
        log.debug("Aborting request with name : " + task.getName());
        boolean taskFound = false;
        BlockingQueue<Runnable> queue = this.workers.getQueue();
        taskFound = queue.contains(task);
        if (taskFound) {
            this.workers.remove(task);
            this.workers.purge();
        }
    }

    protected int getActualPoolSize() {
        return this.workers.getPoolSize();
    }

    protected int getActiveCount() {
        return this.workers.getActiveCount();
    }

    protected int getLargestPoolSize() {
        return this.workers.getLargestPoolSize();
    }

    protected long getCompletedTaskCount() {
        return this.workers.getCompletedTaskCount();
    }

    protected long getTaskCount() {
        return this.workers.getTaskCount();
    }

    protected int getRemainingCapacity() {
        return this.workers.getQueue().remainingCapacity();
    }
}

