/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.scheduler;

public abstract class Task
implements Runnable,
Comparable {
    private static String UNDEF_TASKNAME = "undefined";
    private long creationTime = System.currentTimeMillis();
    private long enqueueTime = 0L;
    private long startExecutionTime = 0L;
    private long endExecutionTime = 0L;
    private long abortingEventTime = 0L;
    private long suspendingEventTime = 0L;
    protected String taskName = null;

    protected Task() {
        this.taskName = UNDEF_TASKNAME;
        this.creationTime = System.currentTimeMillis();
    }

    protected Task(String name) {
        this.taskName = name;
        if (this.taskName == null) {
            this.taskName = UNDEF_TASKNAME;
        }
        this.creationTime = System.currentTimeMillis();
    }

    public long getStartExecutionTime() {
        return this.startExecutionTime;
    }

    public long howlongBeforeUnqueue() {
        return this.enqueueTime - this.creationTime;
    }

    public long howlongInQueue() {
        return this.startExecutionTime - this.enqueueTime;
    }

    public long howlongInExecution() {
        return this.endExecutionTime - this.startExecutionTime;
    }

    protected void enqueueEvent() {
        this.enqueueTime = System.currentTimeMillis();
    }

    protected void abortEvent() {
        this.abortingEventTime = System.currentTimeMillis();
    }

    protected void suspendEvent() {
        this.suspendingEventTime = System.currentTimeMillis();
    }

    protected void runEvent() {
        this.startExecutionTime = System.currentTimeMillis();
    }

    protected void endEvent() {
        this.endExecutionTime = System.currentTimeMillis();
    }

    protected String getName() {
        return this.taskName;
    }

    @Override
    public abstract void run();

    public abstract int compareTo(Object var1);

    public abstract boolean equals(Object var1);
}

