/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.scheduler;

import it.grid.storm.config.Configuration;
import it.grid.storm.scheduler.CruncherTask;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.Scheduler;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.scheduler.SchedulerStatus;
import it.grid.storm.scheduler.WorkerPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrusherScheduler
implements Scheduler {
    private static int clients = 0;
    private WorkerPool crusherPool = null;
    private static final Logger log = LoggerFactory.getLogger(CrusherScheduler.class);
    private SchedulerStatus[] schedStatus = null;
    private int workerCorePoolSize = Configuration.getInstance().getCorePoolSize();
    private int workerMaxPoolSize = Configuration.getInstance().getMaxPoolSize();
    private int queueSize = Configuration.getInstance().getQueueSize();
    private static CrusherScheduler istance = null;

    private CrusherScheduler() {
        this.schedStatus = new SchedulerStatus[1];
        this.schedStatus[0] = new SchedulerStatus("CrusherScheduler");
        this.crusherPool = new WorkerPool(this.workerCorePoolSize, this.workerMaxPoolSize, this.queueSize);
        this.schedStatus[0].setCorePoolSize(this.workerCorePoolSize);
        this.schedStatus[0].setMaxPoolSize(this.workerMaxPoolSize);
        this.schedStatus[0].setQueueSize(this.queueSize);
    }

    public static CrusherScheduler getInstance() {
        log.debug("Called multi-thread scheduler");
        if (istance == null) {
            istance = new CrusherScheduler();
        }
        return istance;
    }

    @Override
    public void schedule(Delegable cruncherTask) throws SchedulerException {
        log.debug("Scheduling feed " + cruncherTask.getName());
        try {
            CruncherTask task = new CruncherTask(cruncherTask);
            this.crusherPool.submit(task);
            log.debug("Feed task nr. = " + this.crusherPool.getTaskCount());
            log.debug("Scheduled feed " + cruncherTask.getName());
        }
        catch (SchedulerException se) {
            log.error(se.getMessage(), (Throwable)se);
            throw se;
        }
    }

    @Override
    public SchedulerStatus getStatus(int workerPoolType) {
        SchedulerStatus st = null;
        switch (workerPoolType) {
            case 0: {
                this.schedStatus[0].setCompletedTaskCount(this.crusherPool.getCompletedTaskCount());
                this.schedStatus[0].setActiveCount(this.crusherPool.getActiveCount());
                this.schedStatus[0].setLargestPoolSize(this.crusherPool.getLargestPoolSize());
                this.schedStatus[0].setPoolSize(this.crusherPool.getActualPoolSize());
                this.schedStatus[0].setTaskCount(this.crusherPool.getTaskCount());
                this.schedStatus[0].setRemainingCapacity(this.crusherPool.getRemainingCapacity());
                st = this.schedStatus[0];
                break;
            }
            default: {
                st = null;
            }
        }
        return st;
    }

    @Override
    public void abort(Delegable task) throws SchedulerException {
    }

    @Override
    public void suspend(Delegable task) throws SchedulerException {
        throw new SchedulerException("CruscherScheduler", "Suspend request not implemented yet!");
    }
}

