/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.scheduler;

import it.grid.storm.asynch.BoL;
import it.grid.storm.asynch.Copy;
import it.grid.storm.asynch.PtG;
import it.grid.storm.asynch.PtP;
import it.grid.storm.asynch.Request;
import it.grid.storm.asynch.RequestChunk;
import it.grid.storm.health.BookKeeper;
import it.grid.storm.health.HealthDirector;
import it.grid.storm.health.LogEvent;
import it.grid.storm.health.OperationType;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.PersistentRequestChunk;
import it.grid.storm.scheduler.Task;
import java.util.ArrayList;

public class ChunkTask
extends Task {
    private final Delegable todo;
    private final String userDN;
    private final String surl;
    private final String requestToken;
    private final boolean isAsynchTask;
    private final boolean isChunkTask;
    private boolean successResult = false;

    public ChunkTask(Delegable todo) {
        this.todo = todo;
        this.taskName = todo.getName();
        if (todo instanceof Request) {
            this.userDN = ((Request)((Object)todo)).getUserDN();
            this.surl = ((Request)((Object)todo)).getSURL();
            this.requestToken = todo instanceof PersistentRequestChunk ? ((PersistentRequestChunk)((Object)todo)).getRequestToken() : "Empty";
        } else {
            this.userDN = "unknonw";
            this.surl = "unknonw";
            this.requestToken = "unknonw";
        }
        this.isAsynchTask = todo instanceof PersistentRequestChunk;
        this.isChunkTask = todo instanceof RequestChunk;
    }

    public void setResult(boolean result) {
        this.successResult = result;
    }

    @Override
    public int compareTo(Object o) {
        return 0;
    }

    @Override
    public void run() {
        this.runEvent();
        this.todo.doIt();
        this.endEvent();
        this.logExecution();
    }

    @Override
    protected void endEvent() {
        super.endEvent();
        if (this.todo instanceof Request) {
            this.successResult = ((Request)((Object)this.todo)).isResultSuccess();
        }
        if (this.isAsynchTask) {
            ((PersistentRequestChunk)((Object)this.todo)).persistStatus();
        }
        if (this.isChunkTask) {
            ((RequestChunk)((Object)this.todo)).updateGlobalStatus();
        }
    }

    public void logExecution() {
        ArrayList<BookKeeper> bks = HealthDirector.getHealthMonitor().getBookKeepers();
        if (bks.isEmpty()) {
            return;
        }
        LogEvent event = this.todo instanceof RequestChunk ? new LogEvent(this.buildOperationType(), this.userDN, this.surl, this.getStartExecutionTime(), this.howlongInExecution(), this.requestToken, this.successResult) : new LogEvent(this.buildOperationType(), this.userDN, this.surl, this.getStartExecutionTime(), this.howlongInExecution(), this.successResult);
        for (int i = 0; i < bks.size(); ++i) {
            bks.get(i).addLogEvent(event);
        }
    }

    private OperationType buildOperationType() {
        if (this.todo instanceof PtP) {
            return OperationType.PTP;
        }
        if (this.todo instanceof PtG) {
            return OperationType.PTG;
        }
        if (this.todo instanceof Copy) {
            return OperationType.COPY;
        }
        if (this.todo instanceof BoL) {
            return OperationType.BOL;
        }
        return OperationType.UNDEF;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isAsynchTask ? 1231 : 1237);
        result = 31 * result + (this.requestToken == null ? 0 : this.requestToken.hashCode());
        result = 31 * result + (this.successResult ? 1231 : 1237);
        result = 31 * result + (this.surl == null ? 0 : this.surl.hashCode());
        result = 31 * result + (this.todo == null ? 0 : this.todo.hashCode());
        result = 31 * result + (this.userDN == null ? 0 : this.userDN.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkTask other = (ChunkTask)obj;
        if (this.isAsynchTask != other.isAsynchTask) {
            return false;
        }
        if (this.requestToken == null ? other.requestToken != null : !this.requestToken.equals(other.requestToken)) {
            return false;
        }
        if (this.successResult != other.successResult) {
            return false;
        }
        if (this.surl == null ? other.surl != null : !this.surl.equals(other.surl)) {
            return false;
        }
        if (this.todo == null ? other.todo != null : !((Object)this.todo).equals(other.todo)) {
            return false;
        }
        return !(this.userDN == null ? other.userDN != null : !this.userDN.equals(other.userDN));
    }
}

