/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.scheduler;

import it.grid.storm.config.Configuration;
import it.grid.storm.scheduler.Chooser;
import it.grid.storm.scheduler.ChunkTask;
import it.grid.storm.scheduler.Delegable;
import it.grid.storm.scheduler.Scheduler;
import it.grid.storm.scheduler.SchedulerException;
import it.grid.storm.scheduler.SchedulerStatus;
import it.grid.storm.scheduler.Streets;
import it.grid.storm.scheduler.WorkerPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkScheduler
implements Scheduler,
Streets {
    private static ChunkScheduler istance = null;
    private static final Logger log = LoggerFactory.getLogger(ChunkScheduler.class);
    private SchedulerStatus[] schedStatus = null;
    private int ptp_workerCorePoolSize = Configuration.getInstance().getPtPCorePoolSize();
    private int ptp_workerMaxPoolSize = Configuration.getInstance().getPtPMaxPoolSize();
    private int ptp_queueSize = Configuration.getInstance().getPtPQueueSize();
    private int ptg_workerCorePoolSize = Configuration.getInstance().getPtGCorePoolSize();
    private int ptg_workerMaxPoolSize = Configuration.getInstance().getPtGMaxPoolSize();
    private int ptg_queueSize = Configuration.getInstance().getPtGQueueSize();
    private int copy_workerCorePoolSize = Configuration.getInstance().getCopyCorePoolSize();
    private int copy_workerMaxPoolSize = Configuration.getInstance().getCopyMaxPoolSize();
    private int copy_queueSize = Configuration.getInstance().getCopyQueueSize();
    private int bol_workerCorePoolSize = Configuration.getInstance().getBoLCorePoolSize();
    private int bol_workerMaxPoolSize = Configuration.getInstance().getBoLMaxPoolSize();
    private int bol_queueSize = Configuration.getInstance().getBoLQueueSize();
    private WorkerPool ptg_workers = null;
    private WorkerPool ptp_workers = null;
    private WorkerPool copy_workers = null;
    private WorkerPool bol_workers = null;

    private ChunkScheduler() {
        this.schedStatus = new SchedulerStatus[4];
        this.schedStatus[0] = new SchedulerStatus("PtG_inner_scheduler");
        this.schedStatus[1] = new SchedulerStatus("PtP_inner_scheduler");
        this.schedStatus[2] = new SchedulerStatus("Copy_inner_scheduler");
        this.schedStatus[3] = new SchedulerStatus("BoL_inner_scheduler");
        this.ptg_workers = new WorkerPool(this.ptg_workerCorePoolSize, this.ptg_workerMaxPoolSize, this.ptg_queueSize);
        this.schedStatus[0].setCorePoolSize(this.ptg_workerCorePoolSize);
        this.schedStatus[0].setMaxPoolSize(this.ptg_workerMaxPoolSize);
        this.ptp_workers = new WorkerPool(this.ptp_workerCorePoolSize, this.ptp_workerMaxPoolSize, this.ptp_queueSize);
        this.schedStatus[1].setCorePoolSize(this.ptp_workerCorePoolSize);
        this.schedStatus[1].setMaxPoolSize(this.ptp_workerMaxPoolSize);
        this.copy_workers = new WorkerPool(this.copy_workerCorePoolSize, this.copy_workerMaxPoolSize, this.copy_queueSize);
        this.schedStatus[2].setCorePoolSize(this.copy_workerCorePoolSize);
        this.schedStatus[2].setMaxPoolSize(this.copy_workerMaxPoolSize);
        this.bol_workers = new WorkerPool(this.bol_workerCorePoolSize, this.bol_workerMaxPoolSize, this.bol_queueSize);
        this.schedStatus[3].setCorePoolSize(this.bol_workerCorePoolSize);
        this.schedStatus[3].setMaxPoolSize(this.bol_workerMaxPoolSize);
    }

    public static ChunkScheduler getInstance() {
        if (istance == null) {
            istance = new ChunkScheduler();
        }
        return istance;
    }

    @Override
    public void schedule(Delegable chunk) throws SchedulerException {
        log.debug("Delegable Chunk " + chunk.getName() + " arrived at scheduler");
        Chooser c = (Chooser)((Object)chunk);
        c.choose(this);
    }

    @Override
    public SchedulerStatus getStatus(int type) {
        SchedulerStatus st = null;
        switch (type) {
            case 0: {
                this.schedStatus[0].setCompletedTaskCount(this.ptg_workers.getCompletedTaskCount());
                this.schedStatus[0].setActiveCount(this.ptg_workers.getActiveCount());
                this.schedStatus[0].setLargestPoolSize(this.ptg_workers.getLargestPoolSize());
                this.schedStatus[0].setPoolSize(this.ptg_workers.getActualPoolSize());
                this.schedStatus[0].setTaskCount(this.ptg_workers.getTaskCount());
                this.schedStatus[0].setQueueSize(this.ptg_queueSize);
                this.schedStatus[0].setRemainingCapacity(this.ptg_workers.getRemainingCapacity());
                st = this.schedStatus[0];
                break;
            }
            case 1: {
                this.schedStatus[1].setCompletedTaskCount(this.ptp_workers.getCompletedTaskCount());
                this.schedStatus[1].setActiveCount(this.ptp_workers.getActiveCount());
                this.schedStatus[1].setLargestPoolSize(this.ptp_workers.getLargestPoolSize());
                this.schedStatus[1].setPoolSize(this.ptp_workers.getActualPoolSize());
                this.schedStatus[1].setTaskCount(this.ptp_workers.getTaskCount());
                this.schedStatus[1].setQueueSize(this.ptp_queueSize);
                this.schedStatus[1].setRemainingCapacity(this.ptp_workers.getRemainingCapacity());
                st = this.schedStatus[1];
                break;
            }
            case 2: {
                this.schedStatus[2].setCompletedTaskCount(this.copy_workers.getCompletedTaskCount());
                this.schedStatus[2].setActiveCount(this.copy_workers.getActiveCount());
                this.schedStatus[2].setLargestPoolSize(this.copy_workers.getLargestPoolSize());
                this.schedStatus[2].setPoolSize(this.copy_workers.getActualPoolSize());
                this.schedStatus[2].setTaskCount(this.copy_workers.getTaskCount());
                this.schedStatus[2].setQueueSize(this.copy_queueSize);
                this.schedStatus[2].setRemainingCapacity(this.copy_workers.getRemainingCapacity());
                st = this.schedStatus[2];
                break;
            }
            case 3: {
                this.schedStatus[3].setCompletedTaskCount(this.bol_workers.getCompletedTaskCount());
                this.schedStatus[3].setActiveCount(this.bol_workers.getActiveCount());
                this.schedStatus[3].setLargestPoolSize(this.bol_workers.getLargestPoolSize());
                this.schedStatus[3].setPoolSize(this.bol_workers.getActualPoolSize());
                this.schedStatus[3].setTaskCount(this.bol_workers.getTaskCount());
                this.schedStatus[3].setQueueSize(this.bol_queueSize);
                this.schedStatus[3].setRemainingCapacity(this.bol_workers.getRemainingCapacity());
                st = this.schedStatus[3];
                break;
            }
            default: {
                st = null;
            }
        }
        return st;
    }

    @Override
    public void ptgStreet(Delegable chunk) {
        log.debug("Chunk (declared PTG) " + chunk.getName() + " entered into PTG-street");
        ChunkTask chunkTask = new ChunkTask(chunk);
        try {
            this.ptg_workers.submit(chunkTask);
            log.debug("PtG Worker Pool SIZE = " + this.getStatus(0).getPoolSize());
        }
        catch (SchedulerException ex) {
            log.error("PrepareToGet_Street", (Throwable)ex);
        }
    }

    @Override
    public void ptpStreet(Delegable chunk) {
        log.debug("Chunk (declared PTP) " + chunk.getName() + " entered into PTP-street");
        ChunkTask chunkTask = new ChunkTask(chunk);
        try {
            this.ptp_workers.submit(chunkTask);
            log.debug("PtP Worker Pool SIZE = " + this.getStatus(1).getPoolSize());
        }
        catch (SchedulerException ex) {
            log.error("PrepareToPut_Street submission error", (Throwable)ex);
        }
    }

    @Override
    public void copyStreet(Delegable chunk) {
        log.debug("Chunk (declared COPY) " + chunk.getName() + " entered into COPY-street");
        ChunkTask chunkTask = new ChunkTask(chunk);
        try {
            this.copy_workers.submit(chunkTask);
            log.debug("Copy Worker Pool SIZE = " + this.getStatus(2).getPoolSize());
        }
        catch (SchedulerException ex) {
            log.error("Copy_Street", (Throwable)ex);
        }
    }

    @Override
    public void bolStreet(Delegable chunk) {
        log.debug("Chunk (declared BOL) " + chunk.getName() + " entered into BOL-street");
        ChunkTask chunkTask = new ChunkTask(chunk);
        try {
            this.bol_workers.submit(chunkTask);
            log.debug("BoL Worker Pool SIZE = " + this.getStatus(3).getPoolSize());
        }
        catch (SchedulerException ex) {
            log.error("BoL_Street", (Throwable)ex);
        }
    }

    @Override
    public void abort(Delegable task) throws SchedulerException {
    }

    @Override
    public void suspend(Delegable task) throws SchedulerException {
    }
}

