/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.rest;

import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.embed.GrizzlyWebServer;
import com.sun.grizzly.http.servlet.ServletAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.jersey.api.container.grizzly.GrizzlyWebContainerFactory;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import it.grid.storm.config.Configuration;
import it.grid.storm.info.InfoService;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Servlet;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static Configuration config = Configuration.getInstance();
    public static URI BASE_URI = RestService.getBaseURI();
    private static SelectorThread httpThreadSelector;
    private static final HashSet<String> resources;

    private static int getPort() {
        int restServicePort = config.getRestServicesPort();
        log.debug("Rest Service Port =  " + restServicePort);
        return restServicePort;
    }

    private static URI getBaseURI() {
        return UriBuilder.fromUri((String)"http://localhost/").port(RestService.getPort()).build(new Object[0]);
    }

    private static Map<String, String> buildInitParams() {
        HashMap<String, String> initParams = new HashMap<String, String>();
        String key = "com.sun.jersey.config.property.packages";
        String value = "";
        for (String resource : resources) {
            value = value + resource + ";";
        }
        initParams.put(key, value);
        return initParams;
    }

    public static void startServer() throws IOException {
        log.info("Starting Grizzly Web Server ... ");
        SelectorThread threadSelector = GrizzlyWebContainerFactory.create((URI)BASE_URI, RestService.buildInitParams());
        log.info(" ... started!");
        httpThreadSelector = threadSelector;
    }

    public static void startWithAdapter() throws IOException {
        GrizzlyWebServer ws = new GrizzlyWebServer(config.getRestServicesPort());
        ServletAdapter jerseyAdapter = new ServletAdapter();
        jerseyAdapter.setServletInstance((Servlet)new ServletContainer());
        Map<String, String> initParam = RestService.buildInitParams();
        String key = "com.sun.jersey.config.property.packages";
        jerseyAdapter.addInitParameter(key, initParam.get(key));
        ws.addGrizzlyAdapter((GrizzlyAdapter)jerseyAdapter, new String[]{"/"});
        ws.getSelectorThread().enableMonitoring();
        ws.start();
    }

    public static boolean isRunning() {
        return httpThreadSelector != null;
    }

    public static void stop() {
        if (httpThreadSelector != null) {
            httpThreadSelector.stopEndpoint();
        }
    }

    static {
        resources = new HashSet<String>(){
            {
                this.add("it.grid.storm.tape.recalltable.resources");
                this.add(InfoService.getResourcePackage());
                this.add("it.grid.storm.authz.remote.resource");
                this.add("it.grid.storm.namespace.remote.resource");
                this.add("it.grid.storm.ea.remote.resource");
            }
        };
    }
}

