/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.util.helper;

import it.grid.storm.persistence.model.TapeRecallTO;
import it.grid.storm.persistence.util.db.SQLHelper;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeRecallMySQLHelper
extends SQLHelper {
    private static final Logger log = LoggerFactory.getLogger(TapeRecallMySQLHelper.class);
    private static final String TABLE_NAME = "tape_recall";
    public static final String COL_TASK_ID = "taskId";
    public static final String COL_REQUEST_TOKEN = "requestToken";
    public static final String COL_REQUEST_TYPE = "requestType";
    public static final String COL_FILE_NAME = "fileName";
    public static final String COL_PIN_LIFETIME = "pinLifetime";
    public static final String COL_STATUS = "status";
    public static final String COL_USER_ID = "userID";
    public static final String COL_VO_NAME = "voName";
    public static final String COL_DATE = "timeStamp";
    public static final String COL_RETRY_ATTEMPT = "retryAttempt";
    public static final String COL_DEFERRED_STARTTIME = "deferredStartTime";
    public static final String COL_GROUP_TASK_ID = "groupTaskId";
    public static final String COL_IN_PROGRESS_DATE = "inProgressTime";
    public static final String COL_FINAL_STATUS_DATE = "finalStatusTime";

    private static boolean validTimestampColumnName(String columnName) {
        return COL_DATE.equals(columnName) || COL_IN_PROGRESS_DATE.equals(columnName) || COL_FINAL_STATUS_DATE.equals(columnName);
    }

    public TapeRecallMySQLHelper(String dbmsVendor) {
        super(dbmsVendor);
    }

    private String formatString(String s) {
        if (s == null) {
            return null;
        }
        return "'" + s + "'";
    }

    public PreparedStatement getQueryInsertTask(Connection conn, TapeRecallTO recallTask) {
        if (recallTask == null) {
            return null;
        }
        String query = "INSERT INTO tape_recall (taskId, requestToken, requestType, fileName, pinLifetime, status, voName, userID, retryAttempt, deferredStartTime, timeStamp, groupTaskId) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        try {
            PreparedStatement prepStat = conn.prepareStatement(query);
            int idx = 1;
            prepStat.setString(idx++, recallTask.getTaskId().toString());
            prepStat.setString(idx++, recallTask.getRequestToken().getValue());
            prepStat.setString(idx++, recallTask.getRequestType());
            prepStat.setString(idx++, recallTask.getFileName());
            prepStat.setInt(idx++, recallTask.getPinLifetime());
            prepStat.setInt(idx++, recallTask.getStatusId());
            prepStat.setString(idx++, recallTask.getVoName());
            prepStat.setString(idx++, recallTask.getUserID());
            prepStat.setInt(idx++, recallTask.getRetryAttempt());
            prepStat.setTimestamp(idx++, new Timestamp(recallTask.getDeferredRecallInstant().getTime()));
            prepStat.setTimestamp(idx++, new Timestamp(recallTask.getInsertionInstant().getTime()));
            prepStat.setString(idx++, recallTask.getGroupTaskId().toString());
            return prepStat;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public String getQueryGetTask(UUID taskId, String requestToken) {
        String queryFormat = "SELECT * FROM tape_recall WHERE taskId=" + this.formatString(taskId.toString()) + " AND " + COL_REQUEST_TOKEN + "=" + this.formatString(requestToken);
        return queryFormat;
    }

    public String getQueryGetGroupTasks(UUID groupTaskId) {
        String queryFormat = "SELECT * FROM tape_recall WHERE groupTaskId=" + this.formatString(groupTaskId.toString());
        return queryFormat;
    }

    public String getQueryGetGroupTaskIds(UUID taskId) {
        String queryFormat = "SELECT DISTINCT groupTaskId , status , inProgressTime , finalStatusTime FROM tape_recall WHERE taskId=" + this.formatString(taskId.toString());
        return queryFormat;
    }

    public String getQueryGetGroupTaskIds(UUID taskId, int[] statuses) {
        String queryFormat = "SELECT DISTINCT groupTaskId , status , inProgressTime , finalStatusTime FROM tape_recall WHERE taskId=" + this.formatString(taskId.toString()) + " AND " + COL_STATUS + " IN ( ";
        boolean first = true;
        for (int status : statuses) {
            if (first) {
                first = false;
            } else {
                queryFormat = queryFormat + " , ";
            }
            queryFormat = queryFormat + status;
        }
        queryFormat = queryFormat + " )";
        return queryFormat;
    }

    public String getQueryNumberQueued() {
        String queryFormat = "SELECT COUNT(DISTINCT groupTaskId) FROM tape_recall WHERE status=" + TapeRecallStatus.QUEUED.getStatusId();
        return queryFormat;
    }

    public String getQueryNumberQueued(String voName) {
        String queryFormat = "SELECT COUNT(DISTINCT groupTaskId) FROM tape_recall WHERE status=" + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_VO_NAME + "=" + this.formatString(voName);
        return queryFormat;
    }

    public String getQueryReadyForTakeOver() {
        String queryFormat = "SELECT COUNT(DISTINCT groupTaskId) FROM tape_recall WHERE status=" + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_DEFERRED_STARTTIME + "<=NOW()";
        return queryFormat;
    }

    public String getQueryReadyForTakeOver(String voName) {
        String queryFormat = "SELECT COUNT(DISTINCT groupTaskId) FROM tape_recall WHERE status=" + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_VO_NAME + "=" + this.formatString(voName) + " AND " + COL_DEFERRED_STARTTIME + "<=NOW()";
        return queryFormat;
    }

    public String getQueryNumberInProgress() {
        String queryFormat = "SELECT COUNT(DISTINCT groupTaskId) FROM tape_recall WHERE status=" + TapeRecallStatus.IN_PROGRESS.getStatusId();
        return queryFormat;
    }

    public String getQueryNumberInProgress(String voName) {
        String queryFormat = "SELECT COUNT(DISTINCT groupTaskId) FROM tape_recall WHERE status=" + TapeRecallStatus.IN_PROGRESS.getStatusId() + " AND " + COL_VO_NAME + "=" + this.formatString(voName);
        return queryFormat;
    }

    public String getQueryGetTakeoverTasksWithDoubles(int numberOfTasks) {
        String queryFormat = "SELECT * FROM tape_recall WHERE status=" + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_DEFERRED_STARTTIME + "<=NOW() ORDER BY " + COL_DEFERRED_STARTTIME + " LIMIT " + numberOfTasks;
        return queryFormat;
    }

    public String getQueryGetTakeoverTasksWithDoubles(int numberOfTasks, String voName) {
        String queryFormat = "SELECT * FROM tape_recall WHERE status=" + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_VO_NAME + "=" + this.formatString(voName) + " AND " + COL_DEFERRED_STARTTIME + "<=NOW() ORDER BY " + COL_DEFERRED_STARTTIME + " LIMIT " + numberOfTasks;
        return queryFormat;
    }

    public String getQueryUpdateTasksStatus(List<TapeRecallTO> taskList, int statusId, String timestampColumn, Date timestamp) throws IllegalArgumentException {
        if (taskList.size() == 0) {
            return null;
        }
        if (TapeRecallMySQLHelper.validTimestampColumnName(timestampColumn)) {
            String queryFormat = "UPDATE tape_recall SET status=" + statusId + " , " + timestampColumn + "='" + new Timestamp(timestamp.getTime()) + "' " + " WHERE " + COL_GROUP_TASK_ID + "=" + this.formatString(taskList.get(0).getGroupTaskId().toString());
            for (int i = 1; i < taskList.size(); ++i) {
                queryFormat = queryFormat + " OR groupTaskId=" + this.formatString(taskList.get(i).getGroupTaskId().toString());
            }
            return queryFormat;
        }
        throw new IllegalArgumentException("Unable to update row status and timestamp. The priovided timestamp column '" + timestampColumn + "' is not valid");
    }

    public String getQueryUpdateGroupTaskStatus(UUID groupTaskId, int status, String timestampColumn, Date timestamp) throws IllegalArgumentException {
        if (TapeRecallMySQLHelper.validTimestampColumnName(timestampColumn)) {
            String queryFormat = "UPDATE tape_recall SET status=" + status + " , " + timestampColumn + "='" + new Timestamp(timestamp.getTime()) + "' " + " WHERE " + COL_GROUP_TASK_ID + "=" + this.formatString(groupTaskId.toString()) + " AND " + COL_STATUS + "!=" + status;
            return queryFormat;
        }
        throw new IllegalArgumentException("Unable to update row status and timestamp. The priovided timestamp column '" + timestampColumn + "' is not valid");
    }

    public String getQuerySetGroupTaskStatus(UUID groupTaskId, int status) {
        String queryFormat = "UPDATE tape_recall SET status=" + status + " WHERE " + COL_GROUP_TASK_ID + "=" + this.formatString(groupTaskId.toString()) + " AND " + COL_STATUS + "!=" + status;
        return queryFormat;
    }

    public String getQuerySetGroupTaskRetryValue(UUID groupTaskId, int value) {
        String queryFormat = "UPDATE tape_recall SET retryAttempt=" + value + " WHERE " + COL_GROUP_TASK_ID + "=" + this.formatString(groupTaskId.toString());
        return queryFormat;
    }

    public String getQueryDeleteCompletedTasks() {
        String queryFormat = "DELETE FROM tape_recall WHERE status<>" + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_STATUS + "<>" + TapeRecallStatus.IN_PROGRESS.getStatusId();
        return queryFormat;
    }

    public String getQueryDeleteCompletedTasks(int maxNumTasks) {
        String queryFormat = "DELETE FROM tape_recall WHERE status != " + TapeRecallStatus.QUEUED.getStatusId() + " AND " + COL_STATUS + " != " + TapeRecallStatus.IN_PROGRESS.getStatusId() + " LIMIT " + maxNumTasks;
        return queryFormat;
    }
}

