/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.util.helper;

import it.grid.storm.common.types.VO;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.persistence.model.StorageSpaceTO;
import it.grid.storm.persistence.util.db.InsertBuilder;
import it.grid.storm.persistence.util.db.SQLHelper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public class StorageSpaceSQLHelper
extends SQLHelper {
    private static final String TABLE_NAME = "storage_space";
    private static final HashMap<String, String> COLS = new HashMap();
    private static final String[] COLUMN_NAMES = new String[]{"SS_ID", "USERDN", "VOGROUP", "ALIAS", "SPACE_TOKEN", "CREATED", "TOTAL_SIZE", "GUAR_SIZE", "FREE_SIZE", "SPACE_FILE", "STORAGE_INFO", "LIFETIME", "SPACE_TYPE", "USED_SIZE", "BUSY_SIZE", "UNAVAILABLE_SIZE", "AVAILABLE_SIZE", "RESERVED_SIZE", "UPDATE_TIME"};
    private InsertBuilder builder;

    public StorageSpaceSQLHelper(String dbmsVendor) {
        super(dbmsVendor);
    }

    public String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    public String insertQuery(StorageSpaceTO ssTO) {
        this.builder = new InsertBuilder();
        this.builder.setTable(TABLE_NAME);
        if (ssTO != null) {
            if (ssTO.getOwnerName() != null) {
                this.builder.addColumnAndData(COLS.get("ownerName"), this.format(ssTO.getOwnerName()));
            }
            this.builder.addColumnAndData(COLS.get("ownerVO"), this.format(this.getVOName(ssTO.getVoName())));
            if (ssTO.getAlias() != null) {
                this.builder.addColumnAndData(COLS.get("alias"), this.format(ssTO.getAlias()));
            }
            if (ssTO.getSpaceToken() != null) {
                this.builder.addColumnAndData(COLS.get("token"), this.format(ssTO.getSpaceToken()));
            }
            if (ssTO.getCreated() != null) {
                this.builder.addColumnAndData(COLS.get("created"), this.format(ssTO.getCreated()));
            }
            if (ssTO.getSpaceFile() != null) {
                this.builder.addColumnAndData(COLS.get("spaceFile"), this.format(ssTO.getSpaceFile()));
            }
            if (ssTO.getStorageInfo() != null) {
                this.builder.addColumnAndData(COLS.get("storaqeInfo"), this.format(ssTO.getStorageInfo()));
            }
            if (ssTO.getLifetime() != -1L) {
                this.builder.addColumnAndData(COLS.get("lifeTime"), this.format(ssTO.getLifetime()));
            }
            if (ssTO.getSpaceType() != null) {
                this.builder.addColumnAndData(COLS.get("spaceType"), this.format(ssTO.getSpaceType()));
            }
            if (ssTO.getTotalSize() != 0L || ssTO.getTotalSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("total_size"), this.format(ssTO.getTotalSize()));
            }
            if (ssTO.getGuaranteedSize() != 0L || ssTO.getGuaranteedSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("guar_size"), this.format(ssTO.getGuaranteedSize()));
            }
            if (ssTO.getFreeSize() != 0L || ssTO.getFreeSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("free_size"), this.format(ssTO.getFreeSize()));
            }
            if (ssTO.getUsedSize() != 0L || ssTO.getUsedSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("used_size"), this.format(ssTO.getUsedSize()));
            }
            if (ssTO.getBusySize() != 0L || ssTO.getBusySize() != -1L) {
                this.builder.addColumnAndData(COLS.get("busy_size"), this.format(ssTO.getBusySize()));
            }
            if (ssTO.getUnavailableSize() != 0L || ssTO.getUnavailableSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("unavailable_size"), this.format(ssTO.getUnavailableSize()));
            }
            if (ssTO.getAvailableSize() != 0L || ssTO.getAvailableSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("available_size"), this.format(ssTO.getAvailableSize()));
            }
            if (ssTO.getReservedSize() != 0L || ssTO.getReservedSize() != -1L) {
                this.builder.addColumnAndData(COLS.get("reserved_size"), this.format(ssTO.getReservedSize()));
            }
            if (ssTO.getUpdateTime() != null) {
                this.builder.addColumnAndData(COLS.get("update_time"), this.format(ssTO.getUpdateTime()));
            }
        }
        String sql = this.buildSQL(this.builder);
        return sql;
    }

    public StorageSpaceTO makeStorageSpaceTO(ResultSet res) {
        StorageSpaceTO ssTO = new StorageSpaceTO();
        try {
            ssTO.setStorageSpaceId(new Long(res.getLong("SS_ID")));
            ssTO.setOwnerName(res.getString("USERDN"));
            ssTO.setVoName(res.getString("VOGROUP"));
            ssTO.setAlias(res.getString("ALIAS"));
            ssTO.setSpaceToken(res.getString("SPACE_TOKEN"));
            Timestamp createdTimeStamp = res.getTimestamp("CREATED");
            Date creationDate = new Date(createdTimeStamp.getTime());
            ssTO.setCreated(creationDate);
            ssTO.setSpaceFile(res.getString("SPACE_FILE"));
            ssTO.setStorageInfo(res.getString("STORAGE_INFO"));
            long tempLong = res.getLong("LIFETIME");
            if (!res.wasNull()) {
                ssTO.setLifetime(tempLong);
            }
            ssTO.setSpaceType(res.getString("SPACE_TYPE"));
            tempLong = res.getLong("TOTAL_SIZE");
            if (!res.wasNull()) {
                ssTO.setTotalSize(tempLong);
            }
            tempLong = res.getLong("GUAR_SIZE");
            if (!res.wasNull()) {
                ssTO.setGuaranteedSize(tempLong);
            }
            tempLong = res.getLong("RESERVED_SIZE");
            if (!res.wasNull()) {
                ssTO.setReservedSize(tempLong);
            }
            tempLong = res.getLong("FREE_SIZE");
            if (!res.wasNull()) {
                ssTO.setFreeSize(tempLong);
            }
            tempLong = res.getLong("AVAILABLE_SIZE");
            if (!res.wasNull()) {
                ssTO.setAvailableSize(tempLong);
            }
            tempLong = res.getLong("USED_SIZE");
            if (!res.wasNull()) {
                ssTO.setUsedSize(tempLong);
            }
            tempLong = res.getLong("BUSY_SIZE");
            if (!res.wasNull()) {
                ssTO.setBusySize(tempLong);
            }
            tempLong = res.getLong("UNAVAILABLE_SIZE");
            if (!res.wasNull()) {
                ssTO.setUnavailableSize(tempLong);
            }
            Timestamp updatedTimeStamp = res.getTimestamp("UPDATE_TIME");
            Date updateDate = new Date(updatedTimeStamp.getTime());
            ssTO.setUpdateTime(updateDate);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return ssTO;
    }

    private String getVOName(String vo) {
        String voStr = VO.makeNoVo().getValue();
        if (vo != null && !vo.trim().equals("")) {
            voStr = vo.trim();
        }
        return voStr;
    }

    public String selectByTokenQuery(String token) {
        return "SELECT * FROM `storage_space` where space_token='" + token + "'";
    }

    public String selectBySpaceAliasQuery(GridUserInterface user, String spaceAlias) {
        String dn = user.getDn();
        if (spaceAlias == null || spaceAlias.length() == 0) {
            return "SELECT * FROM `storage_space` where userdn='" + dn + "'";
        }
        return "SELECT * FROM `storage_space` where userdn='" + dn + "' AND alias='" + spaceAlias + "'";
    }

    public String selectBySpaceAliasOnlyQuery(String spaceAlias) {
        return "SELECT * FROM `storage_space` where alias='" + spaceAlias + "'";
    }

    public String selectBySpaceType(String voname) {
        return "SELECT * FROM `storage_space` where SPACE_TYPE='" + voname + "'";
    }

    public String selectExpiredQuery(long currentTimeInSecond) {
        return "SELECT * FROM `storage_space` where  lifetime is not null and (UNIX_TIMESTAMP(created)+lifetime< " + currentTimeInSecond + ")";
    }

    public String selectByUnavailableUsedSpaceSizeQuery(long unavailableSizeValue) {
        return "SELECT * FROM `storage_space` where " + COLS.get("used_size") + " IS NULL or " + COLS.get("used_size") + "=" + unavailableSizeValue;
    }

    public String selectByPreviousOrNullLastUpdateQuery(long lastUpdateTimestamp) {
        return "SELECT * FROM `storage_space` where " + COLS.get("update_time") + " IS NULL or UNIX_TIMESTAMP(" + COLS.get("update_time") + ") < " + lastUpdateTimestamp;
    }

    public String removeByTokenQuery(GridUserInterface user, String spaceToken) {
        return "DELETE FROM `storage_space` WHERE ((USERDN='" + user.getDn() + "') AND (SPACE_TOKEN='" + spaceToken + "'))";
    }

    public String removeByTokenQuery(String spaceToken) {
        return "DELETE FROM `storage_space` WHERE (SPACE_TOKEN='" + spaceToken + "')";
    }

    public String updateByAliasAndTokenQuery(StorageSpaceTO ssTO) throws IllegalArgumentException {
        if (ssTO == null) {
            throw new IllegalArgumentException();
        }
        String query = "UPDATE `storage_space` SET";
        if (ssTO.getOwnerName() != null) {
            query = query + " `" + COLS.get("ownerName") + "` = " + this.format(ssTO.getOwnerName()) + " ,";
        }
        query = query + " `" + COLS.get("ownerVO") + "` = " + this.format(this.getVOName(ssTO.getVoName())) + " ,";
        if (ssTO.getCreated() != null) {
            query = query + " `" + COLS.get("created") + "` = " + this.format(ssTO.getCreated()) + " ,";
        }
        if (ssTO.getSpaceFile() != null) {
            query = query + " `" + COLS.get("spaceFile") + "` = " + this.format(ssTO.getSpaceFile()) + " ,";
        }
        if (ssTO.getStorageInfo() != null) {
            query = query + " `" + COLS.get("storaqeInfo") + "` = " + this.format(ssTO.getStorageInfo()) + " ,";
        }
        if (ssTO.getLifetime() != -1L) {
            query = query + " `" + COLS.get("lifeTime") + "` = " + this.format(ssTO.getLifetime()) + " ,";
        }
        if (ssTO.getSpaceType() != null) {
            query = query + " `" + COLS.get("spaceType") + "` = " + this.format(ssTO.getSpaceType()) + " ,";
        }
        if (ssTO.getTotalSize() != 0L || ssTO.getTotalSize() != -1L) {
            query = query + " `" + COLS.get("total_size") + "` = " + this.format(ssTO.getTotalSize()) + " ,";
        }
        if (ssTO.getGuaranteedSize() != 0L || ssTO.getGuaranteedSize() != -1L) {
            query = query + " `" + COLS.get("guar_size") + "` = " + this.format(ssTO.getGuaranteedSize()) + " ,";
        }
        if (ssTO.getFreeSize() != 0L || ssTO.getFreeSize() != -1L) {
            query = query + " `" + COLS.get("free_size") + "` = " + this.format(ssTO.getFreeSize()) + " ,";
        }
        if (ssTO.getUsedSize() != 0L || ssTO.getUsedSize() != -1L) {
            query = query + " `" + COLS.get("used_size") + "` = " + this.format(ssTO.getUsedSize()) + " ,";
        }
        if (ssTO.getBusySize() != 0L || ssTO.getBusySize() != -1L) {
            query = query + " `" + COLS.get("busy_size") + "` = " + this.format(ssTO.getBusySize()) + " ,";
        }
        if (ssTO.getUnavailableSize() != 0L || ssTO.getUnavailableSize() != -1L) {
            query = query + " `" + COLS.get("unavailable_size") + "` = " + this.format(ssTO.getUnavailableSize()) + " ,";
        }
        if (ssTO.getAvailableSize() != 0L || ssTO.getAvailableSize() != -1L) {
            query = query + " `" + COLS.get("available_size") + "` = " + this.format(ssTO.getAvailableSize()) + " ,";
        }
        if (ssTO.getReservedSize() != 0L || ssTO.getReservedSize() != -1L) {
            query = query + " `" + COLS.get("reserved_size") + "` = " + this.format(ssTO.getReservedSize()) + " ,";
        }
        if (ssTO.getUpdateTime() != null) {
            query = query + " `" + COLS.get("update_time") + "` = " + this.format(ssTO.getUpdateTime()) + "";
        }
        if (query.charAt(query.length() - 1) == ',') {
            query = query.substring(0, query.length() - 1);
        }
        query = query + " where `" + COLS.get("alias") + "` = " + this.format(ssTO.getAlias()) + " and `" + COLS.get("token") + "` = " + this.format(ssTO.getSpaceToken());
        return query;
    }

    public String updateByTokenQuery(StorageSpaceTO ssTO) throws IllegalArgumentException {
        if (ssTO == null) {
            throw new IllegalArgumentException();
        }
        String query = "UPDATE `storage_space` SET";
        if (ssTO.getOwnerName() != null) {
            query = query + " `" + COLS.get("ownerName") + "` = " + this.format(ssTO.getOwnerName()) + " ,";
        }
        query = query + " `" + COLS.get("ownerVO") + "` = " + this.format(this.getVOName(ssTO.getVoName())) + " ,";
        if (ssTO.getCreated() != null) {
            query = query + " `" + COLS.get("created") + "` = " + this.format(ssTO.getCreated()) + " ,";
        }
        if (ssTO.getAlias() != null) {
            query = query + " `" + COLS.get("alias") + "` = " + this.format(ssTO.getAlias()) + " ,";
        }
        if (ssTO.getSpaceFile() != null) {
            query = query + " `" + COLS.get("spaceFile") + "` = " + this.format(ssTO.getSpaceFile()) + " ,";
        }
        if (ssTO.getStorageInfo() != null) {
            query = query + " `" + COLS.get("storaqeInfo") + "` = " + this.format(ssTO.getStorageInfo()) + " ,";
        }
        if (ssTO.getLifetime() != -1L) {
            query = query + " `" + COLS.get("lifeTime") + "` = " + this.format(ssTO.getLifetime()) + " ,";
        }
        if (ssTO.getSpaceType() != null) {
            query = query + " `" + COLS.get("spaceType") + "` = " + this.format(ssTO.getSpaceType()) + " ,";
        }
        if (ssTO.getTotalSize() != 0L || ssTO.getTotalSize() != -1L) {
            query = query + " `" + COLS.get("total_size") + "` = " + this.format(ssTO.getTotalSize()) + " ,";
        }
        if (ssTO.getGuaranteedSize() != 0L || ssTO.getGuaranteedSize() != -1L) {
            query = query + " `" + COLS.get("guar_size") + "` = " + this.format(ssTO.getGuaranteedSize()) + " ,";
        }
        if (ssTO.getFreeSize() != 0L || ssTO.getFreeSize() != -1L) {
            query = query + " `" + COLS.get("free_size") + "` = " + this.format(ssTO.getFreeSize()) + " ,";
        }
        if (ssTO.getUsedSize() != 0L || ssTO.getUsedSize() != -1L) {
            query = query + " `" + COLS.get("used_size") + "` = " + this.format(ssTO.getUsedSize()) + " ,";
        }
        if (ssTO.getBusySize() != 0L || ssTO.getBusySize() != -1L) {
            query = query + " `" + COLS.get("busy_size") + "` = " + this.format(ssTO.getBusySize()) + " ,";
        }
        if (ssTO.getUnavailableSize() != 0L || ssTO.getUnavailableSize() != -1L) {
            query = query + " `" + COLS.get("unavailable_size") + "` = " + this.format(ssTO.getUnavailableSize()) + " ,";
        }
        if (ssTO.getAvailableSize() != 0L || ssTO.getAvailableSize() != -1L) {
            query = query + " `" + COLS.get("available_size") + "` = " + this.format(ssTO.getAvailableSize()) + " ,";
        }
        if (ssTO.getReservedSize() != 0L || ssTO.getReservedSize() != -1L) {
            query = query + " `" + COLS.get("reserved_size") + "` = " + this.format(ssTO.getReservedSize()) + " ,";
        }
        if (ssTO.getUpdateTime() != null) {
            query = query + " `" + COLS.get("update_time") + "` = " + this.format(ssTO.getUpdateTime()) + "";
        }
        if (query.charAt(query.length() - 1) == ',') {
            query = query.substring(0, query.length() - 1);
        }
        query = query + " where `" + COLS.get("token") + "` = " + this.format(ssTO.getSpaceToken());
        return query;
    }

    public String updateFreeSpaceByTokenQuery(String token, long freeSpace, Date updateTimestamp) {
        return "UPDATE `storage_space` SET `free_size`=" + freeSpace + " , " + "`UPDATE_TIME`=" + this.format(updateTimestamp) + " WHERE space_token='" + token + "'";
    }

    public String updateSpaceSizesByTokenQuery(String token, long freeSpace, long availableSpace, long usedSpace, long busySpace, long unavailableSpace, Date updateTimestamp) {
        String query = "UPDATE `storage_space` SET ";
        query = query + "`free_size`=" + freeSpace;
        query = query + "`available_size`=" + availableSpace;
        query = query + "`used_size`=" + usedSpace;
        query = query + "`busy_size`=" + busySpace;
        query = query + "`unavailable_size`=" + unavailableSpace;
        query = query + "`UPDATE_TIME`=" + this.format(updateTimestamp);
        query = query + " WHERE space_token='" + token + "'";
        return query;
    }

    static {
        COLS.put("storageSpaceId", "SS_ID");
        COLS.put("ownerName", "USERDN");
        COLS.put("ownerVO", "VOGROUP");
        COLS.put("alias", "ALIAS");
        COLS.put("token", "SPACE_TOKEN");
        COLS.put("created", "CREATED");
        COLS.put("spaceFile", "SPACE_FILE");
        COLS.put("storaqeInfo", "STORAGE_INFO");
        COLS.put("lifeTime", "LIFETIME");
        COLS.put("spaceType", "SPACE_TYPE");
        COLS.put("total_size", "TOTAL_SIZE");
        COLS.put("guar_size", "GUAR_SIZE");
        COLS.put("free_size", "FREE_SIZE");
        COLS.put("used_size", "USED_SIZE");
        COLS.put("busy_size", "BUSY_SIZE");
        COLS.put("unavailable_size", "UNAVAILABLE_SIZE");
        COLS.put("available_size", "AVAILABLE_SIZE");
        COLS.put("reserved_size", "RESERVED_SIZE");
        COLS.put("update_time", "UPDATE_TIME");
    }
}

