/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.model;

import it.grid.storm.srm.types.InvalidTRequestTokenAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.tape.recalltable.model.TapeRecallStatus;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapeRecallTO
implements Serializable,
Comparable<TapeRecallTO> {
    private static final Logger log = LoggerFactory.getLogger(TapeRecallTO.class);
    private static final long serialVersionUID = -2907739786996767167L;
    public static final String PTG_REQUEST = "ptg";
    public static final String BOL_REQUEST = "bol";
    public static final String BACK_REQUEST = "back";
    public static final String startChar = "";
    public static final char sepChar = '\t';
    public static final String dateFormat = "dd-MM-yyyy HH.mm.ss";
    private UUID taskId = null;
    private TRequestToken requestToken = null;
    private String requestType = null;
    private String fileName = null;
    private String userID = null;
    private String voName = null;
    private int pinLifetime = 0;
    private TapeRecallStatus status = TapeRecallStatus.QUEUED;
    private int retryAttempt = 0;
    private Date insertionInstant = null;
    private Date inProgressInstant = null;
    private Date finalStateInstant = null;
    private Date deferredRecallInstant = null;
    private UUID groupTaskId = null;

    public static TapeRecallTO createRandom(Date date, String voName) {
        TapeRecallTO result = new TapeRecallTO();
        result.setFileName("/root/" + voName + "/test/" + Math.round(Math.random() * 1000.0));
        result.setRequestToken(TRequestToken.getRandom());
        if (Math.random() % 2.0 == 0.0) {
            result.setRequestType(BOL_REQUEST);
        } else {
            result.setRequestType(PTG_REQUEST);
        }
        result.setUserID("FakeId");
        result.setRetryAttempt(0);
        result.setPinLifetime((int)Math.round(Math.random() * 1000.0));
        result.setVoName(voName);
        result.setInsertionInstant(date);
        int deferred = 0;
        if (Math.random() % 2.0 == 0.0) {
            deferred = 1;
        }
        Date deferredRecallTime = new Date(date.getTime() + (long)deferred * (long)Math.random());
        result.setDeferredRecallInstant(deferredRecallTime);
        result.setGroupTaskId(UUID.randomUUID());
        return result;
    }

    @Override
    public int compareTo(TapeRecallTO arg0) {
        if (arg0 == null) {
            return 0;
        }
        return this.insertionInstant.compareTo(arg0.getInsertionInstant());
    }

    public Date getDeferredRecallInstant() {
        return this.deferredRecallInstant;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Date getInsertionInstant() {
        return this.insertionInstant;
    }

    public Date getInProgressInstant() {
        return this.inProgressInstant;
    }

    public Date getFinalStateInstant() {
        return this.finalStateInstant;
    }

    public int getPinLifetime() {
        return this.pinLifetime;
    }

    public TapeRecallStatus getRecallStatus() {
        return this.status;
    }

    public TRequestToken getRequestToken() {
        return this.requestToken;
    }

    public String getRequestTokenStr() {
        return this.requestToken.getValue();
    }

    public String getRequestType() {
        return this.requestType;
    }

    public int getRetryAttempt() {
        return this.retryAttempt;
    }

    public int getStatusId() {
        return this.status.getStatusId();
    }

    public UUID getTaskId() {
        this.buildTaskId();
        return this.taskId;
    }

    public UUID getGroupTaskId() {
        return this.groupTaskId;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getVoName() {
        return this.voName;
    }

    public void setDeferredRecallInstant(Date date) {
        this.deferredRecallInstant = date;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
        this.buildTaskId();
    }

    public void setInsertionInstant(Date date) {
        this.insertionInstant = date;
    }

    private void setInProgressInstant(Date date) {
        this.inProgressInstant = date;
    }

    private void setFinalStateInstant(Date date) {
        this.finalStateInstant = date;
    }

    public void setPinLifetime(int pinLifetime) {
        this.pinLifetime = pinLifetime;
    }

    public void setRequestToken(TRequestToken requestToken) {
        this.requestToken = requestToken;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public void setRetryAttempt(int retryAttempt) {
        this.retryAttempt = retryAttempt;
    }

    public void setStatus(TapeRecallStatus status) {
        this.status = status;
        if (this.status.equals((Object)TapeRecallStatus.IN_PROGRESS) && this.inProgressInstant == null) {
            this.setInProgressInstant(new Date());
        } else if (TapeRecallStatus.isFinalStatus(this.status.getStatusId()) && this.inProgressInstant == null) {
            this.setFinalStateInstant(new Date());
        }
    }

    public void setStatusId(int statusId) {
        this.setStatus(TapeRecallStatus.getRecallTaskStatus(statusId));
    }

    public void setTaskId(UUID taskId) {
        this.taskId = taskId;
    }

    public void setGroupTaskId(UUID groupTaskId) {
        this.groupTaskId = groupTaskId;
    }

    public void setUserID(String userID) {
        this.userID = userID;
    }

    public void setVoName(String voName) {
        this.voName = voName;
    }

    public String toGEMSS() {
        StringBuffer sb = new StringBuffer();
        sb.append(startChar);
        sb.append(this.groupTaskId);
        sb.append('\t');
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        if (this.insertionInstant != null) {
            sb.append(formatter.format((Object)this.insertionInstant));
        } else {
            GregorianCalendar endOfTheWorld = new GregorianCalendar(2012, 11, 21);
            this.insertionInstant = endOfTheWorld.getTime();
            sb.append(formatter.format((Object)this.insertionInstant));
        }
        sb.append('\t');
        sb.append(this.requestType);
        sb.append('\t');
        sb.append(this.fileName);
        sb.append('\t');
        sb.append(this.voName);
        sb.append('\t');
        sb.append(this.userID);
        sb.append('\t');
        sb.append(this.retryAttempt);
        sb.append('\t');
        sb.append((Object)this.status);
        sb.append('\t');
        if (this.deferredRecallInstant != null) {
            sb.append(formatter.format((Object)this.deferredRecallInstant));
        } else {
            sb.append(formatter.format((Object)this.insertionInstant));
        }
        sb.append('\t');
        sb.append(this.pinLifetime);
        sb.append('\t');
        sb.append(this.requestToken);
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(startChar);
        sb.append(this.taskId);
        sb.append('\t');
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        if (this.insertionInstant != null) {
            sb.append(formatter.format((Object)this.insertionInstant));
        } else {
            GregorianCalendar endOfTheWorld = new GregorianCalendar(2012, 11, 21);
            this.insertionInstant = endOfTheWorld.getTime();
            sb.append(formatter.format((Object)this.insertionInstant));
        }
        sb.append('\t');
        sb.append(this.requestType);
        sb.append('\t');
        sb.append(this.fileName);
        sb.append('\t');
        sb.append(this.voName);
        sb.append('\t');
        sb.append(this.userID);
        sb.append('\t');
        sb.append(this.retryAttempt);
        sb.append('\t');
        sb.append((Object)this.status);
        sb.append('\t');
        if (this.inProgressInstant != null) {
            sb.append(formatter.format((Object)this.inProgressInstant));
        } else {
            sb.append("null");
        }
        sb.append('\t');
        if (this.finalStateInstant != null) {
            sb.append(formatter.format((Object)this.finalStateInstant));
        } else {
            sb.append("null");
        }
        sb.append('\t');
        if (this.deferredRecallInstant != null) {
            sb.append(formatter.format((Object)this.deferredRecallInstant));
        } else {
            sb.append(formatter.format((Object)this.insertionInstant));
        }
        sb.append('\t');
        sb.append(this.pinLifetime);
        sb.append('\t');
        sb.append(this.requestToken);
        sb.append('\t');
        sb.append(this.groupTaskId);
        return sb.toString();
    }

    private void buildTaskId() {
        if (this.fileName != null) {
            this.taskId = TapeRecallTO.buildTaskIdFromFileName(this.fileName);
        } else {
            log.error("Unable to create taskId because filename is NULL");
        }
    }

    public static UUID buildTaskIdFromFileName(String fileName) {
        return UUID.nameUUIDFromBytes(fileName.getBytes());
    }

    public void forceStatusUpdateInstants(Date inProgressInstant, Date finalStateInstant) throws IllegalArgumentException {
        if (inProgressInstant != null) {
            if (this.status.equals((Object)TapeRecallStatus.IN_PROGRESS) || TapeRecallStatus.isFinalStatus(this.status.getStatusId())) {
                this.inProgressInstant = inProgressInstant;
            } else {
                log.error("Unable to force the in progress transition time-stamp, current status " + (Object)((Object)this.status) + " is not congruent");
            }
        }
        if (finalStateInstant != null) {
            if (TapeRecallStatus.isFinalStatus(this.status.getStatusId())) {
                this.finalStateInstant = finalStateInstant;
            } else {
                log.error("Unable to force the in final status transition time-stamp, current status " + (Object)((Object)this.status) + " is not final");
            }
        }
    }

    public void setFakeRequestToken() {
        String FAKE_PREFIX = "FAKE-";
        try {
            this.setRequestToken(new TRequestToken(FAKE_PREFIX.concat(UUID.randomUUID().toString().substring(FAKE_PREFIX.length())), Calendar.getInstance().getTime()));
        }
        catch (InvalidTRequestTokenAttributesException e) {
            log.error("Unexpected InvalidTRequestTokenAttributesException: " + e.getMessage());
        }
    }
}

