/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.model;

import it.grid.storm.persistence.model.InvalidRequestSummaryDataAttributesException;
import it.grid.storm.srm.types.TRequestToken;
import it.grid.storm.srm.types.TRequestType;

public class RequestSummaryTO {
    private TRequestToken requestToken = null;
    private TRequestType requestType = null;
    private int totalFilesInThisRequest = 0;
    private int numOfQueuedRequests = 0;
    private int numOfProgressingRequests = 0;
    private int numFinished = 0;
    private boolean isSuspended = false;

    public RequestSummaryTO(TRequestToken requestToken, TRequestType requestType, int totalFilesInThisRequest, int numOfQueuedRequests, int numOfProgressingRequests, int numFinished, boolean isSuspended) throws InvalidRequestSummaryDataAttributesException {
        boolean ok;
        boolean bl = ok = requestToken != null && requestType != null && totalFilesInThisRequest >= 0 && numOfQueuedRequests >= 0 && numOfProgressingRequests >= 0 && numFinished >= 0;
        if (!ok) {
            throw new InvalidRequestSummaryDataAttributesException(requestToken, requestType, totalFilesInThisRequest, numOfQueuedRequests, numOfProgressingRequests, numFinished);
        }
        this.requestToken = requestToken;
        this.requestType = requestType;
        this.totalFilesInThisRequest = totalFilesInThisRequest;
        this.numOfQueuedRequests = numOfQueuedRequests;
        this.numOfProgressingRequests = numOfProgressingRequests;
        this.numFinished = numFinished;
        this.isSuspended = isSuspended;
    }

    public TRequestToken requestToken() {
        return this.requestToken;
    }

    public TRequestType requestType() {
        return this.requestType;
    }

    public int totalFilesInThisRequest() {
        return this.totalFilesInThisRequest;
    }

    public int numOfQueuedRequests() {
        return this.numOfQueuedRequests;
    }

    public int numOfProgressingRequests() {
        return this.numOfProgressingRequests;
    }

    public int numFinished() {
        return this.numFinished;
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public void incNumOfQueuedRequests() {
        ++this.numOfQueuedRequests;
    }

    public void decNumOfQueuedRequests() {
        --this.numOfQueuedRequests;
    }

    public void incNumOfProgressingRequests() {
        ++this.numOfProgressingRequests;
    }

    public void decNumOfProgressingRequests() {
        --this.numOfProgressingRequests;
    }

    public void incTotalFilesInThisRequest() {
        ++this.totalFilesInThisRequest;
    }

    public void decTotalFilesInThisRequest() {
        --this.totalFilesInThisRequest;
    }

    public void incNumFinished() {
        ++this.numFinished;
    }

    public void decNumFinished() {
        --this.numFinished;
    }

    public void srmSuspend() {
        this.isSuspended = true;
    }

    public void srmUnSuspend() {
        this.isSuspended = false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SummaryRequestData");
        sb.append("; requestToken=");
        sb.append(this.requestToken);
        sb.append("; requestType=");
        sb.append((Object)this.requestType);
        sb.append("; totalFilesInThisRequest=");
        sb.append(this.totalFilesInThisRequest);
        sb.append("; numOfQueuedRequests=");
        sb.append(this.numOfQueuedRequests);
        sb.append("; numOfProgressingRequests=");
        sb.append(this.numOfProgressingRequests);
        sb.append("; numFinished=");
        sb.append(this.numFinished);
        sb.append("; isSuspended=");
        sb.append(this.isSuspended);
        sb.append(".");
        return sb.toString();
    }

    public int hashCode() {
        int hash = 17;
        hash = 37 * hash + this.requestToken.hashCode();
        hash = 37 * hash + this.requestType.hashCode();
        hash = 37 * hash + this.totalFilesInThisRequest;
        hash = 37 * hash + this.numOfQueuedRequests;
        hash = 37 * hash + this.numOfProgressingRequests;
        hash = 37 * hash + this.numFinished;
        hash = this.isSuspended ? 37 * hash + 1 : 37 * hash + 0;
        return hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestSummaryTO)) {
            return false;
        }
        RequestSummaryTO rsd = (RequestSummaryTO)o;
        return this.requestToken.equals(rsd.requestToken) && this.requestType.equals((Object)rsd.requestType) && this.totalFilesInThisRequest == rsd.totalFilesInThisRequest && this.numOfQueuedRequests == rsd.numOfQueuedRequests && this.numOfProgressingRequests == rsd.numOfProgressingRequests && this.numFinished == rsd.numFinished && this.isSuspended == rsd.isSuspended;
    }
}

