/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence.impl.mysql;

import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.persistence.PersistenceDirector;
import it.grid.storm.persistence.dao.AbstractDAO;
import it.grid.storm.persistence.dao.StorageSpaceDAO;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.model.StorageSpaceTO;
import it.grid.storm.persistence.util.helper.StorageSpaceSQLHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageSpaceDAOMySql
extends AbstractDAO
implements StorageSpaceDAO {
    private static final Logger log = LoggerFactory.getLogger(StorageSpaceDAOMySql.class);
    private StorageSpaceSQLHelper helper = new StorageSpaceSQLHelper(PersistenceDirector.getDataBase().getDbmsVendor());

    @Override
    public void addStorageSpace(StorageSpaceTO ss) throws DataAccessException {
        String query = this.helper.insertQuery(ss);
        log.debug("INSERT query = " + query);
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            int res = stat.executeUpdate(query);
            log.debug("INSERT result = " + res);
            if (res <= 0) {
                log.error("No row inserted for statement : " + query);
                throw new DataAccessException("No rows inserted for Storage Space");
            }
        }
        catch (SQLException ex) {
            log.error("Error while executing INSERT query", (Throwable)ex);
            throw new DataAccessException("Error while executing INSERT query", ex);
        }
        finally {
            this.releaseConnection(null, stat, conn);
        }
    }

    @Override
    public StorageSpaceTO getStorageSpaceById(Long ssId) throws DataAccessException {
        throw new DataAccessException("getStorageSpaceById: Unimplemented method!");
    }

    @Override
    public Collection<StorageSpaceTO> findAll() throws DataAccessException {
        throw new DataAccessException("findAll: Unimplemented method!");
    }

    @Override
    public Collection<StorageSpaceTO> getStorageSpaceByOwner(GridUserInterface owner, String spaceAlias) throws DataAccessException {
        ResultSet res;
        Statement stat;
        Connection conn;
        LinkedList<StorageSpaceTO> result;
        block6: {
            StorageSpaceTO ssTO = null;
            result = new LinkedList<StorageSpaceTO>();
            String query = this.helper.selectBySpaceAliasQuery(owner, spaceAlias);
            log.debug("DB query = " + query);
            conn = this.getConnection();
            stat = null;
            res = null;
            try {
                stat = this.getStatement(conn);
                res = stat.executeQuery(query);
                log.debug("query result = " + res);
                if (!res.first()) {
                    log.info("No rows found for query : " + query);
                    break block6;
                }
                do {
                    ssTO = this.helper.makeStorageSpaceTO(res);
                    result.add(ssTO);
                } while (res.next());
            }
            catch (SQLException e) {
                try {
                    log.error("Error while executing DB query", (Throwable)e);
                    throw new DataAccessException("Error while executing DB query", e);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(res, stat, conn);
                    throw throwable;
                }
            }
        }
        this.releaseConnection(res, stat, conn);
        return result;
    }

    @Override
    public Collection<StorageSpaceTO> getStorageSpaceBySpaceType(String stype) throws DataAccessException {
        Statement stat;
        ResultSet res;
        Connection conn;
        LinkedList<StorageSpaceTO> result;
        block6: {
            StorageSpaceTO ssTO = null;
            result = new LinkedList<StorageSpaceTO>();
            String query = this.helper.selectBySpaceType(stype);
            log.debug("DB query = " + query);
            conn = this.getConnection();
            res = null;
            stat = null;
            try {
                stat = this.getStatement(conn);
                res = stat.executeQuery(query);
                log.debug("query result = " + res);
                if (!res.first()) {
                    log.info("No rows found for query : " + query);
                    break block6;
                }
                do {
                    ssTO = this.helper.makeStorageSpaceTO(res);
                    result.add(ssTO);
                } while (res.next());
            }
            catch (SQLException e) {
                try {
                    log.error("Error while executing DB query", (Throwable)e);
                    throw new DataAccessException("Error while executing DB query", e);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(res, stat, conn);
                    throw throwable;
                }
            }
        }
        this.releaseConnection(res, stat, conn);
        return result;
    }

    @Override
    public Collection<StorageSpaceTO> getStorageSpaceByAliasOnly(String spaceAlias) throws DataAccessException {
        Statement stat;
        ResultSet res;
        Connection conn;
        LinkedList<StorageSpaceTO> result;
        block6: {
            StorageSpaceTO ssTO = null;
            result = new LinkedList<StorageSpaceTO>();
            String query = this.helper.selectBySpaceAliasOnlyQuery(spaceAlias);
            log.debug("DB query = " + query);
            conn = this.getConnection();
            res = null;
            stat = null;
            try {
                stat = this.getStatement(conn);
                res = stat.executeQuery(query);
                log.debug("query result = " + res);
                if (!res.first()) {
                    log.info("No rows found for query : " + query);
                    break block6;
                }
                do {
                    ssTO = this.helper.makeStorageSpaceTO(res);
                    result.add(ssTO);
                } while (res.next());
            }
            catch (SQLException e) {
                try {
                    log.error("Error while executing DB query", (Throwable)e);
                    throw new DataAccessException("Error while executing DB query", e);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(res, stat, conn);
                    throw throwable;
                }
            }
        }
        this.releaseConnection(res, stat, conn);
        return result;
    }

    @Override
    public StorageSpaceTO getStorageSpaceByToken(String token) throws DataAccessException {
        Statement stat;
        ResultSet res;
        Connection conn;
        StorageSpaceTO ssTO;
        block5: {
            ssTO = null;
            String query = this.helper.selectByTokenQuery(token);
            log.debug("SELECT query = " + query);
            conn = this.getConnection();
            res = null;
            stat = null;
            try {
                stat = this.getStatement(conn);
                res = stat.executeQuery(query);
                log.debug("SELECT result = " + res);
                if (!res.first()) {
                    log.info("No rows found for query : " + query);
                    break block5;
                }
                ssTO = this.helper.makeStorageSpaceTO(res);
            }
            catch (SQLException ex) {
                try {
                    log.error("Error while executing SELECT query", (Throwable)ex);
                    throw new DataAccessException("Error while executing INSERT query", ex);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(res, stat, conn);
                    throw throwable;
                }
            }
        }
        this.releaseConnection(res, stat, conn);
        return ssTO;
    }

    @Override
    public Collection<StorageSpaceTO> getStorageSpaceByUnavailableUsedSpace(long unavailableSizeValue) throws DataAccessException {
        Statement stat;
        ResultSet res;
        Connection conn;
        LinkedList<StorageSpaceTO> result;
        block6: {
            StorageSpaceTO ssTO = null;
            result = new LinkedList<StorageSpaceTO>();
            String query = this.helper.selectByUnavailableUsedSpaceSizeQuery(unavailableSizeValue);
            log.debug("SELECT query = " + query);
            conn = this.getConnection();
            res = null;
            stat = null;
            try {
                stat = this.getStatement(conn);
                res = stat.executeQuery(query);
                log.debug("SELECT result = " + res);
                if (!res.first()) {
                    log.info("No rows found for query : " + query);
                    break block6;
                }
                do {
                    ssTO = this.helper.makeStorageSpaceTO(res);
                    result.add(ssTO);
                } while (res.next());
            }
            catch (SQLException ex) {
                try {
                    log.error("Error while executing SELECT query", (Throwable)ex);
                    throw new DataAccessException("Error while executing INSERT query", ex);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(res, stat, conn);
                    throw throwable;
                }
            }
        }
        this.releaseConnection(res, stat, conn);
        return result;
    }

    @Override
    public Collection<StorageSpaceTO> getStorageSpaceByPreviousLastUpdate(Date lastUpdateTimestamp) throws DataAccessException {
        Statement stat;
        ResultSet res;
        Connection conn;
        LinkedList<StorageSpaceTO> result;
        block6: {
            StorageSpaceTO ssTO = null;
            result = new LinkedList<StorageSpaceTO>();
            String query = this.helper.selectByPreviousOrNullLastUpdateQuery(lastUpdateTimestamp.getTime());
            log.debug("SELECT query = " + query);
            conn = this.getConnection();
            res = null;
            stat = null;
            try {
                stat = this.getStatement(conn);
                res = stat.executeQuery(query);
                log.debug("SELECT result = " + res);
                if (!res.first()) {
                    log.info("No rows found for query : " + query);
                    break block6;
                }
                do {
                    ssTO = this.helper.makeStorageSpaceTO(res);
                    result.add(ssTO);
                } while (res.next());
            }
            catch (SQLException ex) {
                try {
                    log.error("Error while executing SELECT query", (Throwable)ex);
                    throw new DataAccessException("Error while executing INSERT query", ex);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(res, stat, conn);
                    throw throwable;
                }
            }
        }
        this.releaseConnection(res, stat, conn);
        return result;
    }

    @Override
    public void removeStorageSpace(GridUserInterface user, String spaceToken) throws DataAccessException {
        String query = this.helper.removeByTokenQuery(user, spaceToken);
        log.debug("query = " + query);
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            int res = stat.executeUpdate(query);
            log.debug("Number of rows removed: " + res);
            if (res <= 0) {
                log.error("Unable to remove Storage Space with token = '" + spaceToken + "' for user '" + user.getDn() + "' not found!");
                throw new DataAccessException("Storage Space with token = '" + spaceToken + "' for user '" + user.getDn() + "' not found!");
            }
        }
        catch (SQLException ex) {
            log.error("Error while executing DELETE query", (Throwable)ex);
            throw new DataAccessException("Error while executing DELETE query", ex);
        }
        finally {
            this.releaseConnection(null, stat, conn);
        }
    }

    @Override
    public void removeStorageSpace(String spaceToken) throws DataAccessException {
        String query = this.helper.removeByTokenQuery(spaceToken);
        log.debug("query = " + query);
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            int res = stat.executeUpdate(query);
            log.debug("Number of rows removed: " + res);
            if (res <= 0) {
                log.error("Unable to remove Storage Space with token = '" + spaceToken + "' not found!");
                throw new DataAccessException("Storage Space with token = '" + spaceToken + "' not found!");
            }
        }
        catch (SQLException ex) {
            log.error("Error while executing DELETE query", (Throwable)ex);
            throw new DataAccessException("Error while executing DELETE query", ex);
        }
        finally {
            this.releaseConnection(null, stat, conn);
        }
    }

    @Override
    public void updateStorageSpace(StorageSpaceTO ssTO) throws DataAccessException {
        String query = this.helper.updateByAliasAndTokenQuery(ssTO);
        log.debug("UPDATE query = " + query);
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            int res = stat.executeUpdate(query);
            log.debug("UPDATE row count = " + res);
            if (res != 1) {
                if (res < 1) {
                    log.error("No storage space rows updated by query : " + query);
                } else {
                    log.warn("More than a single storage space rows updated by query : " + query + " updated " + res + " rows");
                }
            }
        }
        catch (SQLException ex) {
            log.error("Error while executing UPDATE query", (Throwable)ex);
            throw new DataAccessException("Error while executing UPDATE query", ex);
        }
        finally {
            this.releaseConnection(null, stat, conn);
        }
    }

    @Override
    public void updateStorageSpaceFreeSpace(StorageSpaceTO ssTO) throws DataAccessException {
        long freeSpace = ssTO.getFreeSize();
        String query = this.helper.updateFreeSpaceByTokenQuery(ssTO.getSpaceToken(), freeSpace, new Date());
        log.debug("UPDATE query = " + query);
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            int res = stat.executeUpdate(query);
            log.debug("UPDATE row count = " + res);
            if (res <= 0) {
                log.error("No storage space rows updated by query : " + query);
            }
        }
        catch (SQLException ex) {
            log.error("Error while executing UPDATE query", (Throwable)ex);
            throw new DataAccessException("Error while executing UPDATE query", ex);
        }
        finally {
            this.releaseConnection(null, stat, conn);
        }
    }

    @Override
    public void updateAllStorageSpace(StorageSpaceTO ssTO) throws DataAccessException {
        String query = this.helper.updateByTokenQuery(ssTO);
        log.debug("UPDATE query = " + query);
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            int res = stat.executeUpdate(query);
            log.debug("UPDATE row count = " + res);
            if (res != 1) {
                if (res < 1) {
                    log.error("No storage space rows updated by query : " + query);
                } else {
                    log.warn("More than a single storage space rows updated by query : " + query + " updated " + res + " rows");
                }
            }
        }
        catch (SQLException ex) {
            log.error("Error while executing UPDATE query", (Throwable)ex);
            throw new DataAccessException("Error while executing UPDATE query", ex);
        }
        finally {
            this.releaseConnection(null, stat, conn);
        }
    }

    @Override
    public Collection<StorageSpaceTO> getExpired(long currentTimeInSecond) throws DataAccessException {
        StorageSpaceTO ssTO = null;
        LinkedList<StorageSpaceTO> result = new LinkedList<StorageSpaceTO>();
        String query = this.helper.selectExpiredQuery(currentTimeInSecond);
        log.debug("DB query = " + query);
        Connection conn = this.getConnection();
        ResultSet res = null;
        Statement stat = null;
        try {
            stat = this.getStatement(conn);
            res = stat.executeQuery(query);
            log.debug("query result = " + res);
            if (!res.first()) {
                log.info("No rows found for query : " + query);
                throw new DataAccessException("No storage space expired found at time " + currentTimeInSecond);
            }
            do {
                ssTO = this.helper.makeStorageSpaceTO(res);
                result.add(ssTO);
            } while (res.next());
        }
        catch (SQLException e) {
            try {
                log.error("Error while executing DB query", (Throwable)e);
                throw new DataAccessException("Error while executing DB query", e);
            }
            catch (Throwable throwable) {
                this.releaseConnection(res, stat, conn);
                throw throwable;
            }
        }
        this.releaseConnection(res, stat, conn);
        return result;
    }
}

