/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.persistence;

import it.grid.storm.config.Configuration;
import it.grid.storm.persistence.DAOFactory;
import it.grid.storm.persistence.DataSourceConnectionFactory;
import it.grid.storm.persistence.dao.CopyChunkDAO;
import it.grid.storm.persistence.dao.PermissionDAO;
import it.grid.storm.persistence.dao.PtGChunkDAO;
import it.grid.storm.persistence.dao.PtPChunkDAO;
import it.grid.storm.persistence.dao.RequestSummaryDAO;
import it.grid.storm.persistence.dao.StorageAreaDAO;
import it.grid.storm.persistence.dao.StorageSpaceDAO;
import it.grid.storm.persistence.dao.TapeRecallDAO;
import it.grid.storm.persistence.exceptions.DataAccessException;
import it.grid.storm.persistence.exceptions.PersistenceException;
import it.grid.storm.persistence.impl.mysql.StorageSpaceDAOMySql;
import it.grid.storm.persistence.impl.mysql.TapeRecallDAOMySql;
import it.grid.storm.persistence.util.db.DBConnection;
import it.grid.storm.persistence.util.db.DBConnectionPool;
import it.grid.storm.persistence.util.db.DataBaseStrategy;
import it.grid.storm.tape.recalltable.persistence.TapeRecallDAOProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDAOFactory
implements DAOFactory {
    public static final String factoryName = "JDBC - MySQL DAO Factory";
    private static final Logger log = LoggerFactory.getLogger(MySqlDAOFactory.class);
    private static final DataBaseStrategy datasource = DataBaseStrategy.MYSQL;
    private static DataSourceConnectionFactory connFactory = null;
    private static MySqlDAOFactory factory = new MySqlDAOFactory();

    private MySqlDAOFactory() {
        log.info("Choose JDBC - MySQL DAO Factory");
    }

    public static MySqlDAOFactory getInstance() {
        return factory;
    }

    private static void initializeDataSource() {
        Configuration config = Configuration.getInstance();
        datasource.setDbUrl(config.getBEPersistenceDBMSUrl());
        datasource.setDbName(config.getBEPersistenceDBName());
        datasource.setDbUsr(config.getBEPersistenceDBUserName());
        datasource.setDbPwd(config.getBEPersistenceDBPassword());
        boolean pool = config.getBEPersistencePoolDB();
        if (pool) {
            int maxActive = config.getBEPersistencePoolDBMaxActive();
            int maxWait = config.getBEPersistencePoolDBMaxWait();
            try {
                DBConnectionPool.initPool(datasource, maxActive, maxWait);
            }
            catch (PersistenceException ex) {
                log.error("Exception while setting up Pool", (Throwable)ex);
            }
            connFactory = DBConnectionPool.getPoolInstance();
        } else {
            try {
                connFactory = new DBConnection(datasource);
            }
            catch (PersistenceException ex1) {
                log.error("Exception while setting up DB connection", (Throwable)ex1);
            }
        }
        log.debug("RECALL TABLE Catalog/DAO ");
    }

    @Override
    public StorageSpaceDAO getStorageSpaceDAO() throws DataAccessException {
        return new StorageSpaceDAOMySql();
    }

    @Override
    public TapeRecallDAO getTapeRecallDAO() {
        return new TapeRecallDAOMySql();
    }

    public String toString() {
        return factoryName;
    }

    @Override
    public CopyChunkDAO getCopyChunkDAO() throws DataAccessException {
        return null;
    }

    @Override
    public PermissionDAO getPermissionDAO() throws DataAccessException {
        return null;
    }

    @Override
    public PtGChunkDAO getPtGChunkDAO() throws DataAccessException {
        return null;
    }

    @Override
    public PtPChunkDAO getPtPChunkDAO() throws DataAccessException {
        return null;
    }

    @Override
    public RequestSummaryDAO getRequestSummaryDAO() throws DataAccessException {
        return null;
    }

    @Override
    public StorageAreaDAO getStorageAreaDAO() throws DataAccessException {
        return null;
    }

    @Override
    public TapeRecallDAO getTapeRecallDAO(boolean test) throws DataAccessException {
        if (!test) {
            return new TapeRecallDAOMySql();
        }
        return new TapeRecallDAOProperties(test);
    }

    static {
        MySqlDAOFactory.initializeDataSource();
    }
}

