/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.namespace.model.Authority;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.naming.NamingConst;

public class TransportProtocol {
    private int protocolID = -1;
    private Protocol protocol = null;
    private Authority service = null;

    public TransportProtocol(Protocol protocol, Authority service) {
        this.protocol = protocol;
        this.service = service;
    }

    public TransportProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocolID(int id) {
        this.protocolID = id;
    }

    public int getProtocolID() {
        return this.protocolID;
    }

    public Authority getAuthority() {
        if (this.protocol.equals(Protocol.FILE)) {
            return Authority.EMPTY;
        }
        return this.service;
    }

    public void setLocalAuthority() {
        if (!this.protocol.equals(Protocol.FILE)) {
            this.service = new Authority(NamingConst.getServiceDefaultHost());
        }
    }

    public void setAuthority(Authority service) {
        this.service = service;
    }

    private String getURIRoot() {
        StringBuffer sb = new StringBuffer();
        if (this.protocolID != -1) {
            sb.append("[id:" + this.protocolID + "] ");
        }
        sb.append(this.protocol.getSchema());
        sb.append("://");
        if (this.service != null) {
            sb.append(this.service);
        }
        return sb.toString();
    }

    public String toString() {
        return this.getURIRoot();
    }

    public boolean equals(Object other) {
        TransportProtocol otherTP;
        boolean result = false;
        if (other instanceof TransportProtocol && (otherTP = (TransportProtocol)other).getProtocol().equals(this.getProtocol()) && otherTP.getAuthority().equals(this.getAuthority())) {
            result = true;
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.protocolID;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        result = 31 * result + (this.service == null ? 0 : this.service.hashCode());
        return result;
    }
}

