/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.PropertyInterface;
import it.grid.storm.namespace.model.AccessLatency;
import it.grid.storm.namespace.model.ExpirationMode;
import it.grid.storm.namespace.model.RetentionPolicy;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TSizeInBytes;
import org.slf4j.Logger;

public class Property
implements PropertyInterface {
    private Logger log = NamespaceDirector.getLogger();
    private TSizeInBytes totalOnlineSize = TSizeInBytes.makeEmpty();
    private TSizeInBytes totalNearlineSize = TSizeInBytes.makeEmpty();
    private RetentionPolicy retentionPolicy = RetentionPolicy.UNKNOWN;
    private ExpirationMode expirationMode = ExpirationMode.UNKNOWN;
    private AccessLatency accessLatency = AccessLatency.UNKNOWN;
    private boolean hasLimitedSize = false;

    @Override
    public TSizeInBytes getTotalOnlineSize() {
        return this.totalOnlineSize;
    }

    @Override
    public TSizeInBytes getTotalNearlineSize() {
        return this.totalNearlineSize;
    }

    @Override
    public RetentionPolicy getRetentionPolicy() {
        return this.retentionPolicy;
    }

    @Override
    public ExpirationMode getExpirationMode() {
        return this.expirationMode;
    }

    @Override
    public AccessLatency getAccessLatency() {
        return this.accessLatency;
    }

    public void setTotalOnlineSize(String unitType, long onlineSize) throws NamespaceException {
        try {
            this.totalOnlineSize = SizeUnitType.getInBytes(unitType, onlineSize);
        }
        catch (InvalidTSizeAttributesException ex1) {
            this.log.error("TotalOnlineSize parameter is wrong ");
            throw new NamespaceException("'TotalOnlineSize' invalid argument in Namespace configuration.", ex1);
        }
    }

    public void setTotalNearlineSize(String unitType, long nearlineSize) throws NamespaceException {
        try {
            this.totalNearlineSize = SizeUnitType.getInBytes(unitType, nearlineSize);
        }
        catch (InvalidTSizeAttributesException ex1) {
            this.log.error("TotalOnlineSize parameter is wrong ");
            throw new NamespaceException("'TotalOnlineSize' invalid argument in Namespace configuration.", ex1);
        }
    }

    public void setRetentionPolicy(String retentionPolicy) throws NamespaceException {
        this.retentionPolicy = RetentionPolicy.getRetentionPolicy(retentionPolicy);
    }

    public void setAccessLatency(String accessLatency) throws NamespaceException {
        this.accessLatency = AccessLatency.getAccessLatency(accessLatency);
    }

    public void setExpirationMode(String expirationMode) throws NamespaceException {
        this.expirationMode = ExpirationMode.getExpirationMode(expirationMode);
    }

    public void setLimitedSize(boolean limitedSize) throws NamespaceException {
        this.hasLimitedSize = limitedSize;
    }

    @Override
    public boolean isOnlineSpaceLimited() {
        return this.hasLimitedSize;
    }

    public static class SizeUnitType {
        private Logger log = NamespaceDirector.getLogger();
        private String sizeTypeName;
        private int ordinal;
        private long size;
        public static final SizeUnitType BYTE = new SizeUnitType("Byte", 0, 1L);
        public static final SizeUnitType KB = new SizeUnitType("KB", 1, 1000L);
        public static final SizeUnitType MB = new SizeUnitType("MB", 2, 1000000L);
        public static final SizeUnitType GB = new SizeUnitType("GB", 3, 1000000000L);
        public static final SizeUnitType TB = new SizeUnitType("TB", 4, 1000000000000L);
        public static final SizeUnitType UNKNOWN = new SizeUnitType("UNKNOWN", -1, -1L);

        private SizeUnitType(String sizeTypeName, int ordinal, long size) {
            this.sizeTypeName = sizeTypeName;
            this.size = size;
            this.ordinal = ordinal;
        }

        public String getTypeName() {
            return this.sizeTypeName;
        }

        private static SizeUnitType makeUnitType(String unitType) {
            SizeUnitType result = UNKNOWN;
            if (unitType.equals(SizeUnitType.BYTE.sizeTypeName)) {
                result = BYTE;
            }
            if (unitType.equals(SizeUnitType.KB.sizeTypeName)) {
                result = KB;
            }
            if (unitType.equals(SizeUnitType.MB.sizeTypeName)) {
                result = MB;
            }
            if (unitType.equals(SizeUnitType.GB.sizeTypeName)) {
                result = GB;
            }
            if (unitType.equals(SizeUnitType.TB.sizeTypeName)) {
                result = TB;
            }
            return result;
        }

        public static TSizeInBytes getInBytes(String unitType, long value) throws InvalidTSizeAttributesException {
            TSizeInBytes result = TSizeInBytes.makeEmpty();
            SizeUnitType sizeUnitType = SizeUnitType.makeUnitType(unitType);
            if (!sizeUnitType.getTypeName().equals(UNKNOWN.getTypeName())) {
                result = TSizeInBytes.make(value * sizeUnitType.size, SizeUnit.BYTES);
            }
            return result;
        }

        public TSizeInBytes getInBytes() {
            TSizeInBytes result = TSizeInBytes.makeEmpty();
            try {
                result = TSizeInBytes.make(this.size, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex) {
                this.log.error("Size '" + this.size + "'are invalid. Use empty size: '" + result + "'." + ex);
            }
            return result;
        }
    }
}

