/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

public class FilePermissionType {
    private int ordinalNumber;
    private String permissionType;
    private String permissionString;
    public static final FilePermissionType READ = new FilePermissionType("READ", "R", 0);
    public static final FilePermissionType READWRITE = new FilePermissionType("READWRITE", "RW", 1);
    public static final FilePermissionType WRITE = new FilePermissionType("WRITE", "W", 2);
    public static final FilePermissionType UNKNOWN = new FilePermissionType("UNKNOWN", "Permission Type UNKNOWN!", -1);

    private FilePermissionType(String permissionType, String permissionString, int ord) {
        this.permissionType = permissionType;
        this.permissionString = permissionString;
        this.ordinalNumber = ord;
    }

    public int getOrdinalNumber() {
        return this.ordinalNumber;
    }

    public String getPermissionString() {
        return this.permissionString;
    }

    public static FilePermissionType getFilePermissionType(String permission) {
        if (permission.equals(READ.getPermissionString())) {
            return READ;
        }
        if (permission.equals(READWRITE.getPermissionString())) {
            return READWRITE;
        }
        if (permission.equals(WRITE.getPermissionString())) {
            return WRITE;
        }
        return UNKNOWN;
    }

    public static FilePermissionType getFilePermissionType(int filetypeOrd) {
        if (filetypeOrd == 0) {
            return READ;
        }
        if (filetypeOrd == 1) {
            return READWRITE;
        }
        if (filetypeOrd == 2) {
            return WRITE;
        }
        return UNKNOWN;
    }

    public int hashCode() {
        return this.ordinalNumber;
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other instanceof FilePermissionType) {
            FilePermissionType ft = (FilePermissionType)other;
            if (ft.ordinalNumber == this.ordinalNumber) {
                result = true;
            }
        }
        return result;
    }

    public String toString() {
        return this.permissionType;
    }
}

