/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.common.types.SizeUnit;
import it.grid.storm.common.types.TimeUnit;
import it.grid.storm.namespace.DefaultValuesInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.srm.types.InvalidTSizeAttributesException;
import it.grid.storm.srm.types.TFileStorageType;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceType;
import org.slf4j.Logger;

public class DefaultValues
implements DefaultValuesInterface {
    private Logger log = NamespaceDirector.getLogger();
    private SpaceDefault spaceDefault;
    private FileDefault fileDefault;

    public DefaultValues(SpaceDefault spaceDefault, FileDefault fileDefault) {
        this.spaceDefault = spaceDefault;
        this.fileDefault = fileDefault;
    }

    public DefaultValues() {
        try {
            this.spaceDefault = new SpaceDefault();
        }
        catch (NamespaceException ex) {
            this.log.error("Something was wrong building default Space Default Values");
        }
        try {
            this.fileDefault = new FileDefault();
        }
        catch (NamespaceException ex1) {
            this.log.error("Something was wrong building default File Default Values");
        }
    }

    public void setSpaceDefaults(String type, long lifetime, long guarsize, long totalsize) throws NamespaceException {
        this.spaceDefault = new SpaceDefault(type, lifetime, guarsize, totalsize);
    }

    public void setFileDefaults(String type, long lifetime) throws NamespaceException {
        this.fileDefault = new FileDefault(type, lifetime);
    }

    @Override
    public TLifeTimeInSeconds getDefaultSpaceLifetime() {
        return this.spaceDefault.lifetime;
    }

    @Override
    public TSpaceType getDefaultSpaceType() {
        return this.spaceDefault.type;
    }

    @Override
    public TSizeInBytes getDefaultGuaranteedSpaceSize() {
        return this.spaceDefault.guarsize;
    }

    @Override
    public TSizeInBytes getDefaultTotalSpaceSize() {
        return this.spaceDefault.totalsize;
    }

    @Override
    public TLifeTimeInSeconds getDefaultFileLifeTime() {
        return this.fileDefault.lifetime;
    }

    @Override
    public TFileStorageType getDefaultFileType() {
        return this.fileDefault.type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        sb.append("   DEF. Space Lifetime       : " + this.getDefaultSpaceLifetime() + sep);
        sb.append("   DEF. Space Guar. size     : " + this.getDefaultGuaranteedSpaceSize() + sep);
        sb.append("   DEF. Space Tot. size      : " + this.getDefaultTotalSpaceSize() + sep);
        sb.append("   DEF. Space Type           : " + this.getDefaultSpaceType() + sep);
        sb.append("   DEF. File Lifetime        : " + this.getDefaultFileLifeTime() + sep);
        sb.append("   DEF. File Type            : " + this.getDefaultFileType() + sep);
        return sb.toString();
    }

    public class FileDefault {
        private TFileStorageType type = null;
        private TLifeTimeInSeconds lifetime;

        public FileDefault() throws NamespaceException {
            this.type = TFileStorageType.getTFileStorageType("permament");
            try {
                this.lifetime = TLifeTimeInSeconds.make(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException ex) {
                DefaultValues.this.log.error(" Default Space Lifetime was wrong ");
                throw new NamespaceException("Space Lifetime invalid argument in Namespace configuration.", ex);
            }
        }

        public FileDefault(String type, long lifetime) throws NamespaceException {
            this.type = TFileStorageType.getTFileStorageType(type);
            try {
                this.lifetime = TLifeTimeInSeconds.make(lifetime, TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException ex) {
                DefaultValues.this.log.error(" Default Space Lifetime was wrong ");
                throw new NamespaceException("Space Lifetime invalid argument in Namespace configuration.", ex);
            }
        }

        public TFileStorageType getFileStorageType() {
            return this.type;
        }

        public TLifeTimeInSeconds getLifetime() {
            return this.lifetime;
        }
    }

    public class SpaceDefault {
        private TSpaceType type = null;
        private TLifeTimeInSeconds lifetime;
        private TSizeInBytes guarsize;
        private TSizeInBytes totalsize;

        public SpaceDefault() throws NamespaceException {
            this.type = TSpaceType.getTSpaceType("permament");
            try {
                this.lifetime = TLifeTimeInSeconds.make(Integer.MAX_VALUE, TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException ex) {
                DefaultValues.this.log.error(" Default Space Lifetime was wrong ");
                throw new NamespaceException("Space Lifetime invalid argument in Namespace configuration.", ex);
            }
            try {
                this.guarsize = TSizeInBytes.make(Integer.MAX_VALUE, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex1) {
                DefaultValues.this.log.error(" Default  Guaranteed Space Size was wrong ");
                throw new NamespaceException(" Guaranteed Space Size invalid argument in Namespace configuration.", ex1);
            }
            try {
                this.totalsize = TSizeInBytes.make(Integer.MAX_VALUE, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex2) {
                DefaultValues.this.log.error(" Default Total Space Size was wrong ");
                throw new NamespaceException("Total Space Size invalid argument in Namespace configuration.", ex2);
            }
        }

        public SpaceDefault(String type, long lifetime, long guarsize, long totalsize) throws NamespaceException {
            this.type = TSpaceType.getTSpaceType(type);
            try {
                this.lifetime = TLifeTimeInSeconds.make(lifetime, TimeUnit.SECONDS);
            }
            catch (IllegalArgumentException ex) {
                DefaultValues.this.log.error(" Default Space Lifetime was wrong ");
                throw new NamespaceException("Space Lifetime invalid argument in Namespace configuration.", ex);
            }
            if (guarsize > totalsize) {
                DefaultValues.this.log.error(" Default Space Guaranteed Size is greater of Space Total Size !");
                throw new NamespaceException("Space size (Guar and Total) are invalid in Namespace configuration.");
            }
            try {
                this.guarsize = TSizeInBytes.make(guarsize, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex1) {
                DefaultValues.this.log.error(" Default  Guaranteed Space Size was wrong ");
                throw new NamespaceException(" Guaranteed Space Size invalid argument in Namespace configuration.", ex1);
            }
            try {
                this.totalsize = TSizeInBytes.make(totalsize, SizeUnit.BYTES);
            }
            catch (InvalidTSizeAttributesException ex2) {
                DefaultValues.this.log.error(" Default Total Space Size was wrong ");
                throw new NamespaceException("Total Space Size invalid argument in Namespace configuration.", ex2);
            }
        }

        public TSpaceType getSpaceType() {
            return this.type;
        }

        public TLifeTimeInSeconds getLifetime() {
            return this.lifetime;
        }

        public TSizeInBytes guarsize() {
            return this.guarsize;
        }

        public TSizeInBytes totalsize() {
            return this.totalsize;
        }
    }
}

