/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.griduser.AbstractGridUser;
import it.grid.storm.griduser.DistinguishedName;
import it.grid.storm.griduser.GridUserInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.SubjectRules;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;

public class ApproachableRule
implements Comparable {
    private Logger log = NamespaceDirector.getLogger();
    private final String ruleName;
    private final SubjectRules subjectRules;
    private String relativePath = null;
    private LinkedList<VirtualFSInterface> appFS = new LinkedList();
    private final boolean anonymousHttpReadAccess;

    public ApproachableRule(String rulename, SubjectRules subjectRules, String relativePath, boolean anonymousHttpReadAccess) {
        this.ruleName = rulename;
        this.subjectRules = subjectRules;
        this.relativePath = relativePath;
        this.anonymousHttpReadAccess = anonymousHttpReadAccess;
    }

    public ApproachableRule(String rulename, SubjectRules subjectRules, String relativePath) {
        this.ruleName = rulename;
        this.subjectRules = subjectRules;
        this.relativePath = relativePath;
        this.anonymousHttpReadAccess = false;
    }

    public boolean isAdmitAll() {
        return this.subjectRules.getDNMatchingRule().isMatchAll() && this.subjectRules.getVONameMatchingRule().isMatchAll();
    }

    public void addApproachableVFS(VirtualFSInterface vfs) {
        this.appFS.add(vfs);
    }

    public List<VirtualFSInterface> getApproachableVFS() {
        return this.appFS;
    }

    public String getSpaceRelativePath() {
        return this.relativePath;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public boolean getAnonymousHttpReadAccess() {
        return this.anonymousHttpReadAccess;
    }

    public SubjectRules getSubjectRules() {
        return this.subjectRules;
    }

    public boolean match(GridUserInterface gUser) {
        return this.matchDN(gUser.getDn()) && this.matchVoms(gUser);
    }

    private boolean matchVoms(GridUserInterface gUser) {
        if (this.subjectRules.getVONameMatchingRule().isMatchAll()) {
            return true;
        }
        if (gUser instanceof AbstractGridUser && ((AbstractGridUser)gUser).hasVoms()) {
            this.log.debug("Grid User Requestor   : " + ((AbstractGridUser)gUser).toString());
            if (this.subjectRules.getVONameMatchingRule().match(((AbstractGridUser)gUser).getVO().getValue())) {
                return true;
            }
        }
        return false;
    }

    private boolean matchDN(String dnString) {
        if (dnString == null) {
            return this.subjectRules.getDNMatchingRule().isMatchAll();
        }
        DistinguishedName dn = new DistinguishedName(dnString);
        return this.subjectRules.getDNMatchingRule().match(dn);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("line.separator");
        sb.append(sep + "  --- APPROACHABLE RULE NAME ---" + sep);
        sb.append("   Approachable Rule Name : " + this.ruleName + sep);
        sb.append("     SUBJECT - dn         : " + this.getSubjectRules().getDNMatchingRule() + sep);
        if (!this.getSubjectRules().getVONameMatchingRule().isMatchAll()) {
            sb.append("     -- VOMS cert IS MANDATORY!" + sep);
            sb.append("       -- SUBJECT - vo_name    : " + this.getSubjectRules().getVONameMatchingRule() + sep);
        } else {
            sb.append("     -- VOMS cert is not mandatory" + sep);
        }
        sb.append("     Relative-Path for Space : " + this.getSpaceRelativePath() + sep);
        sb.append("     Approachable VFS        : " + this.appFS + sep);
        return sb.toString();
    }

    public int compareTo(Object o) {
        int result = 1;
        if (o instanceof ApproachableRule) {
            ApproachableRule other = (ApproachableRule)o;
            result = this.getRuleName().compareTo(other.getRuleName());
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.appFS == null ? 0 : this.appFS.hashCode());
        result = 31 * result + (this.log == null ? 0 : this.log.hashCode());
        result = 31 * result + (this.relativePath == null ? 0 : this.relativePath.hashCode());
        result = 31 * result + (this.ruleName == null ? 0 : this.ruleName.hashCode());
        result = 31 * result + (this.subjectRules == null ? 0 : this.subjectRules.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApproachableRule other = (ApproachableRule)obj;
        if (this.appFS == null ? other.appFS != null : !this.appFS.equals(other.appFS)) {
            return false;
        }
        if (this.log == null ? other.log != null : !this.log.equals(other.log)) {
            return false;
        }
        if (this.relativePath == null ? other.relativePath != null : !this.relativePath.equals(other.relativePath)) {
            return false;
        }
        if (this.ruleName == null ? other.ruleName != null : !this.ruleName.equals(other.ruleName)) {
            return false;
        }
        return !(this.subjectRules == null ? other.subjectRules != null : !this.subjectRules.equals(other.subjectRules));
    }
}

