/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.model;

import it.grid.storm.filesystem.FilesystemPermission;
import it.grid.storm.namespace.model.FilePermissionType;
import it.grid.storm.namespace.model.PermissionException;
import it.grid.storm.namespace.util.userinfo.LocalGroups;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLEntry {
    private static final Logger LOG = LoggerFactory.getLogger(ACLEntry.class);
    private final String groupName;
    private int groupId = -1;
    private final FilePermissionType permission;

    public ACLEntry(String groupName, String permissionString) throws PermissionException {
        this.permission = FilePermissionType.getFilePermissionType(permissionString);
        if (this.permission.equals(FilePermissionType.UNKNOWN)) {
            LOG.error("Unble to understand permission '" + permissionString + "'");
            throw new PermissionException("Unble to understand permission '" + permissionString + "'");
        }
        this.groupName = groupName;
        boolean isDefined = LocalGroups.getInstance().isGroupDefined(groupName);
        if (!isDefined) {
            throw new PermissionException("The groupName '" + groupName + "' does not exist!");
        }
        LOG.debug("Checking if groupName '" + groupName + "' is defined: " + isDefined);
        this.groupId = LocalGroups.getInstance().getGroupId(groupName);
        LOG.debug("GroupID of '" + groupName + "' = " + this.groupId);
    }

    public boolean isValid() {
        boolean result = false;
        boolean isDefined = LocalGroups.getInstance().isGroupDefined(this.groupName);
        if (!isDefined) {
            LOG.error("The groupName '" + this.groupName + "' does not exist!");
            result = false;
        } else {
            LOG.debug("Checking if groupName '" + this.groupName + "' is defined: " + isDefined);
            this.groupId = LocalGroups.getInstance().getGroupId(this.groupName);
            LOG.debug("GroupID of '" + this.groupName + "' = " + this.groupId);
            result = true;
        }
        return result;
    }

    public int getGroupID() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getFilePermissionString() {
        return this.permission.getPermissionString();
    }

    public FilesystemPermission getFilesystemPermission() {
        switch (this.permission.getOrdinalNumber()) {
            case 0: {
                return FilesystemPermission.Read;
            }
            case 1: {
                return FilesystemPermission.ReadWrite;
            }
            case 2: {
                return FilesystemPermission.Write;
            }
        }
        return FilesystemPermission.Read;
    }

    public String toString() {
        return "group: " + this.groupId + " (" + this.groupName + ")" + " permission: " + this.permission;
    }
}

