/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.config.xml;

import java.io.File;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLReloadingStrategy
extends FileChangedReloadingStrategy {
    private boolean notifing = false;
    private Logger log = LoggerFactory.getLogger(XMLReloadingStrategy.class);
    private boolean verbosity;
    private long reloadingTime;

    public void setVerbosity(boolean verbosity) {
        this.verbosity = verbosity;
    }

    protected void notifingPerformed() {
        this.notifing = false;
    }

    protected boolean notifingRequired() {
        return this.notifing;
    }

    protected void notifyNeeded() {
        this.notifing = true;
    }

    public boolean reloadingRequired() {
        boolean reloading = false;
        long now = System.currentTimeMillis();
        if (now > this.lastChecked + this.refreshDelay) {
            this.lastChecked = now;
            if (this.hasChanged()) {
                reloading = true;
            }
        }
        if (this.verbosity) {
            this.log.debug(" ...RELOADING REQUIRED? " + reloading);
        }
        return reloading;
    }

    public void reloadingPerformed() {
        this.updateLastModified();
        this.reloadingTime = System.currentTimeMillis();
    }

    protected boolean hasChanged() {
        boolean result;
        File file = this.getConfigurationFile();
        if (file == null || !file.exists()) {
            return false;
        }
        boolean bl = result = file.lastModified() > this.lastModified;
        if (result) {
            this.notifyNeeded();
            this.log.debug(" <<<<<  Namespace Configuration is CHANGED ---> Notify needed..");
        }
        return result;
    }

    public File getConfigurationFile() {
        return this.configuration.getFile();
    }

    public long getLastReload() {
        return this.reloadingTime;
    }
}

