/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.config.xml;

import it.grid.storm.balancer.BalancingStrategyType;
import it.grid.storm.namespace.CapabilityInterface;
import it.grid.storm.namespace.DefaultValuesInterface;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.PropertyInterface;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.config.NamespaceCheck;
import it.grid.storm.namespace.config.NamespaceLoader;
import it.grid.storm.namespace.config.NamespaceParser;
import it.grid.storm.namespace.config.xml.XMLNamespaceLoader;
import it.grid.storm.namespace.config.xml.XMLParserUtil;
import it.grid.storm.namespace.model.ACLEntry;
import it.grid.storm.namespace.model.ApproachableRule;
import it.grid.storm.namespace.model.Authority;
import it.grid.storm.namespace.model.Capability;
import it.grid.storm.namespace.model.DefaultValues;
import it.grid.storm.namespace.model.MappingRule;
import it.grid.storm.namespace.model.PermissionException;
import it.grid.storm.namespace.model.PoolMember;
import it.grid.storm.namespace.model.Property;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.model.ProtocolPool;
import it.grid.storm.namespace.model.Quota;
import it.grid.storm.namespace.model.QuotaType;
import it.grid.storm.namespace.model.SAAuthzType;
import it.grid.storm.namespace.model.StorageClassType;
import it.grid.storm.namespace.model.SubjectRules;
import it.grid.storm.namespace.model.TransportProtocol;
import it.grid.storm.namespace.model.VirtualFS;
import it.grid.storm.space.SpaceHelper;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.slf4j.Logger;

public class XMLNamespaceParser
implements NamespaceParser,
Observer {
    private final Logger log = NamespaceDirector.getLogger();
    private String version;
    private Hashtable<String, VirtualFSInterface> vfss;
    private Hashtable<String, MappingRule> maprules;
    private Hashtable<String, ApproachableRule> apprules;
    private XMLParserUtil parserUtil;
    private final XMLConfiguration configuration;
    private XMLNamespaceLoader xmlLoader;
    private final Lock refreshing = new ReentrantLock();
    private final boolean internalLog;
    private final boolean testingMode;

    public XMLNamespaceParser(NamespaceLoader loader, boolean verboseLogging, boolean testingMode) {
        this.configuration = (XMLConfiguration)loader.getConfiguration();
        if (loader instanceof XMLNamespaceLoader) {
            this.xmlLoader = (XMLNamespaceLoader)loader;
            this.xmlLoader.setObserver(this);
        } else {
            this.log.error("XMLParser initialized with a non-XML Loader");
        }
        this.internalLog = true;
        this.testingMode = testingMode;
        this.parserUtil = new XMLParserUtil((Configuration)this.configuration);
        Iterator iter = this.parserUtil.getKeys();
        while (iter.hasNext()) {
            Object item = iter.next();
            this.verboseLog(item.toString());
        }
        this.vfss = new Hashtable();
        this.maprules = new Hashtable();
        this.apprules = new Hashtable();
        boolean validNamespaceConfiguration = this.refreshCachedData();
        if (!validNamespaceConfiguration) {
            this.log.error(" ???????????????????????????????????? ");
            this.log.error(" ????  NAMESPACE does not VALID  ???? ");
            this.log.error(" ???????????????????????????????????? ");
            this.log.error(" Please see the log. ");
            System.exit(0);
        }
    }

    @Override
    public Map<String, VirtualFSInterface> getVFSs() {
        return this.vfss;
    }

    @Override
    public Map<String, ApproachableRule> getApproachableRules() {
        return this.apprules;
    }

    @Override
    public Map<String, MappingRule> getMappingRules() {
        return this.maprules;
    }

    @Override
    public long getLastUpdateTime() {
        return 0L;
    }

    @Override
    public void update(Observable observed, Object arg) {
        this.log.debug(arg + " Refreshing Namespace Memory Cache .. ");
        XMLNamespaceLoader loader = (XMLNamespaceLoader)observed;
        this.parserUtil = new XMLParserUtil(loader.getConfiguration());
        if (loader.schemaValidity) {
            this.refreshCachedData();
        }
        loader.setNotifyManaged();
        this.log.debug(" ... Cache Refreshing ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean refreshCachedData() {
        boolean result = false;
        try {
            this.refreshing.lock();
            this.configuration.clear();
            this.configuration.clearTree("filesystems");
            this.configuration.clearTree("mapping-rules");
            this.configuration.clearTree("approachable-rules");
            try {
                this.configuration.load();
                this.log.debug(" ... reading and parsing the namespace configuration from file!");
            }
            catch (ConfigurationException ex) {
                ex.printStackTrace();
            }
            this.log.debug("REFRESHING CACHE..");
            this.log.debug("  ..save the cache content before semantic check");
            Hashtable<String, VirtualFSInterface> vfssSAVED = this.vfss;
            Hashtable<String, MappingRule> maprulesSAVED = this.maprules;
            Hashtable<String, ApproachableRule> apprulesSAVED = this.apprules;
            this.log.debug("  ..refresh the cache");
            this.refreshCache();
            this.log.debug("  ..semantic check of namespace");
            NamespaceCheck checker = new NamespaceCheck(this.vfss, this.maprules, this.apprules);
            boolean semanticCheck = checker.check();
            this.log.debug("REFRESHING ENDED.");
            if (semanticCheck) {
                this.log.debug("Namespace is semantically valid");
                result = true;
            } else {
                this.log.warn("Namespace does not semantically valid!, so no load performed!");
                this.vfss = vfssSAVED;
                this.maprules = maprulesSAVED;
                this.apprules = apprulesSAVED;
                result = false;
            }
        }
        finally {
            this.refreshing.unlock();
        }
        return result;
    }

    private void verboseLog(String msg) {
        if (this.internalLog) {
            this.log.debug(msg);
        }
    }

    private void refreshCache() {
        this.log.info("  ##############  REFRESHING NAMESPACE CONFIGURATION CACHE : start  ###############");
        try {
            this.retrieveVersion();
        }
        catch (NamespaceException ex1) {
            this.log.warn("Namespace configuration does not contain a valid version number.", (Throwable)ex1);
        }
        try {
            this.buildVFSs();
            this.updateSA();
        }
        catch (ClassNotFoundException ex) {
            this.log.error("Namespace Configuration ERROR in VFS-DRIVER specification", (Throwable)ex);
        }
        catch (NamespaceException ex) {
            this.log.error("Namespace Configuration ERROR in VFS definition, please check it.", (Throwable)ex);
        }
        try {
            this.buildMapRules();
        }
        catch (NamespaceException ex1) {
            this.log.error("Namespace Configuration ERROR in MAPPING RULES definition, please check it.", (Throwable)ex1);
        }
        try {
            this.buildAppRules();
        }
        catch (NamespaceException ex2) {
            this.log.error("Namespace Configuration ERROR in APPROACHABLE RULES definition, please check it.", (Throwable)ex2);
        }
        this.log.info("  ##############  REFRESHING NAMESPACE CONFIGURATION CACHE : end ###############");
    }

    private void updateSA() throws NamespaceException {
        TSpaceToken spaceToken = null;
        SpaceHelper spaceHelp = new SpaceHelper();
        this.log.debug("Updating Space Catalog with Storage Area defined within NAMESPACE");
        VirtualFS vfs = null;
        Enumeration<VirtualFSInterface> scan = this.vfss.elements();
        while (scan.hasMoreElements()) {
            vfs = (VirtualFS)scan.nextElement();
            String vfsAliasName = vfs.getAliasName();
            this.verboseLog(" Considering VFS : " + vfsAliasName);
            String aliasName = vfs.getSpaceTokenDescription();
            if (aliasName == null) {
                this.log.debug("XMLNamespaceParser.UpdateSA() : Found a VFS ('" + vfsAliasName + "') without space-token-description. Skipping the Update of SA");
                continue;
            }
            TSizeInBytes onlineSize = vfs.getProperties().getTotalOnlineSize();
            String spaceFileName = vfs.getRootPath();
            spaceToken = spaceHelp.createVOSA_Token(aliasName, onlineSize, spaceFileName);
            vfs.setSpaceToken(spaceToken);
            this.verboseLog(" Updating SA ('" + aliasName + "'), token:'" + spaceToken + "', onlineSize:'" + onlineSize + "', spaceFileName:'" + spaceFileName);
        }
        spaceHelp.purgeOldVOSA_token();
        this.log.debug("Updating Space Catalog... DONE!!");
    }

    private void retrieveVersion() throws NamespaceException {
        this.version = this.parserUtil.getNamespaceVersion();
        this.verboseLog(" ====  NAMESPACE VERSION : '" + this.version + "'  ====");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildVFSs() throws ClassNotFoundException, NamespaceException {
        int nrOfVFS = 0;
        nrOfVFS = this.parserUtil.getNumberOfFS();
        String spaceTokenDescription = null;
        StorageClassType storageClass = StorageClassType.UNKNOWN;
        String root = null;
        SAAuthzType saAuthzType = SAAuthzType.UNKNOWN;
        for (int i = 0; i < nrOfVFS; ++i) {
            VirtualFS vfs = new VirtualFS(this.testingMode);
            String name = this.parserUtil.getFSName(i);
            vfs.setAliasName(name);
            this.verboseLog("VFS(" + i + ").name = '" + name + "'");
            String fsType = this.parserUtil.getFSType(name);
            vfs.setFSType(fsType);
            this.verboseLog("VFS(" + name + ").fs_type = '" + fsType + "'");
            spaceTokenDescription = this.parserUtil.getFSSpaceTokenDescription(name);
            vfs.setSpaceTokenDescription(spaceTokenDescription);
            this.verboseLog("VFS(" + name + ").space-token-description = '" + spaceTokenDescription + "'");
            storageClass = StorageClassType.getStorageClassType(this.parserUtil.getStorageClass(name));
            vfs.setStorageClassType(storageClass);
            this.verboseLog("VFS(" + name + ").storage-class = '" + (Object)((Object)storageClass) + "'");
            root = this.parserUtil.getFSRoot(name);
            vfs.setRoot(root);
            this.verboseLog("VFS(" + name + ").root = '" + root + "'");
            Class<?> driver = Class.forName(this.parserUtil.getFSDriver(name));
            vfs.setFSDriver(driver);
            this.verboseLog("VFS(" + name + ").fsDriver [CLASS Name] = '" + driver.getName() + "'");
            driver = Class.forName(this.parserUtil.getSpaceDriver(name));
            vfs.setSpaceSystemDriver(driver);
            this.verboseLog("VFS(" + name + ").spaceDriver [CLASS Name] = '" + driver.getName() + "'");
            saAuthzType = this.parserUtil.getStorageAreaAuthzType(name);
            vfs.setSAAuthzType(saAuthzType);
            this.verboseLog("VFS(" + name + ").storage-area-authz.TYPE = '" + saAuthzType + "'");
            String storageAreaAuthz = this.parserUtil.getStorageAreaAuthz(name, saAuthzType);
            vfs.setSAAuthzSource(storageAreaAuthz);
            this.verboseLog("VFS(" + name + ").storage-area-authz = '" + storageAreaAuthz + "'");
            PropertyInterface prop = this.buildProperties(name);
            vfs.setProperties(prop);
            CapabilityInterface cap = this.buildCapabilities(name);
            vfs.setCapabilities(cap);
            DefaultValuesInterface defValues = this.buildDefaultValues(name);
            vfs.setDefaultValues(defValues);
            XMLNamespaceParser xMLNamespaceParser = this;
            synchronized (xMLNamespaceParser) {
                this.vfss.remove(name);
                this.vfss.put(name, vfs);
                continue;
            }
        }
    }

    private PropertyInterface buildProperties(String fsName) throws NamespaceException {
        Property prop = new Property();
        String accessLatency = this.parserUtil.getAccessLatencyType(fsName);
        prop.setAccessLatency(accessLatency);
        this.verboseLog("VFS(" + fsName + ").Properties.AccessLatency = '" + accessLatency + "'");
        String expirationMode = this.parserUtil.getExpirationModeType(fsName);
        prop.setExpirationMode(expirationMode);
        this.verboseLog("VFS(" + fsName + ").Properties.ExpirationMode = '" + expirationMode + "'");
        String retentionPolicy = this.parserUtil.getRetentionPolicyType(fsName);
        prop.setRetentionPolicy(retentionPolicy);
        this.verboseLog("VFS(" + fsName + ").Properties.RetentionPolicy = '" + retentionPolicy + "'");
        String unitType = this.parserUtil.getNearlineSpaceUnitType(fsName);
        long nearLineSize = this.parserUtil.getNearlineSpaceSize(fsName);
        prop.setTotalNearlineSize(unitType, nearLineSize);
        this.verboseLog("VFS(" + fsName + ").Properties.NearlineSpaceSize = '" + nearLineSize + " " + unitType + "'");
        unitType = this.parserUtil.getOnlineSpaceUnitType(fsName);
        long onlineSize = this.parserUtil.getOnlineSpaceSize(fsName);
        prop.setTotalOnlineSize(unitType, onlineSize);
        this.verboseLog("VFS(" + fsName + ").Properties.OnlineSpaceSize = '" + onlineSize + " " + unitType + "'");
        boolean hasLimitedSize = this.parserUtil.getOnlineSpaceLimitedSize(fsName);
        prop.setLimitedSize(hasLimitedSize);
        this.verboseLog("VFS(" + fsName + ").Properties.OnlineSpaceLimitedSize = '" + hasLimitedSize + "'");
        return prop;
    }

    private CapabilityInterface buildCapabilities(String fsName) throws NamespaceException {
        String aclMode = this.parserUtil.getACLMode(fsName);
        Capability cap = new Capability(aclMode);
        this.verboseLog("VFS(" + fsName + ").Capabilities.aclMode = '" + aclMode + "'");
        boolean defaultACLDefined = this.parserUtil.getDefaultACLDefined(fsName);
        this.verboseLog("VFS(" + fsName + ").Capabilities.defaultACL [Defined?] =" + defaultACLDefined);
        if (defaultACLDefined) {
            int nrACLEntries = this.parserUtil.getNumberOfACL(fsName);
            String groupName = null;
            String filePermString = null;
            ACLEntry aclEntry = null;
            for (int entryNumber = 0; entryNumber < nrACLEntries; ++entryNumber) {
                groupName = this.parserUtil.getGroupName(fsName, entryNumber);
                filePermString = this.parserUtil.getPermissionString(fsName, entryNumber);
                try {
                    aclEntry = new ACLEntry(groupName, filePermString);
                    cap.addACLEntry(aclEntry);
                    continue;
                }
                catch (PermissionException permEx) {
                    this.log.error("Namespace XML Parser -- ERROR -- : " + permEx.getMessage());
                }
            }
            this.verboseLog("VFS(" + fsName + ").Capabilities.defaultACL = " + cap.getDefaultACL());
        }
        boolean quotaDefined = this.parserUtil.getQuotaDefined(fsName);
        Quota quota = null;
        if (quotaDefined) {
            QuotaType quotaType;
            boolean quotaEnabled = this.parserUtil.getQuotaEnabled(fsName);
            String device = this.parserUtil.getQuotaDevice(fsName);
            String quotaValue = null;
            if (this.parserUtil.getQuotaFilesetDefined(fsName)) {
                quotaType = QuotaType.buildQuotaType(QuotaType.FILESET);
                quotaValue = this.parserUtil.getQuotaFileset(fsName);
            } else if (this.parserUtil.getQuotaGroupIDDefined(fsName)) {
                quotaType = QuotaType.buildQuotaType(QuotaType.GRP);
                quotaValue = this.parserUtil.getQuotaGroupID(fsName);
            } else if (this.parserUtil.getQuotaUserIDDefined(fsName)) {
                quotaType = QuotaType.buildQuotaType(QuotaType.USR);
                quotaValue = this.parserUtil.getQuotaUserID(fsName);
            } else {
                quotaType = QuotaType.buildQuotaType(QuotaType.UNKNOWN);
                quotaValue = "unknown";
            }
            quotaType.setValue(quotaValue);
            quota = new Quota(quotaEnabled, device, quotaType);
        } else {
            quota = new Quota();
        }
        cap.setQuota(quota);
        this.verboseLog("VFS(" + fsName + ").Capabilities.quota = '" + quota + "'");
        this.log.debug("VFS(" + fsName + ").Capabilities.quota = '" + quota + "'");
        int nrProtocols = this.parserUtil.getNumberOfProt(fsName);
        for (int protCounter = 0; protCounter < nrProtocols; ++protCounter) {
            int protocolIndex = this.parserUtil.getProtId(fsName, protCounter);
            String name = this.parserUtil.getProtName(fsName, protCounter);
            String schema = this.parserUtil.getProtSchema(fsName, protCounter);
            Protocol protocol = Protocol.getProtocol(schema);
            protocol.setProtocolServiceName(name);
            String serviceHostName = this.parserUtil.getProtHost(fsName, protCounter);
            String servicePortValue = this.parserUtil.getProtPort(fsName, protCounter);
            int portIntValue = -1;
            Authority service = null;
            if (servicePortValue != null) {
                try {
                    portIntValue = Integer.parseInt(servicePortValue);
                    service = new Authority(serviceHostName, portIntValue);
                }
                catch (NumberFormatException nfe) {
                    this.log.warn("to evaluate the environmental variable " + servicePortValue);
                }
            } else {
                service = new Authority(serviceHostName);
            }
            TransportProtocol transportProt = new TransportProtocol(protocol, service);
            transportProt.setProtocolID(protocolIndex);
            this.verboseLog("VFS(" + fsName + ").Capabilities.protocol(" + protCounter + ") = '" + transportProt + "'");
            cap.addTransportProtocolByScheme(protocol, transportProt);
            cap.addTransportProtocol(transportProt);
            if (protocolIndex == -1) continue;
            cap.addTransportProtocolByID(protocolIndex, transportProt);
        }
        int nrPools = this.parserUtil.getNumberOfPool(fsName);
        if (nrPools > 0) {
            for (int poolCounter = 0; poolCounter < nrPools; ++poolCounter) {
                BalancingStrategyType balanceStrategy = BalancingStrategyType.getByValue(this.parserUtil.getBalancerStrategy(fsName, poolCounter));
                ArrayList<PoolMember> poolMembers = new ArrayList<PoolMember>();
                int nrMembers = this.parserUtil.getNumberOfPoolMembers(fsName, poolCounter);
                for (int i = 0; i < nrMembers; ++i) {
                    PoolMember poolMember;
                    int protIndex = this.parserUtil.getMemberID(fsName, poolCounter, i);
                    TransportProtocol tProtMember = cap.getProtocolByID(protIndex);
                    if (tProtMember != null) {
                        if (balanceStrategy.requireWeight()) {
                            int memberWeight = this.parserUtil.getMemberWeight(fsName, poolCounter, i);
                            poolMember = new PoolMember(protIndex, tProtMember, memberWeight);
                        } else {
                            poolMember = new PoolMember(protIndex, tProtMember);
                        }
                    } else {
                        this.log.error("POOL Building: Protocol with index " + protIndex + " does not exists in the VFS :" + fsName);
                        throw new NamespaceException("POOL Building: Protocol with index " + protIndex + " does not exists in the VFS :" + fsName);
                    }
                    poolMembers.add(poolMember);
                }
                Protocol pooProtocol = ((PoolMember)poolMembers.get(0)).getMemberProtocol().getProtocol();
                this.verifyPoolIsValid(poolMembers);
                this.log.debug("Defined pool for protocol " + pooProtocol.toString() + " with size " + poolMembers.size());
                cap.addProtocolPoolBySchema(pooProtocol, new ProtocolPool(balanceStrategy, poolMembers));
                this.log.debug("PROTOCOL POOL: " + cap.getPoolByScheme(pooProtocol));
            }
        } else {
            this.log.debug("Pool is not defined in VFS " + fsName);
        }
        return cap;
    }

    private void verifyPoolIsValid(ArrayList<PoolMember> poolMembers) throws NamespaceException {
        if (poolMembers.isEmpty()) {
            throw new NamespaceException("POOL Defined is EMPTY!");
        }
        Protocol prot = poolMembers.get(0).getMemberProtocol().getProtocol();
        for (PoolMember member : poolMembers) {
            if (member.getMemberProtocol().getProtocol().equals(prot)) continue;
            throw new NamespaceException("Defined Pool is NOT HOMOGENEOUS! Protocols " + prot.toString() + " and " + member.toString() + " differs");
        }
    }

    private DefaultValuesInterface buildDefaultValues(String fsName) throws NamespaceException {
        DefaultValues def = new DefaultValues();
        if (this.parserUtil.isDefaultElementPresent(fsName)) {
            this.setSpaceDef(fsName, def);
            this.setFileDef(fsName, def);
        } else {
            this.verboseLog("VFS(" + fsName + ").DefaultValues is ABSENT.  Using DEFAULT values.");
        }
        return def;
    }

    private void setSpaceDef(String fsName, DefaultValues def) throws NamespaceException {
        String spaceType = this.parserUtil.getDefaultSpaceType(fsName);
        this.verboseLog("VFS(" + fsName + ").DefaultValues.space.type = '" + spaceType + "'");
        long lifeTime = this.parserUtil.getDefaultSpaceLifeTime(fsName);
        this.verboseLog("VFS(" + fsName + ").DefaultValues.space.lifeTime = '" + lifeTime + "'");
        long guarSize = this.parserUtil.getDefaultSpaceGuarSize(fsName);
        this.verboseLog("VFS(" + fsName + ").DefaultValues.space.guarSize = '" + guarSize + "'");
        long totSize = this.parserUtil.getDefaultSpaceTotSize(fsName);
        this.verboseLog("VFS(" + fsName + ").DefaultValues.space.totSize = '" + totSize + "'");
        def.setSpaceDefaults(spaceType, lifeTime, guarSize, totSize);
    }

    private void setFileDef(String fsName, DefaultValues def) throws NamespaceException {
        String fileType = this.parserUtil.getDefaultFileType(fsName);
        this.verboseLog("VFS(" + fsName + ").DefaultValues.file.type = '" + fileType + "'");
        long lifeTime = this.parserUtil.getDefaultFileLifeTime(fsName);
        this.verboseLog("VFS(" + fsName + ").DefaultValues.file.lifeTime = '" + lifeTime + "'");
        def.setFileDefaults(fileType, lifeTime);
    }

    private void buildMapRules() throws NamespaceException {
        int numOfMapRules = this.parserUtil.getNumberOfMappingRule();
        for (int i = 0; i < numOfMapRules; ++i) {
            String ruleName = this.parserUtil.getMapRuleName(i);
            String mappedFS = this.parserUtil.getMapRule_mappedFS(ruleName);
            if (this.vfss.containsKey(mappedFS)) {
                this.verboseLog("VFS '" + mappedFS + "' pointed by RULE : '" + ruleName + "' exists.");
                String stfnRoot = this.parserUtil.getMapRule_StFNRoot(ruleName);
                VirtualFSInterface vfs = this.vfss.get(mappedFS);
                MappingRule mapRule = new MappingRule(ruleName, stfnRoot, vfs);
                ((VirtualFS)vfs).addMappingRule(mapRule);
                this.maprules.put(ruleName, mapRule);
                continue;
            }
            this.log.error("VFS '" + mappedFS + "' pointed by RULE : '" + ruleName + "' DOES NOT EXISTS.");
        }
    }

    private void buildAppRules() throws NamespaceException {
        int numOfAppRules = this.parserUtil.getNumberOfApproachRule();
        this.verboseLog("Number of APP Rule : " + numOfAppRules);
        for (int i = 0; i < numOfAppRules; ++i) {
            String ruleName = this.parserUtil.getApproachRuleName(i);
            this.verboseLog(" APP rule nr:" + i + " is named : " + ruleName);
            String dn = this.parserUtil.getAppRule_SubjectDN(ruleName);
            String vo_name = this.parserUtil.getAppRule_SubjectVO(ruleName);
            SubjectRules subjectRules = new SubjectRules(dn, vo_name);
            String relPath = this.parserUtil.getAppRule_RelativePath(ruleName);
            String anonymousHttpReadString = this.parserUtil.getAppRule_AnonymousHttpRead(ruleName);
            ApproachableRule appRule = anonymousHttpReadString != null && !anonymousHttpReadString.trim().isEmpty() ? new ApproachableRule(ruleName, subjectRules, relPath, Boolean.parseBoolean(anonymousHttpReadString)) : new ApproachableRule(ruleName, subjectRules, relPath);
            List appFSList = this.parserUtil.getAppRule_AppFS(ruleName);
            for (String appFS : appFSList) {
                if (this.vfss.containsKey(appFS)) {
                    this.verboseLog("VFS '" + appFS + "' pointed by RULE : '" + ruleName + "' exists.");
                    VirtualFSInterface vfs = this.vfss.get(appFS);
                    ((VirtualFS)vfs).addApproachableRule(appRule);
                    appRule.addApproachableVFS(vfs);
                    continue;
                }
                this.log.error("VFS '" + appFS + "' pointed by RULE : '" + ruleName + "' DOES NOT EXISTS.");
            }
            this.apprules.put(ruleName, appRule);
        }
    }

    @Override
    public String getNamespaceVersion() {
        return this.version;
    }

    @Override
    public List<String> getAllVFS_Roots() {
        Collection<VirtualFSInterface> elem = this.vfss.values();
        Vector<String> roots = new Vector<String>(this.vfss.size());
        Iterator<VirtualFSInterface> scan = elem.iterator();
        while (scan.hasNext()) {
            String root = null;
            try {
                root = scan.next().getRootPath();
            }
            catch (NamespaceException ex) {
                this.log.error("Error while retrieving all StFN roots of VFSs", (Throwable)ex);
            }
            roots.add(root);
        }
        return roots;
    }

    @Override
    public Map<String, VirtualFSInterface> getMapVFS_Root() {
        Hashtable<String, VirtualFSInterface> result = new Hashtable<String, VirtualFSInterface>();
        Collection<VirtualFSInterface> elem = this.vfss.values();
        Iterator<VirtualFSInterface> scan = elem.iterator();
        while (scan.hasNext()) {
            String root = null;
            VirtualFSInterface vfs = scan.next();
            try {
                root = vfs.getRootPath();
            }
            catch (NamespaceException ex) {
                this.log.error("Error while retrieving all StFN roots of VFSs", (Throwable)ex);
            }
            result.put(root, vfs);
        }
        return result;
    }

    @Override
    public List<String> getAllMappingRule_StFNRoots() {
        Collection<MappingRule> elem = this.maprules.values();
        Vector<String> roots = new Vector<String>(this.maprules.size());
        Iterator<MappingRule> scan = elem.iterator();
        String root = null;
        while (scan.hasNext()) {
            root = scan.next().getStFNRoot();
            roots.add(root);
        }
        return roots;
    }

    @Override
    public Map<String, String> getMappingRuleMAP() {
        HashMap<String, String> map = new HashMap<String, String>();
        Collection<MappingRule> elem = this.maprules.values();
        Iterator<MappingRule> scan = elem.iterator();
        String root = null;
        String name = null;
        while (scan.hasNext()) {
            MappingRule rule = scan.next();
            root = rule.getStFNRoot();
            name = rule.getRuleName();
            map.put(name, root);
        }
        return map;
    }

    @Override
    public VirtualFSInterface getVFS(String vfsName) {
        return this.vfss.get(vfsName);
    }
}

