/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace.config.xml;

import it.grid.storm.config.Configuration;
import it.grid.storm.namespace.NamespaceValidator;
import it.grid.storm.namespace.config.NamespaceLoader;
import it.grid.storm.namespace.config.xml.XMLReloadingStrategy;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XMLNamespaceLoader
extends Observable
implements NamespaceLoader {
    private static Logger log = LoggerFactory.getLogger(XMLNamespaceLoader.class);
    public String filename;
    public String path;
    public int refresh;
    private XMLConfiguration config = null;
    private final int delay = 1000;
    private long period = -1L;
    private final Timer timer = new Timer();
    private XMLReloadingStrategy xmlStrategy;
    private String namespaceFN = null;
    private boolean verbose = false;
    private final String namespaceSchemaURL;
    public boolean schemaValidity = false;

    public XMLNamespaceLoader() {
        this.namespaceFN = this.getNamespaceFileName();
        this.namespaceSchemaURL = this.getNamespaceSchemaFileName();
        this.init(this.namespaceFN, this.refresh);
    }

    public XMLNamespaceLoader(int refresh) {
        this.refresh = refresh < 0 ? 0 : refresh;
        this.namespaceFN = this.getNamespaceFileName();
        this.namespaceSchemaURL = this.getNamespaceSchemaFileName();
        log.debug("Namespace XSD : " + this.namespaceSchemaURL);
        this.init(this.namespaceFN, refresh);
    }

    public XMLNamespaceLoader(String filename) {
        this.filename = filename;
        this.namespaceFN = this.getNamespaceFileName();
        this.namespaceSchemaURL = this.getNamespaceSchemaFileName();
        log.debug("Namespace XSD : " + this.namespaceSchemaURL);
        this.init(this.namespaceFN, this.refresh);
    }

    public XMLNamespaceLoader(String path, String filename) {
        this.path = path;
        this.filename = filename;
        this.namespaceFN = this.getNamespaceFileName();
        this.namespaceSchemaURL = this.getNamespaceSchemaFileName();
        log.debug("Namespace XSD : " + this.namespaceSchemaURL);
        this.init(this.namespaceFN, this.refresh);
    }

    public XMLNamespaceLoader(String path, String filename, int refresh, boolean verboseMode) {
        this.refresh = refresh < 0 ? 0 : refresh;
        this.path = path;
        this.filename = filename;
        this.namespaceFN = this.getNamespaceFileName();
        this.namespaceSchemaURL = this.getNamespaceSchemaFileName();
        log.debug("Namespace XSD : " + this.namespaceSchemaURL);
        this.verbose = verboseMode;
        this.init(this.namespaceFN, refresh);
    }

    public void setObserver(Observer obs) {
        this.addObserver(obs);
    }

    public void setNotifyManaged() {
        this.xmlStrategy.notifingPerformed();
        this.config.setReloadingStrategy((ReloadingStrategy)this.xmlStrategy);
    }

    public void setVerbosity(boolean verbosity) {
        this.verbose = verbosity;
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
    }

    private void init(String namespaceFileName, int refresh) {
        System.out.println("Reading Namespace configuration file " + namespaceFileName + " and setting refresh rate to " + refresh + " seconds.");
        this.xmlStrategy = new XMLReloadingStrategy();
        this.period = 3000L;
        log.debug(" Refresh time is " + this.period + " millisec");
        this.xmlStrategy.setRefreshDelay(this.period);
        this.namespaceFN = namespaceFileName;
        try {
            this.config = new XMLConfiguration();
            this.config.setFileName(namespaceFileName);
            log.debug(" ... CHECK of VALIDITY of NAMESPACE Configuration ...");
            this.schemaValidity = XMLNamespaceLoader.checkValidity(this.namespaceSchemaURL, namespaceFileName);
            if (!this.schemaValidity) {
                log.error("NAMESPACE IS NOT VALID IN RESPECT OF NAMESPACE SCHEMA! ");
                throw new ConfigurationException("XML is not valid!");
            }
            log.debug("Namespace is valid in respect of NAMESPACE SCHEMA.");
            this.config.setReloadingStrategy((ReloadingStrategy)this.xmlStrategy);
            Peeper peeper = new Peeper(this);
            this.timer.schedule((TimerTask)peeper, 1000L, this.period);
            log.debug("Timer initialized");
            this.config.load();
            log.debug("Namespace Configuration read!");
        }
        catch (ConfigurationException cex) {
            System.err.println("*****************************************************");
            System.err.println("   ATTENTION! Unable to load Namespace Configuration!");
            System.err.println("*****************************************************");
            log.error(this.toString());
        }
    }

    private String getNamespaceFileName() {
        String namespaceAbsFN;
        File nsFile;
        String configurationDir = Configuration.getInstance().configurationDir();
        String namespaceFN = Configuration.getInstance().getNamespaceConfigFilename();
        if (configurationDir.charAt(configurationDir.length() - 1) != File.separatorChar) {
            configurationDir = configurationDir + File.separatorChar;
        }
        if ((nsFile = new File(namespaceAbsFN = configurationDir + namespaceFN)).exists()) {
            log.debug("Found the namespace file : " + namespaceAbsFN);
        } else {
            log.error("Unable to find the namespace file :" + namespaceAbsFN);
        }
        return namespaceAbsFN;
    }

    private String getNamespaceSchemaFileName() {
        String schemaName = Configuration.getInstance().getNamespaceSchemaFilename();
        if (schemaName.equals("Schema UNKNOWN!")) {
            schemaName = "namespace.xsd";
            String namespaceFN = this.getNamespaceFileName();
            File namespaceFile = new File(namespaceFN);
            if (namespaceFile.exists()) {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                try {
                    DocumentBuilder builder = factory.newDocumentBuilder();
                    Document doc = builder.parse(namespaceFN);
                    Element rootElement = doc.getDocumentElement();
                    String tagName = rootElement.getTagName();
                    if (tagName.equals("namespace")) {
                        if (rootElement.hasAttributes()) {
                            String value = rootElement.getAttribute("xsi:noNamespaceSchemaLocation");
                            if (value != null && value.length() > 0) {
                                schemaName = value;
                            }
                        } else {
                            log.error(namespaceFN + " don't have a valid root element attributes");
                        }
                    } else {
                        log.error(namespaceFN + "  don't have a valid root element.");
                    }
                }
                catch (ParserConfigurationException e) {
                    log.error("Error while parsing " + namespaceFN + e.getMessage());
                }
                catch (SAXException e) {
                    log.error("Error while parsing " + namespaceFN + e.getMessage());
                }
                catch (IOException e) {
                    log.error("Error while parsing " + namespaceFN + e.getMessage());
                }
            }
        }
        return schemaName;
    }

    @Override
    public org.apache.commons.configuration.Configuration getConfiguration() {
        return this.config;
    }

    private static boolean checkValidity(String namespaceSchemaURL, String filename) {
        NamespaceValidator validator = new NamespaceValidator();
        boolean valid = validator.validateSchema(namespaceSchemaURL, filename);
        return valid;
    }

    private class Peeper
    extends TimerTask {
        private XMLReloadingStrategy reloadingStrategy;
        private boolean signal;
        private final XMLNamespaceLoader observed;

        public Peeper(XMLNamespaceLoader obs) {
            this.observed = obs;
        }

        @Override
        public void run() {
            boolean changed;
            this.reloadingStrategy = (XMLReloadingStrategy)XMLNamespaceLoader.this.config.getReloadingStrategy();
            if (XMLNamespaceLoader.this.verbose) {
                File xmlFile = this.reloadingStrategy.getConfigurationFile();
                log.debug(" Peeper glance on XMLReloadingStrategy bound with FILE : " + xmlFile.getName());
                long lastFileModified = xmlFile.lastModified();
                Date dateFile = new Date(lastFileModified);
                long lastFileModifiedReload = this.reloadingStrategy.getLastReload();
                this.reloadingStrategy.reloadingPerformed();
                Date dateReload = new Date(lastFileModifiedReload);
                if (lastFileModifiedReload < lastFileModified) {
                    log.debug("RELOAD NEEDED!");
                    SimpleDateFormat formatter = new SimpleDateFormat("HH.mm.ss  dd.MM.yyyy");
                    log.debug(" FILE XML Last Modified : " + formatter.format((Object)dateFile));
                    log.debug(" FILE XML Last RELOAD : " + formatter.format((Object)dateReload));
                }
            }
            if (changed = this.reloadingStrategy.reloadingRequired()) {
                log.debug(" NAMESPACE CONFIGURATION is changed ! ");
                log.debug(" ... CHECK of VALIDITY of NAMESPACE Configuration ...");
                boolean valid = XMLNamespaceLoader.checkValidity(XMLNamespaceLoader.this.namespaceSchemaURL, XMLNamespaceLoader.this.namespaceFN);
                if (!valid) {
                    log.debug(" Namespace configuration is not reloaded.. Please rectify the error.");
                    XMLNamespaceLoader.this.schemaValidity = false;
                    this.reloadingStrategy.notifingPerformed();
                    this.reloadingStrategy.reloadingPerformed();
                } else {
                    log.debug(" ... NAMESPACE Configuration is VALID in respect of Schema Grammar.");
                    log.debug(" ----> RELOADING  ");
                    XMLNamespaceLoader.this.schemaValidity = true;
                    boolean forceReloading = Configuration.getInstance().getNamespaceAutomaticReloading();
                    if (forceReloading) {
                        XMLNamespaceLoader.this.config.reload();
                    } else {
                        log.debug(" ----> RELOAD of namespace don't be executed because NO AUTOMATIC RELOAD is configured.");
                    }
                    this.reloadingStrategy.reloadingPerformed();
                }
            }
            this.signal = this.reloadingStrategy.notifingRequired();
            if (this.signal) {
                this.observed.setChanged();
                this.observed.notifyObservers(" MSG : Namespace is changed!");
                this.reloadingStrategy.notifingPerformed();
            }
        }
    }
}

