/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace;

import it.grid.storm.common.types.PFN;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.https.HTTPPluginManager;
import it.grid.storm.https.HTTPSPluginException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.model.Authority;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.srm.types.InvalidTTURLAttributesException;
import it.grid.storm.srm.types.TTURL;
import org.slf4j.Logger;

public class TURLBuilder {
    private static Logger log = NamespaceDirector.getLogger();

    private static TTURL buildTURL(Protocol protocol, Authority authority, String extraSlashes, PFN physicalFN) {
        TTURL turl = null;
        String turlString = null;
        try {
            turlString = protocol.getProtocolPrefix() + authority.toString() + extraSlashes + physicalFN.getValue();
            log.debug("turlString used to build the TURL : " + turlString);
            turl = TTURL.makeFromString(turlString);
        }
        catch (InvalidTTURLAttributesException ex) {
            log.error("Error while constructing TURL with Authority :'" + authority + "'; EXCEP: " + ex);
        }
        return turl;
    }

    public static TTURL buildFileTURL(Authority authority, PFN physicalFN) {
        String extraSlashesForFile = Configuration.getInstance().getExtraSlashesForFileTURL();
        return TURLBuilder.buildTURL(Protocol.FILE, authority, extraSlashesForFile, physicalFN);
    }

    public static TTURL buildGsiftpTURL(Authority authority, PFN physicalFN) {
        String extraSlashesForGSIFTP = Configuration.getInstance().getExtraSlashesForGsiFTPTURL();
        return TURLBuilder.buildTURL(Protocol.GSIFTP, authority, extraSlashesForGSIFTP, physicalFN);
    }

    public static TTURL buildRFIOTURL(Authority authority, PFN physicalFN) {
        String extraSlashesForRFIO = Configuration.getInstance().getExtraSlashesForRFIOTURL();
        return TURLBuilder.buildTURL(Protocol.RFIO, authority, extraSlashesForRFIO, physicalFN);
    }

    public static TTURL buildROOTTURL(Authority authority, PFN physicalFN) {
        String extraSlashesForROOT = Configuration.getInstance().getExtraSlashesForROOTTURL();
        return TURLBuilder.buildTURL(Protocol.ROOT, authority, extraSlashesForROOT, physicalFN);
    }

    public static TTURL buildHTTPTURL(Authority authority, LocalFile localFile) throws HTTPSPluginException {
        String serviceRelativePath = HTTPPluginManager.getHTTPSPluginInstance().mapLocalPath(authority.getServiceHostname(), localFile.getAbsolutePath());
        return TURLBuilder.buildTURL(Protocol.HTTP, authority, "", serviceRelativePath);
    }

    public static TTURL buildHTTPSTURL(Authority authority, LocalFile localFile) throws HTTPSPluginException {
        String serviceRelativePath = HTTPPluginManager.getHTTPSPluginInstance().mapLocalPath(authority.getServiceHostname(), localFile.getAbsolutePath());
        return TURLBuilder.buildTURL(Protocol.HTTPS, authority, "", serviceRelativePath);
    }

    private static TTURL buildTURL(Protocol protocol, Authority authority, String extraSlashes, String serviceRelativePath) {
        TTURL turl = null;
        String turlString = null;
        try {
            turlString = protocol.getProtocolPrefix() + authority.toString() + extraSlashes + serviceRelativePath;
            log.debug("turlString used to build the TURL : " + turlString);
            turl = TTURL.makeFromString(turlString);
        }
        catch (InvalidTTURLAttributesException ex) {
            log.error("Error while constructing TURL with Authority :'" + authority + "'; EXCEP: " + ex);
        }
        return turl;
    }
}

