/*
 * Decompiled with CFR 0.152.
 */
package it.grid.storm.namespace;

import it.grid.storm.balancer.BalancingStrategy;
import it.grid.storm.balancer.BalancingStrategyException;
import it.grid.storm.balancer.Node;
import it.grid.storm.catalogs.VolatileAndJiTCatalog;
import it.grid.storm.common.types.InvalidPFNAttributeException;
import it.grid.storm.common.types.PFN;
import it.grid.storm.common.types.StFN;
import it.grid.storm.common.types.TURLPrefix;
import it.grid.storm.config.Configuration;
import it.grid.storm.filesystem.FSException;
import it.grid.storm.filesystem.Filesystem;
import it.grid.storm.filesystem.LocalFile;
import it.grid.storm.filesystem.ReservationException;
import it.grid.storm.filesystem.Space;
import it.grid.storm.filesystem.SpaceSystem;
import it.grid.storm.https.HTTPSPluginException;
import it.grid.storm.namespace.ExpiredSpaceTokenException;
import it.grid.storm.namespace.InvalidDescendantsAuthRequestException;
import it.grid.storm.namespace.InvalidDescendantsEmptyRequestException;
import it.grid.storm.namespace.InvalidDescendantsFileRequestException;
import it.grid.storm.namespace.InvalidDescendantsPathRequestException;
import it.grid.storm.namespace.InvalidGetTURLProtocolException;
import it.grid.storm.namespace.InvalidProtocolForTURLException;
import it.grid.storm.namespace.NamespaceDirector;
import it.grid.storm.namespace.NamespaceException;
import it.grid.storm.namespace.NamespaceInterface;
import it.grid.storm.namespace.StoRI;
import it.grid.storm.namespace.TURLBuilder;
import it.grid.storm.namespace.TURLBuildingException;
import it.grid.storm.namespace.VirtualFSInterface;
import it.grid.storm.namespace.model.Authority;
import it.grid.storm.namespace.model.Capability;
import it.grid.storm.namespace.model.MappingRule;
import it.grid.storm.namespace.model.PathCreator;
import it.grid.storm.namespace.model.Protocol;
import it.grid.storm.namespace.model.StoRIType;
import it.grid.storm.namespace.model.TransportProtocol;
import it.grid.storm.namespace.naming.NamespaceUtil;
import it.grid.storm.namespace.naming.SURL;
import it.grid.storm.namespace.util.userinfo.LocalGroups;
import it.grid.storm.srm.types.InvalidTSURLAttributesException;
import it.grid.storm.srm.types.TDirOption;
import it.grid.storm.srm.types.TLifeTimeInSeconds;
import it.grid.storm.srm.types.TSURL;
import it.grid.storm.srm.types.TSizeInBytes;
import it.grid.storm.srm.types.TSpaceToken;
import it.grid.storm.srm.types.TTURL;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;

public class StoRIImpl
implements StoRI {
    private Logger log = NamespaceDirector.getLogger();
    private TSURL surl;
    private PFN pfn;
    private Capability.ACLMode aclMode = Capability.ACLMode.UNDEF;
    private TLifeTimeInSeconds lifetime = null;
    private Date startTime = null;
    private LocalFile localFile = null;
    private Space space;
    private VirtualFSInterface vfs;
    private Filesystem fs;
    private SpaceSystem spaceDriver;
    private StoRIType type;
    private Capability capability;
    private String stfn;
    private String vfsRoot;
    private String relativeStFN;
    private String relativePath;
    private String fileName;
    private String stfnPath;
    private String stfnRoot;
    private MappingRule winnerRule;
    private boolean volatileInformationAreSet = false;

    public StoRIImpl(VirtualFSInterface vfs, MappingRule winnerRule, String relativeStFN, StoRIType type) {
        if (vfs != null) {
            this.vfs = vfs;
            this.capability = (Capability)vfs.getCapabilities();
        } else {
            this.log.error("!!! StoRI built without VFS!!?!");
        }
        if (winnerRule != null) {
            this.stfnRoot = winnerRule.getStFNRoot();
            this.stfn = this.stfnRoot + "/" + relativeStFN;
            try {
                this.vfsRoot = vfs.getRootPath();
            }
            catch (NamespaceException ex) {
                this.log.error("VFS is not setted.", (Throwable)ex);
            }
            this.relativeStFN = relativeStFN;
            this.stfnPath = NamespaceUtil.getStFNPath(this.stfn);
            this.relativePath = NamespaceUtil.consumeFileName(relativeStFN);
            if (this.relativePath != null) {
                if (this.relativePath.startsWith("/")) {
                    this.relativePath = this.relativePath.substring(1);
                }
            } else {
                this.relativePath = "/";
            }
            this.fileName = NamespaceUtil.getFileName(relativeStFN);
            this.log.debug("StFN Filename : " + this.fileName + " [StFN = '" + relativeStFN + "']");
            this.type = type == null ? (relativeStFN.endsWith("/") ? StoRIType.FOLDER : StoRIType.UNKNOWN) : type;
        } else {
            this.log.warn("StoRI built without MAPPIG RULE!!");
        }
    }

    public StoRIImpl(VirtualFSInterface vfs, String stfnStr, TLifeTimeInSeconds lifetime, StoRIType type) {
        this.vfs = vfs;
        this.capability = (Capability)vfs.getCapabilities();
        if (this.relativePath != null) {
            if (this.relativePath.startsWith("/")) {
                this.relativePath = this.relativePath.substring(1);
            }
        } else {
            this.relativePath = "/";
        }
        this.lifetime = lifetime;
        this.type = type == null ? StoRIType.UNKNOWN : type;
        this.stfnRoot = null;
        this.fileName = NamespaceUtil.getFileName(stfnStr);
        this.log.debug("StFN Filename : " + this.fileName + " [StFN = '" + stfnStr + "']");
        this.stfnPath = NamespaceUtil.getStFNPath(stfnStr);
        this.log.debug("StFN StFNPath : " + this.stfnPath + " [StFN = '" + stfnStr + "']");
    }

    @Override
    public void allotSpaceByToken(TSpaceToken token) throws ReservationException, ExpiredSpaceTokenException {
        LocalFile localfile = this.getLocalFile();
        if (this.spaceDriver == null) {
            try {
                this.spaceDriver = this.vfs.getSpaceSystemDriverInstance();
            }
            catch (NamespaceException ex) {
                this.log.error("Error while retrieving Space System Driver for VFS ", (Throwable)ex);
                throw new ReservationException("Error while retrieving Space System Driver for VFS ");
            }
        }
        try {
            this.vfs.useAllSpaceForFile(token, this);
        }
        catch (NamespaceException ex1) {
            this.log.error("Error while using Space with token '" + token + "' for " + this.fileName, (Throwable)ex1);
            throw new ReservationException("Error while using Space with token '" + token + "' for " + this.fileName);
        }
    }

    @Override
    public void allotSpaceByToken(TSpaceToken token, TSizeInBytes totSize) throws ReservationException, ExpiredSpaceTokenException {
        LocalFile localfile = this.getLocalFile();
        if (this.spaceDriver == null) {
            try {
                this.spaceDriver = this.vfs.getSpaceSystemDriverInstance();
            }
            catch (NamespaceException ex) {
                this.log.error("Error while retrieving Space System Driver for VFS ", (Throwable)ex);
                throw new ReservationException("Error while retrieving Space System Driver for VFS ");
            }
        }
        try {
            this.vfs.useSpaceForFile(token, this, totSize);
        }
        catch (NamespaceException ex1) {
            this.log.error("Error while using Space with token '" + token + "' for " + this.fileName, (Throwable)ex1);
            throw new ReservationException("Error while using Space with token '" + token + "' for " + this.fileName);
        }
    }

    @Override
    public void allotSpaceForFile(TSizeInBytes totSize) throws ReservationException {
        if (this.spaceDriver == null) {
            try {
                this.spaceDriver = this.vfs.getSpaceSystemDriverInstance();
            }
            catch (NamespaceException ex) {
                this.log.error("Error while retrieving Space System Driver for VFS ", (Throwable)ex);
                throw new ReservationException("Error while retrieving Space System Driver for VFS ");
            }
        }
        try {
            this.vfs.makeSilhouetteForFile(this, totSize);
        }
        catch (NamespaceException ex1) {
            this.log.error("Error while constructing 'Space Silhouette' for " + this.fileName, (Throwable)ex1);
            throw new ReservationException("Error while constructing 'Space Silhouette' for " + this.fileName);
        }
        this.log.debug("Space built. Space " + this.getSpace().getSpaceFile().getPath());
        this.getSpace().allot();
    }

    @Override
    public String getAbsolutePath() {
        try {
            return this.vfs.getRootPath() + "/" + this.relativeStFN;
        }
        catch (NamespaceException ex) {
            this.log.error("VFS Root path error", (Throwable)ex);
            return null;
        }
    }

    @Override
    public TLifeTimeInSeconds getFileLifeTime() {
        if (!this.volatileInformationAreSet) {
            this.setVolatileInformation();
        }
        return this.lifetime;
    }

    @Override
    public String getFilename() {
        return this.fileName;
    }

    @Override
    public Date getFileStartTime() {
        if (!this.volatileInformationAreSet) {
            this.setVolatileInformation();
        }
        return this.startTime;
    }

    @Override
    public ArrayList<StoRI> getChildren(TDirOption dirOption) throws InvalidDescendantsEmptyRequestException, InvalidDescendantsAuthRequestException, InvalidDescendantsPathRequestException, InvalidDescendantsFileRequestException {
        ArrayList<StoRI> stoRIList = new ArrayList<StoRI>();
        File fileHandle = new File(this.getAbsolutePath());
        if (!fileHandle.isDirectory()) {
            if (fileHandle.isFile()) {
                this.log.error("SURL represents a File, not a Directory!");
                throw new InvalidDescendantsFileRequestException(fileHandle);
            }
            this.log.warn("SURL does not exists!");
            throw new InvalidDescendantsPathRequestException(fileHandle);
        }
        PathCreator pCreator = new PathCreator(fileHandle, dirOption.isAllLevelRecursive(), 1);
        Collection<String> pathList = pCreator.generateChildren();
        if (pathList.size() == 0) {
            this.log.debug("SURL point to an EMPTY DIRECTORY");
            throw new InvalidDescendantsEmptyRequestException(fileHandle, pathList);
        }
        NamespaceInterface namespace = NamespaceDirector.getNamespace();
        for (String childPath : pathList) {
            this.log.debug("<GetChildren>:Creation of new StoRI with path : " + childPath);
            try {
                stoRIList.add(namespace.resolveStoRIbyAbsolutePath(childPath));
            }
            catch (NamespaceException ex) {
                this.log.error("Error occurred while resolving StoRI by absolute path", (Throwable)ex);
            }
        }
        return stoRIList;
    }

    @Override
    public LocalFile getLocalFile() {
        if (this.localFile == null) {
            try {
                this.fs = this.vfs.getFilesystem();
            }
            catch (NamespaceException ex) {
                this.log.error("Error while retrieving FS driver ", (Throwable)ex);
            }
            this.localFile = new LocalFile(this.getAbsolutePath(), this.fs);
        }
        return this.localFile;
    }

    @Override
    public MappingRule getMappingRule() {
        return this.winnerRule;
    }

    @Override
    public List<StoRI> getParents() {
        StoRIImpl createdStoRI = null;
        ArrayList<StoRI> parentList = new ArrayList<StoRI>();
        String consumeElements = this.relativePath;
        boolean lastElements = false;
        do {
            createdStoRI = new StoRIImpl(this.vfs, this.winnerRule, consumeElements, StoRIType.FOLDER);
            parentList.add(createdStoRI);
            String consumed = NamespaceUtil.consumeElement(consumeElements);
            if (consumed.equals(consumeElements)) {
                lastElements = true;
                continue;
            }
            consumeElements = consumed;
        } while (!lastElements);
        return parentList;
    }

    @Override
    public PFN getPFN() {
        if (this.pfn == null) {
            try {
                this.pfn = PFN.make(this.getAbsolutePath());
            }
            catch (InvalidPFNAttributeException ex) {
                this.log.error("Unable to build the PFN in the VFS '" + this.getVFSName() + "' with this path :'" + this.getAbsolutePath() + "'");
            }
        }
        return this.pfn;
    }

    @Override
    public String getRelativePath() {
        return this.relativePath;
    }

    @Override
    public String getRelativeStFN() {
        return this.relativeStFN;
    }

    @Override
    public Space getSpace() {
        if (this.space == null) {
            this.log.error("No space bound with this StoRI!");
            return null;
        }
        return this.space;
    }

    @Override
    public StFN getStFN() {
        StFN stfn = null;
        if (this.surl == null) {
            this.getSURL();
        }
        stfn = this.surl.sfn().stfn();
        return stfn;
    }

    @Override
    public String getStFNPath() {
        return this.stfnPath;
    }

    @Override
    public String getStFNRoot() {
        return this.stfnRoot;
    }

    @Override
    public StoRIType getStoRIType() {
        return this.type;
    }

    @Override
    public TSURL getSURL() {
        if (this.surl == null) {
            try {
                this.surl = TSURL.makeFromStringValidate(this.buildSURLString());
            }
            catch (InvalidTSURLAttributesException ex) {
                this.log.error("Unable to build the SURL with relative path : '" + this.relativePath + "'", (Throwable)ex);
            }
            catch (NamespaceException ex) {
                this.log.error("Unable to build the SURL with relative path : '" + this.relativePath + "'", (Throwable)ex);
            }
        }
        return this.surl;
    }

    @Override
    public TTURL getTURL(TURLPrefix desiredProtocols) throws IllegalArgumentException, InvalidGetTURLProtocolException, TURLBuildingException {
        TTURL resultTURL = null;
        if (desiredProtocols == null || desiredProtocols.size() == 0) {
            this.log.error("<GetTURL> request with NULL or empty prefixOfAcceptedTransferProtocol!");
            throw new IllegalArgumentException("unable to build the TTURL, invalid arguments: desiredProtocols=" + desiredProtocols);
        }
        ArrayList<Protocol> desiredP = new ArrayList<Protocol>(desiredProtocols.getDesiredProtocols());
        ArrayList<Protocol> availableP = new ArrayList<Protocol>(this.capability.getAllManagedProtocols());
        desiredP.retainAll(availableP);
        if (desiredP.isEmpty()) {
            this.log.error("stori:No match with Protocol Preferences and Protocol Managed!");
            throw new InvalidGetTURLProtocolException(desiredProtocols);
        }
        this.log.debug("Protocol matching.. Intersection size:" + desiredP.size());
        Protocol choosen = null;
        Authority authority = null;
        int index = 0;
        boolean turlBuilt = false;
        while (!turlBuilt && index < desiredP.size()) {
            block8: {
                choosen = desiredP.get(index);
                authority = null;
                this.log.debug("Selected Protocol :" + choosen);
                if (this.capability.isPooledProtocol(choosen)) {
                    this.log.debug("The protocol selected is in POOL Configuration");
                    try {
                        authority = this.getPooledAuthority(choosen);
                        break block8;
                    }
                    catch (BalancingStrategyException e) {
                        this.log.warn("Unable to get the pool member to be used to build the turl. BalancerException : " + e.getMessage());
                        ++index;
                        continue;
                    }
                }
                this.log.debug("The protocol selected is in NON-POOL Configuration");
                TransportProtocol transProt = null;
                List<TransportProtocol> protList = this.capability.getManagedProtocolByScheme(choosen);
                if (protList.size() > 1) {
                    this.log.warn("More than one protocol " + choosen + " defined but NOT in POOL Configuration. Taking the first one.");
                }
                transProt = protList.get(0);
                authority = transProt.getAuthority();
            }
            resultTURL = this.buildTURL(choosen, authority);
            turlBuilt = true;
        }
        if (!turlBuilt) {
            throw new TURLBuildingException("Unable to build the turl given protocols " + desiredP.toString());
        }
        return resultTURL;
    }

    @Override
    public VirtualFSInterface getVirtualFileSystem() {
        return this.vfs;
    }

    @Override
    public boolean hasJustInTimeACLs() {
        boolean result = true;
        if (this.aclMode.equals(Capability.ACLMode.UNDEF)) {
            this.aclMode = this.vfs.getCapabilities().getACLMode();
        }
        result = this.aclMode.equals(Capability.ACLMode.JUST_IN_TIME);
        return result;
    }

    @Override
    public void setGroupTapeRead() {
        String groupName = Configuration.getInstance().getGroupTapeReadBuffer();
        boolean isGroupDefined = LocalGroups.getInstance().isGroupDefined(groupName);
        if (isGroupDefined) {
            LocalFile localFile = this.getLocalFile();
            try {
                localFile.setGroupOwnership(groupName);
            }
            catch (FSException e) {
                this.log.warn("Unable to change in the new group owner ('" + groupName + "') of the file: " + localFile.getAbsolutePath());
            }
        } else {
            this.log.warn("The group for Read buffer in Tape support '" + groupName + "' is not defined.");
        }
    }

    @Override
    public void setGroupTapeWrite() {
        String groupName = Configuration.getInstance().getGroupTapeWriteBuffer();
        boolean isGroupDefined = LocalGroups.getInstance().isGroupDefined(groupName);
        if (isGroupDefined) {
            LocalFile localFile = this.getLocalFile();
            try {
                localFile.setGroupOwnership(groupName);
            }
            catch (FSException e) {
                this.log.warn("Unable to change in the new group owner ('" + groupName + "') of the file: " + localFile.getAbsolutePath());
            }
        } else {
            this.log.warn("The group for Write buffer in Tape support '" + groupName + "' is not defined.");
        }
    }

    @Override
    public void setMappingRule(MappingRule winnerRule) {
        this.winnerRule = winnerRule;
    }

    @Override
    public void setSpace(Space space) {
        this.space = space;
    }

    @Override
    public void setStFNRoot(String stfnRoot) {
        this.stfnRoot = stfnRoot;
    }

    @Override
    public void setStoRIType(StoRIType type) {
        this.type = type;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n");
        sb.append(" stori.stfn           : " + this.getStFN().toString() + "\n");
        sb.append(" stori.vfs-root       :" + this.vfsRoot + "\n");
        sb.append(" stori.absolutePath   : " + this.getAbsolutePath() + "\n");
        sb.append(" stori.vfs NAME       : " + this.getVFSName() + "\n");
        sb.append(" stori.stfn FileName  : " + this.fileName + "\n");
        sb.append(" stori.stfn StFN path : " + this.stfnPath + "\n");
        sb.append(" stori.stfn rel. Path : " + this.relativePath + "\n");
        sb.append(" stori.relative StFN  : " + this.relativeStFN + "\n");
        sb.append(" stori.stfn-root      : " + this.stfnRoot + "\n");
        sb.append(" story.type           : " + this.type + "\n");
        sb.append(" stori.SURL           : " + this.getSURL() + "\n");
        sb.append(" stori.localFile      : " + this.getLocalFile() + "\n");
        return sb.toString();
    }

    private String buildSURLString() throws NamespaceException {
        String stfn = this.stfnRoot + "/" + this.relativeStFN;
        SURL surl = new SURL(stfn);
        return surl.toString();
    }

    private TTURL buildTURL(Protocol protocol, Authority authority) throws InvalidProtocolForTURLException {
        TTURL result = null;
        switch (protocol.getProtocolIndex()) {
            case 0: {
                throw new InvalidProtocolForTURLException(protocol.getSchema());
            }
            case 1: {
                result = TURLBuilder.buildFileTURL(authority, this.getPFN());
                break;
            }
            case 2: {
                result = TURLBuilder.buildGsiftpTURL(authority, this.getPFN());
                break;
            }
            case 3: {
                result = TURLBuilder.buildRFIOTURL(authority, this.getPFN());
                break;
            }
            case 4: {
                throw new InvalidProtocolForTURLException(protocol.getSchema());
            }
            case 5: {
                result = TURLBuilder.buildROOTTURL(authority, this.getPFN());
                break;
            }
            case 6: {
                try {
                    result = TURLBuilder.buildHTTPTURL(authority, this.getLocalFile());
                    break;
                }
                catch (HTTPSPluginException e) {
                    this.log.error("Unable to build the TURL for protocol " + protocol.toString() + " for authority " + authority.toString() + " and file " + this.getLocalFile().toString() + " . HTTPSPluginException: " + e.getMessage());
                    throw new InvalidProtocolForTURLException(e, protocol.getSchema());
                }
            }
            case 7: {
                try {
                    result = TURLBuilder.buildHTTPSTURL(authority, this.getLocalFile());
                    break;
                }
                catch (HTTPSPluginException e) {
                    this.log.error("Unable to build the TURL for protocol " + protocol.toString() + " for authority " + authority.toString() + " and file " + this.getLocalFile().toString() + " . HTTPSPluginException: " + e.getMessage());
                    throw new InvalidProtocolForTURLException(e, protocol.getSchema());
                }
            }
            default: {
                throw new InvalidProtocolForTURLException(protocol.getSchema());
            }
        }
        return result;
    }

    private Authority getPooledAuthority(Protocol pooledProtocol) throws BalancingStrategyException {
        Authority authority = null;
        if (pooledProtocol.equals(Protocol.GSIFTP) || pooledProtocol.equals(Protocol.HTTP) || pooledProtocol.equals(Protocol.HTTPS)) {
            BalancingStrategy<? extends Node> bal = this.vfs.getProtocolBalancingStrategy(pooledProtocol);
            if (bal != null) {
                Node node = bal.getNextElement();
                authority = new Authority(node.getHostName(), node.getPort());
            }
        } else {
            this.log.error("Unable to manage pool with protocol different from GSIFTP.");
        }
        return authority;
    }

    private String getVFSName() {
        String result = "UNDEF";
        if (this.vfs != null) {
            result = this.vfs.getAliasName();
        }
        return result;
    }

    private void setVolatileInformation() {
        VolatileAndJiTCatalog catalog = VolatileAndJiTCatalog.getInstance();
        List volatileInfo = catalog.volatileInfoOn(this.getPFN());
        if (volatileInfo.size() != 2) {
            this.lifetime = TLifeTimeInSeconds.makeInfinite();
            this.startTime = null;
            return;
        }
        this.startTime = new Date(((Calendar)volatileInfo.get(0)).getTimeInMillis());
        this.lifetime = (TLifeTimeInSeconds)volatileInfo.get(1);
        this.volatileInformationAreSet = true;
    }
}

